/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import scala.concurrent.forkjoin.TransferQueue;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int NOWAIT = 0;
    static final int TIMEOUT = 1;
    static final int WAIT = 2;
    static final int NCPUS = Runtime.getRuntime().availableProcessors();
    static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    static final int maxUntimedSpins = maxTimedSpins * 16;
    static final long spinForTimeoutThreshold = 1000L;
    private final transient PaddedAtomicReference<QNode> head;
    private final transient PaddedAtomicReference<QNode> tail;
    private final transient PaddedAtomicReference<QNode> cleanMe;
    private static final Unsafe _unsafe;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long cleanMeOffset;

    private boolean advanceHead(QNode h, QNode nh) {
        if (h == this.head.get() && this.head.compareAndSet(h, nh)) {
            h.clearNext();
            return true;
        }
        return false;
    }

    private Object xfer(Object e, int mode, long nanos) {
        Object x2;
        QNode first;
        boolean isData = e != null;
        QNode s = null;
        PaddedAtomicReference<QNode> head2 = this.head;
        PaddedAtomicReference<QNode> tail2 = this.tail;
        while (true) {
            QNode t = (QNode)tail2.get();
            QNode h = (QNode)head2.get();
            if (t != null && (t == h || t.isData == isData)) {
                QNode last2;
                if (s == null) {
                    s = new QNode(e, isData);
                }
                if ((last2 = t.next) != null) {
                    if (t != tail2.get()) continue;
                    tail2.compareAndSet(t, last2);
                    continue;
                }
                if (!t.casNext(null, s)) continue;
                tail2.compareAndSet(t, s);
                return this.awaitFulfill(t, s, e, mode, nanos);
            }
            if (h == null) continue;
            first = h.next;
            if (t == tail2.get() && first != null && this.advanceHead(h, first) && (x2 = first.get()) != first && first.compareAndSet(x2, e)) break;
        }
        LockSupport.unpark(first.waiter);
        return isData ? e : x2;
    }

    private Object fulfill(Object e) {
        Object x2;
        QNode first;
        boolean isData = e != null;
        PaddedAtomicReference<QNode> head2 = this.head;
        PaddedAtomicReference<QNode> tail2 = this.tail;
        while (true) {
            QNode t = (QNode)tail2.get();
            QNode h = (QNode)head2.get();
            if (t != null && (t == h || t.isData == isData)) {
                QNode last2 = t.next;
                if (t != tail2.get()) continue;
                if (last2 != null) {
                    tail2.compareAndSet(t, last2);
                    continue;
                }
                return null;
            }
            if (h == null) continue;
            first = h.next;
            if (t == tail2.get() && first != null && this.advanceHead(h, first) && (x2 = first.get()) != first && first.compareAndSet(x2, e)) break;
        }
        LockSupport.unpark(first.waiter);
        return isData ? e : x2;
    }

    private Object awaitFulfill(QNode pred, QNode s, Object e, int mode, long nanos) {
        if (mode == 0) {
            return null;
        }
        long lastTime = mode == 1 ? System.nanoTime() : 0L;
        Thread w = Thread.currentThread();
        int spins = -1;
        while (true) {
            long now;
            Object x2;
            if (w.isInterrupted()) {
                s.compareAndSet(e, s);
            }
            if ((x2 = s.get()) != e) {
                this.advanceHead(pred, s);
                if (x2 == s) {
                    this.clean(pred, s);
                    return null;
                }
                if (x2 != null) {
                    s.set(s);
                    return x2;
                }
                return e;
            }
            if (mode == 1 && (nanos -= (now = System.nanoTime()) - (lastTime = now)) <= 0L) {
                s.compareAndSet(e, s);
                continue;
            }
            if (spins < 0) {
                QNode h = (QNode)this.head.get();
                int n = h != null && h.next == s ? (mode == 1 ? maxTimedSpins : maxUntimedSpins) : (spins = 0);
            }
            if (spins > 0) {
                --spins;
                continue;
            }
            if (s.waiter == null) {
                s.waiter = w;
                continue;
            }
            if (mode != 1) {
                LockSupport.park(this);
                s.waiter = null;
                spins = -1;
                continue;
            }
            if (nanos <= 1000L) continue;
            LockSupport.parkNanos(this, nanos);
            s.waiter = null;
            spins = -1;
        }
    }

    private QNode getValidatedTail() {
        QNode t;
        while (true) {
            QNode h = (QNode)this.head.get();
            QNode first = h.next;
            if (first != null && first.next == first) {
                this.advanceHead(h, first);
                continue;
            }
            t = (QNode)this.tail.get();
            QNode last2 = t.next;
            if (t != this.tail.get()) continue;
            if (last2 == null) break;
            this.tail.compareAndSet(t, last2);
        }
        return t;
    }

    private void clean(QNode pred, QNode s) {
        Thread w = s.waiter;
        if (w != null) {
            s.waiter = null;
            if (w != Thread.currentThread()) {
                LockSupport.unpark(w);
            }
        }
        if (pred == null) {
            return;
        }
        while (pred.next == s) {
            QNode sn;
            QNode oldpred = this.reclean();
            QNode t = this.getValidatedTail();
            if (!(s != t ? (sn = s.next) == s || pred.casNext(s, sn) : oldpred == pred || oldpred == null && this.cleanMe.compareAndSet(null, pred))) continue;
            break;
        }
    }

    private QNode reclean() {
        QNode t;
        QNode s;
        QNode pred;
        while ((pred = (QNode)this.cleanMe.get()) != null && (s = pred.next) != (t = this.getValidatedTail())) {
            QNode sn;
            if (s != null && s != pred && s.get() == s && (sn = s.next) != s && !pred.casNext(s, sn)) continue;
            this.cleanMe.compareAndSet(pred, null);
        }
        return pred;
    }

    public LinkedTransferQueue() {
        QNode dummy = new QNode(null, false);
        this.head = new PaddedAtomicReference<QNode>(dummy);
        this.tail = new PaddedAtomicReference<QNode>(dummy);
        this.cleanMe = new PaddedAtomicReference<Object>(null);
    }

    public LinkedTransferQueue(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public void transfer(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 2, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 1, unit.toNanos(timeout)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean tryTransfer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.fulfill(e) != null;
    }

    @Override
    public E take() throws InterruptedException {
        Object e = this.xfer(null, 2, 0L);
        if (e != null) {
            return (E)e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = this.xfer(null, 1, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return (E)e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return (E)this.fulfill(null);
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        int n;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
            c.add(e);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QNode traversalHead() {
        while (true) {
            QNode t = (QNode)this.tail.get();
            QNode h = (QNode)this.head.get();
            if (h != null && t != null) {
                QNode last2 = t.next;
                QNode first = h.next;
                if (t == this.tail.get()) {
                    if (last2 != null) {
                        this.tail.compareAndSet(t, last2);
                    } else {
                        if (first == null) return h;
                        Object x2 = first.get();
                        if (x2 != first) return h;
                        this.advanceHead(h, first);
                    }
                }
            }
            this.reclean();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        Object x2;
        while (true) {
            QNode h = this.traversalHead();
            QNode p = h.next;
            if (p == null) {
                return null;
            }
            x2 = p.get();
            if (p == x2) continue;
            if (!p.isData) {
                return null;
            }
            if (x2 != null) break;
        }
        return (E)x2;
    }

    @Override
    public boolean isEmpty() {
        while (true) {
            QNode h = this.traversalHead();
            QNode p = h.next;
            if (p == null) {
                return true;
            }
            Object x2 = p.get();
            if (p == x2) continue;
            if (!p.isData) {
                return true;
            }
            if (x2 != null) break;
        }
        return false;
    }

    @Override
    public boolean hasWaitingConsumer() {
        Object x2;
        QNode p;
        do {
            QNode h = this.traversalHead();
            p = h.next;
            if (p != null) continue;
            return false;
        } while (p == (x2 = p.get()));
        return !p.isData;
    }

    @Override
    public int size() {
        Object x2;
        int count2 = 0;
        QNode h = this.traversalHead();
        QNode p = h.next;
        while (p != null && p.isData && ((x2 = p.get()) == null || x2 == p || ++count2 != Integer.MAX_VALUE)) {
            p = p.next;
        }
        return count2;
    }

    @Override
    public int getWaitingConsumerCount() {
        int count2 = 0;
        QNode h = this.traversalHead();
        QNode p = h.next;
        while (!(p == null || p.isData || p.get() == null && ++count2 == Integer.MAX_VALUE)) {
            p = p.next;
        }
        return count2;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        block0: while (true) {
            QNode pred = this.traversalHead();
            while (true) {
                QNode q;
                if ((q = pred.next) == null || !q.isData) {
                    return false;
                }
                if (q == pred) continue block0;
                Object x2 = q.get();
                if (x2 != null && x2 != q && o.equals(x2) && q.compareAndSet(x2, q)) {
                    this.clean(pred, q);
                    return true;
                }
                pred = q;
            }
            break;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (E e : this) {
            s.writeObject(e);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        Object item;
        s.defaultReadObject();
        this.resetHeadAndTail();
        while ((item = s.readObject()) != null) {
            this.offer(item);
        }
    }

    private void resetHeadAndTail() {
        QNode dummy = new QNode(null, false);
        _unsafe.putObjectVolatile(this, headOffset, new PaddedAtomicReference<QNode>(dummy));
        _unsafe.putObjectVolatile(this, tailOffset, new PaddedAtomicReference<QNode>(dummy));
        _unsafe.putObjectVolatile(this, cleanMeOffset, new PaddedAtomicReference<Object>(null));
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return LinkedTransferQueue.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw e.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
        f2.setAccessible(true);
        return (Unsafe)f2.get(null);
    }

    private static long fieldOffset(String fieldName) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(LinkedTransferQueue.class.getDeclaredField(fieldName));
    }

    static {
        try {
            _unsafe = LinkedTransferQueue.getUnsafe();
            headOffset = LinkedTransferQueue.fieldOffset("head");
            tailOffset = LinkedTransferQueue.fieldOffset("tail");
            cleanMeOffset = LinkedTransferQueue.fieldOffset("cleanMe");
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not initialize intrinsics", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Itr
    implements Iterator<E> {
        QNode next;
        QNode pnext;
        QNode snext;
        QNode curr;
        QNode pcurr;
        E nextItem;

        Itr() {
            this.findNext();
        }

        void findNext() {
            while (true) {
                QNode pred = this.pnext;
                QNode q = this.next;
                if (pred == null || pred == q) {
                    pred = LinkedTransferQueue.this.traversalHead();
                    q = pred.next;
                }
                if (q == null || !q.isData) {
                    this.next = null;
                    return;
                }
                Object x2 = q.get();
                QNode s = q.next;
                if (x2 != null && q != x2 && q != s) {
                    this.nextItem = x2;
                    this.snext = s;
                    this.pnext = pred;
                    this.next = q;
                    return;
                }
                this.pnext = q;
                this.next = s;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.pcurr = this.pnext;
            this.curr = this.next;
            this.pnext = this.next;
            this.next = this.snext;
            Object x2 = this.nextItem;
            this.findNext();
            return x2;
        }

        @Override
        public void remove() {
            QNode p = this.curr;
            if (p == null) {
                throw new IllegalStateException();
            }
            Object x2 = p.get();
            if (x2 != null && x2 != p && p.compareAndSet(x2, p)) {
                LinkedTransferQueue.this.clean(this.pcurr, p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PaddedAtomicReference<T>
    extends AtomicReference<T> {
        Object p0;
        Object p1;
        Object p2;
        Object p3;
        Object p4;
        Object p5;
        Object p6;
        Object p7;
        Object p8;
        Object p9;
        Object pa;
        Object pb;
        Object pc;
        Object pd;
        Object pe;

        PaddedAtomicReference(T r) {
            super(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class QNode
    extends AtomicReference<Object> {
        volatile QNode next;
        volatile Thread waiter;
        final boolean isData;
        static final AtomicReferenceFieldUpdater<QNode, QNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");

        QNode(Object item, boolean isData) {
            super(item);
            this.isData = isData;
        }

        final boolean casNext(QNode cmp, QNode val) {
            return nextUpdater.compareAndSet(this, cmp, val);
        }

        final void clearNext() {
            nextUpdater.lazySet(this, this);
        }
    }
}

