/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal.pool;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.fusesource.hawtdispatch.internal.NioManager;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;
import org.fusesource.hawtdispatch.internal.WorkerThread;
import org.fusesource.hawtdispatch.internal.pool.SimplePool;

public class SimpleThread
extends WorkerThread {
    private SimplePool pool;
    private ThreadDispatchQueue threadQueue;
    private final NioManager nioManager;
    public static final boolean DEBUG = false;

    public SimpleThread(SimplePool pool) throws IOException {
        super(pool.group, pool.name);
        this.pool = pool;
        this.nioManager = new NioManager();
        this.threadQueue = new ThreadDispatchQueue(pool.globalQueue, this);
    }

    public ThreadDispatchQueue getDispatchQueue() {
        return this.threadQueue;
    }

    public void unpark() {
        this.nioManager.wakeupIfSelecting();
    }

    public NioManager getNioManager() {
        return this.nioManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.debug("run start", new Object[0]);
        try {
            ConcurrentLinkedQueue<Runnable> sharedQueue = this.pool.runnables;
            while (!this.pool.shutdown) {
                Runnable runnable = this.threadQueue.poll();
                if (runnable == null && (runnable = sharedQueue.poll()) == null) {
                    runnable = this.threadQueue.getSourceQueue().poll();
                }
                if (runnable == null) {
                    this.pool.park(this);
                    continue;
                }
                runnable.run();
            }
        }
        finally {
            this.debug("run end", new Object[0]);
        }
    }

    protected void debug(String str, Object ... args) {
    }

    protected void debug(Throwable thrown, String str, Object ... args) {
    }
}

