/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.node;

import java.util.Calendar;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.resources.node.Description;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.common.KPlatform;
import org.gcube.common.resources.kxml.utils.KBoolean;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KDescription {
    /*
     * Enabled aggressive block sorting
     */
    public static Description load(KXmlParser parser) throws Exception {
        Description d = new Description();
        while (true) {
            switch (parser.next()) {
                case 2: {
                    Pair p;
                    Calendar cal;
                    if (parser.getName().equals("Name")) {
                        d.setName(parser.nextText());
                    }
                    if (parser.getName().equals("ActivationTime")) {
                        cal = Calendar.getInstance();
                        cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.nextText()));
                        d.setActivationTime(cal);
                    }
                    if (parser.getName().equals("Status")) {
                        d.setStatus(GHNContext.Status.valueOf(parser.nextText().toUpperCase()), new String[0]);
                    }
                    if (parser.getName().equals("StatusMessage")) {
                        d.setStatusMessage(parser.nextText());
                    }
                    if (parser.getName().equals("Type")) {
                        d.setType(Description.Type.valueOf(parser.nextText()));
                    }
                    if (parser.getName().equals("AvailablePlatforms")) {
                        block11: while (true) {
                            switch (parser.next()) {
                                case 2: {
                                    if (!parser.getName().equals("Platform")) break;
                                    d.getAvailablePlatforms().add(KPlatform.load(parser, parser.getName()));
                                    break;
                                }
                                case 3: {
                                    if (!parser.getName().equals("AvailablePlatforms")) break;
                                    break block11;
                                }
                                case 1: {
                                    throw new Exception("Parsing failed at AvailablePlatforms");
                                }
                            }
                        }
                    }
                    if (parser.getName().equals("SecurityEnabled")) {
                        d.setSecurityEnabled(KBoolean.load(parser));
                    }
                    if (parser.getName().equals("SecurityData")) {
                        d.addSecurityData(KSecurityData.load(parser));
                    }
                    if (parser.getName().equals("Architecture")) {
                        d.setArchitecture(KArchitecture.load(parser));
                    }
                    if (parser.getName().equals("OperatingSystem")) {
                        d.setOS(KOS.load(parser));
                    }
                    if (parser.getName().equals("Processor")) {
                        d.getProcessors().add(KProcessor.load(parser));
                    }
                    if (parser.getName().equals("NetworkAdapter")) {
                        d.getNetworkAdapters().add(KAdapter.load(parser));
                    }
                    if (parser.getName().equals("Benchmark")) {
                        d.setBenchmark(KBenchmark.load(parser));
                    }
                    if (parser.getName().equals("RunTimeEnv")) {
                        d.setRuntime(KRuntime.load(parser));
                    }
                    if (parser.getName().equals("StorageDevice")) {
                        d.addStorageDevice(KDevice.load(parser));
                    }
                    if (parser.getName().equals("StoragePartition")) {
                        d.addStoragePartition(KPartition.load(parser));
                    }
                    if (parser.getName().equals("LocalFileSystem")) {
                        d.addLocalFileSystem(KFileSystem.load("LocalFileSystem", parser));
                    }
                    if (parser.getName().equals("RemoteFileSystem")) {
                        d.addRemoteFileSystem(KFileSystem.load("RemoteFileSystem", parser));
                    }
                    if (parser.getName().equals("StorageDevice2StoragePartition")) {
                        p = KDevice2Partition.load(parser);
                        Description.StorageDevice sd = d.getStorageDevice(p.getFirst());
                        if (sd == null) {
                            throw new Exception("Storage Device " + p.getFirst() + " is unknown");
                        }
                        Description.StoragePartition sp = d.getStoragePartition(p.getSecond());
                        if (sp == null) {
                            throw new Exception("Storage Partition " + p.getSecond() + " is unknown");
                        }
                        sd.getPartitions().put(sp.getName(), sp);
                    }
                    if (parser.getName().equals("StoragePartition2FileSystem")) {
                        p = KPartition2FS.load(parser);
                        Description.StoragePartition sp = d.getStoragePartition(p.getFirst());
                        if (sp == null) {
                            throw new Exception("Storage Partition " + p.getSecond() + " is unknown");
                        }
                        Description.FileSystem fs = d.getLocalFileSystem(p.getSecond());
                        if (fs == null && (fs = d.getRemoteFileSystem(p.getSecond())) == null) {
                            throw new Exception("File System " + p.getFirst() + " is unknown");
                        }
                        sp.getFileSystems().put(fs.getName(), fs);
                    }
                    if (parser.getName().equals("Uptime")) {
                        d.setUptime(parser.nextText());
                    }
                    if (parser.getName().equals("Load")) {
                        d.setLoad(KLoad.load(parser));
                    }
                    if (parser.getName().equals("HistoricalLoad")) {
                        d.setHistoricalLoad(KHistoricalLoad.load(parser));
                    }
                    if (parser.getName().equals("MainMemory")) {
                        d.setMemory(KMemory.load(parser));
                    }
                    if (parser.getName().equals("LocalAvailableSpace")) {
                        d.setLocalAvailableSpace(Long.valueOf(parser.nextText()));
                    }
                    if (!parser.getName().equals("LastUpdate")) break;
                    cal = Calendar.getInstance();
                    cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.nextText()));
                    d.setLastUpdate(cal);
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("GHNDescription")) break;
                    return d;
                }
                case 1: {
                    throw new Exception("Parsing failed at GHNDescription");
                }
            }
        }
    }

    public static void store(Description component, KXmlSerializer serializer) throws Exception {
        Pair p;
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "GHNDescription");
        if (component.getName() != null) {
            serializer.startTag(KGCUBEResource.NS, "Name").text(component.getName()).endTag(KGCUBEResource.NS, "Name");
        }
        if (component.getActivationTime() != null) {
            serializer.startTag(KGCUBEResource.NS, "ActivationTime").text(KGCUBEResource.toXMLDateAndTime(component.getActivationTime().getTime())).endTag(KGCUBEResource.NS, "ActivationTime");
        }
        if (component.getStatus() != null) {
            serializer.startTag(KGCUBEResource.NS, "Status").text(component.getStatus().toString()).endTag(KGCUBEResource.NS, "Status");
        }
        if (component.getStatusMessage() != null) {
            serializer.startTag(KGCUBEResource.NS, "StatusMessage").text(component.getStatusMessage()).endTag(KGCUBEResource.NS, "StatusMessage");
        }
        if (component.getType() != null) {
            serializer.startTag(KGCUBEResource.NS, "Type").text(component.getType().toString()).endTag(KGCUBEResource.NS, "Type");
        }
        if (component.getAvailablePlatforms().size() > 0) {
            serializer.startTag(KGCUBEResource.NS, "AvailablePlatforms");
            for (PlatformDescription platformDescription : component.getAvailablePlatforms()) {
                KPlatform.store(platformDescription, serializer, "Platform");
            }
            serializer.endTag(KGCUBEResource.NS, "AvailablePlatforms");
        }
        serializer.startTag(KGCUBEResource.NS, "SecurityEnabled");
        KBoolean.store(component.isSecurityEnabled(), serializer);
        serializer.endTag(KGCUBEResource.NS, "SecurityEnabled");
        KSecurityData.store(component.getSecurityData(), serializer);
        KArchitecture.store(component.getArchitecture(), serializer);
        KOS.store(component.getOS(), serializer);
        for (Description.Processor processor : component.getProcessors()) {
            KProcessor.store(processor, serializer);
        }
        for (Description.NetworkAdapter networkAdapter : component.getNetworkAdapters()) {
            KAdapter.store(networkAdapter, serializer);
        }
        KBenchmark.store(component.getBenchmark(), serializer);
        KRuntime.store(component.getRuntime(), serializer);
        for (Description.StorageDevice storageDevice : component.getStorageDevices()) {
            KDevice.store(storageDevice, serializer);
        }
        for (Description.StoragePartition storagePartition : component.getStoragePartitions()) {
            KPartition.store(storagePartition, serializer);
        }
        for (Description.FileSystem fileSystem : component.getLocalFileSystems()) {
            KFileSystem.store("LocalFileSystem", fileSystem, serializer);
        }
        for (Description.FileSystem fileSystem : component.getRemoteFileSystems()) {
            KFileSystem.store("RemoteFileSystem", fileSystem, serializer);
        }
        for (Description.StorageDevice storageDevice : component.getStorageDevices()) {
            for (Description.StoragePartition partition : storageDevice.getPartitions().values()) {
                p = new Pair();
                p.setFirst(storageDevice.getName());
                p.setSecond(partition.getName());
                KDevice2Partition.store(p, serializer);
            }
        }
        for (Description.StoragePartition storagePartition : component.getStoragePartitions()) {
            for (Description.FileSystem fs : storagePartition.getFileSystems().values()) {
                p = new Pair();
                p.setFirst(storagePartition.getName());
                p.setSecond(fs.getName());
                KDevice2Partition.store(p, serializer);
            }
        }
        if (component.getUptime() != null) {
            serializer.startTag(KGCUBEResource.NS, "Uptime").text(component.getUptime()).endTag(KGCUBEResource.NS, "Uptime");
        }
        KLoad.store(component.getLoad(), serializer);
        KHistoricalLoad.store(component.getHistoricalLoad(), serializer);
        KMemory.store(component.getMemory(), serializer);
        if (component.getLocalAvailableSpace() != null) {
            serializer.startTag(KGCUBEResource.NS, "LocalAvailableSpace").text(component.getLocalAvailableSpace() + "").endTag(KGCUBEResource.NS, "LocalAvailableSpace");
        }
        if (component.getLastUpdate() != null) {
            serializer.startTag(KGCUBEResource.NS, "LastUpdate").text(KGCUBEResource.toXMLDateAndTime(component.getLastUpdate().getTime())).endTag(KGCUBEResource.NS, "LastUpdate");
        }
        serializer.endTag(KGCUBEResource.NS, "GHNDescription");
    }

    public static class KMemory {
        public static Description.Memory load(KXmlParser parser) throws Exception {
            Description.Memory l = new Description.Memory();
            if (parser.getAttributeValue(KGCUBEResource.NS, "RAMSize") != null) {
                l.setSize(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "RAMSize")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "VirtualSize") != null) {
                l.setVirtualSize(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "VirtualSize")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "RAMAvailable") != null) {
                l.setAvailable(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "RAMAvailable")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "VirtualAvailable") != null) {
                l.setVirtualAvailable(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "VirtualAvailable")));
            }
            return l;
        }

        public static void store(Description.Memory component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "MainMemory");
            if (component.getSize() != null) {
                serializer.attribute(KGCUBEResource.NS, "RAMSize", component.getSize().toString());
            }
            if (component.getVirtualSize() != null) {
                serializer.attribute(KGCUBEResource.NS, "VirtualSize", component.getVirtualSize().toString());
            }
            if (component.getAvailable() != null) {
                serializer.attribute(KGCUBEResource.NS, "RAMAvailable", component.getAvailable().toString());
            }
            if (component.getVirtualAvailable() != null) {
                serializer.attribute(KGCUBEResource.NS, "VirtualAvailable", component.getVirtualAvailable().toString());
            }
            serializer.endTag(KGCUBEResource.NS, "MainMemory");
        }
    }

    public static class KHistoricalLoad {
        public static Description.HistoricalLoad load(KXmlParser parser) throws Exception {
            Description.HistoricalLoad l = new Description.HistoricalLoad();
            if (parser.getAttributeValue(KGCUBEResource.NS, "Last1H") != null) {
                l.setLast1Hour(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Last1H")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "Last1Day") != null) {
                l.setLast1Day(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Last1Day")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "Last1Week") != null) {
                l.setLast1Week(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Last1Week")));
            }
            return l;
        }

        public static void store(Description.HistoricalLoad component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "HistoricalLoad");
            if (component.getLast1Hour() != null) {
                serializer.attribute(KGCUBEResource.NS, "Last1H", component.getLast1Hour().toString());
            }
            if (component.getLast1Day() != null) {
                serializer.attribute(KGCUBEResource.NS, "Last1Day", component.getLast1Day().toString());
            }
            if (component.getLast1Week() != null) {
                serializer.attribute(KGCUBEResource.NS, "Last1Week", component.getLast1Week().toString());
            }
            serializer.endTag(KGCUBEResource.NS, "HistoricalLoad");
        }
    }

    public static class KLoad {
        public static Description.Load load(KXmlParser parser) throws Exception {
            Description.Load l = new Description.Load();
            if (parser.getAttributeValue(KGCUBEResource.NS, "Last1Min") != null) {
                l.setLast1min(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Last1Min")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "Last5Min") != null) {
                l.setLast5min(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Last5Min")));
            }
            if (parser.getAttributeValue(KGCUBEResource.NS, "Last15Min") != null) {
                l.setLast15min(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Last15Min")));
            }
            return l;
        }

        public static void store(Description.Load component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Load");
            if (component.getLast1min() != null) {
                serializer.attribute(KGCUBEResource.NS, "Last1Min", component.getLast1min().toString());
            }
            if (component.getLast5min() != null) {
                serializer.attribute(KGCUBEResource.NS, "Last5Min", component.getLast5min().toString());
            }
            if (component.getLast15min() != null) {
                serializer.attribute(KGCUBEResource.NS, "Last15Min", component.getLast15min().toString());
            }
            serializer.endTag(KGCUBEResource.NS, "Load");
        }
    }

    public static class KPartition2FS {
        public static Pair load(KXmlParser parser) throws Exception {
            Pair p = new Pair();
            p.setFirst(parser.getAttributeValue(KGCUBEResource.NS, "StoragePartitionName"));
            p.setSecond(parser.getAttributeValue(KGCUBEResource.NS, "FileSystemName"));
            return p;
        }

        public static void store(Pair component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "StoragePartition2FileSystem");
            if (component.getFirst() != null) {
                serializer.attribute(KGCUBEResource.NS, "StoragePartitionName", component.getFirst());
            }
            if (component.getSecond() != null) {
                serializer.attribute(KGCUBEResource.NS, "FileSystemName", component.getSecond());
            }
            serializer.endTag(KGCUBEResource.NS, "StoragePartition2FileSystem");
        }
    }

    public static class KDevice2Partition {
        public static Pair load(KXmlParser parser) throws Exception {
            Pair p = new Pair();
            p.setFirst(parser.getAttributeValue(KGCUBEResource.NS, "StorageDeviceName"));
            p.setSecond(parser.getAttributeValue(KGCUBEResource.NS, "StoragePartitionName"));
            return p;
        }

        public static void store(Pair component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "StorageDevice2StoragePartition");
            if (component.getFirst() != null) {
                serializer.attribute(KGCUBEResource.NS, "StorageDeviceName", component.getFirst());
            }
            if (component.getSecond() != null) {
                serializer.attribute(KGCUBEResource.NS, "StoragePartitionName", component.getSecond());
            }
            serializer.endTag(KGCUBEResource.NS, "StorageDevice2StoragePartition");
        }
    }

    static class Pair {
        private String first;
        private String second;

        Pair() {
        }

        String getFirst() {
            return this.first;
        }

        String getSecond() {
            return this.second;
        }

        void setFirst(String first) {
            this.first = first;
        }

        void setSecond(String second) {
            this.second = second;
        }
    }

    public static class KFileSystem {
        public static Description.FileSystem load(String rootTag, KXmlParser parser) throws Exception {
            Description.FileSystem fs = new Description.FileSystem();
            fs.setName(parser.getAttributeValue(KGCUBEResource.NS, "Name"));
            fs.setRoot(parser.getAttributeValue(KGCUBEResource.NS, "Root"));
            fs.setSize(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Size")));
            fs.setReadOnly(Boolean.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "ReadOnly")));
            fs.setType(parser.getAttributeValue(KGCUBEResource.NS, "Type"));
            return fs;
        }

        public static void store(String rootTag, Description.FileSystem component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, rootTag);
            if (component.getName() != null) {
                serializer.attribute(KGCUBEResource.NS, "Name", component.getName());
            }
            if (component.getRoot() != null) {
                serializer.attribute(KGCUBEResource.NS, "Root", component.getRoot());
            }
            serializer.attribute(KGCUBEResource.NS, "Size", component.getSize() + "");
            serializer.attribute(KGCUBEResource.NS, "ReadOnly", component.isReadOnly() + "");
            if (component.getType() != null) {
                serializer.attribute(KGCUBEResource.NS, "Type", component.getType());
            }
            serializer.endTag(KGCUBEResource.NS, rootTag);
        }
    }

    public static class KPartition {
        public static Description.StoragePartition load(KXmlParser parser) throws Exception {
            Description.StoragePartition p = new Description.StoragePartition();
            p.setName(parser.getAttributeValue(KGCUBEResource.NS, "Name"));
            p.setSize(parser.getAttributeValue(KGCUBEResource.NS, "Size"));
            p.setReadRate(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "ReadRate")));
            p.setWriteRate(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "WriteRate")));
            return p;
        }

        public static void store(Description.StoragePartition component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "StoragePartition");
            if (component.getName() != null) {
                serializer.attribute(KGCUBEResource.NS, "Name", component.getName());
            }
            if (component.getSize() != null) {
                serializer.attribute(KGCUBEResource.NS, "Size", component.getSize());
            }
            serializer.attribute(KGCUBEResource.NS, "ReadRate", component.getReadRate() + "");
            serializer.attribute(KGCUBEResource.NS, "WriteRate", component.getWriteRate() + "");
            serializer.endTag(KGCUBEResource.NS, "StoragePartition");
        }
    }

    public static class KDevice {
        public static Description.StorageDevice load(KXmlParser parser) throws Exception {
            Description.StorageDevice var = new Description.StorageDevice();
            var.setName(parser.getAttributeValue(KGCUBEResource.NS, "Name"));
            var.setType(parser.getAttributeValue(KGCUBEResource.NS, "Type"));
            var.setTransferRate(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "TransferRate")));
            var.setSize(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Size")));
            return var;
        }

        public static void store(Description.StorageDevice component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "StorageDevice");
            if (component.getName() != null) {
                serializer.attribute(KGCUBEResource.NS, "Name", component.getName());
            }
            if (component.getType() != null) {
                serializer.attribute(KGCUBEResource.NS, "Type", component.getType());
            }
            serializer.attribute(KGCUBEResource.NS, "TransferRate", component.getTransferRate() + "");
            serializer.attribute(KGCUBEResource.NS, "Size", component.getSize() + "");
            serializer.endTag(KGCUBEResource.NS, "StorageDevice");
        }
    }

    public static class KRuntime {
        /*
         * Enabled aggressive block sorting
         */
        public static Description.RuntimeEnvironment load(KXmlParser parser) throws Exception {
            Description.RuntimeEnvironment rt = new Description.RuntimeEnvironment();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (!parser.getName().equals("Variable")) break;
                        rt.getVariables().add(KVariable.load(parser));
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("RunTimeEnv")) break;
                        return rt;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at RunTimeEnv");
                    }
                }
            }
        }

        public static void store(Description.RuntimeEnvironment component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "RunTimeEnv");
            if (component.getVariables().size() != 0) {
                for (Description.RuntimeEnvironment.Variable v : component.getVariables()) {
                    KVariable.store(v, serializer);
                }
            }
            serializer.endTag(KGCUBEResource.NS, "RunTimeEnv");
        }

        public static class KVariable {
            /*
             * Enabled aggressive block sorting
             */
            public static Description.RuntimeEnvironment.Variable load(KXmlParser parser) throws Exception {
                Description.RuntimeEnvironment.Variable var = new Description.RuntimeEnvironment.Variable();
                while (true) {
                    switch (parser.next()) {
                        case 2: {
                            if (parser.getName().equals("Key")) {
                                var.setKey(parser.nextText());
                            }
                            if (!parser.getName().equals("Value")) break;
                            var.setValue(parser.nextText());
                            break;
                        }
                        case 3: {
                            if (!parser.getName().equals("Variable")) break;
                            return var;
                        }
                        case 1: {
                            throw new Exception("Parsing failed at Variable");
                        }
                    }
                }
            }

            public static void store(Description.RuntimeEnvironment.Variable component, KXmlSerializer serializer) throws Exception {
                if (component == null) {
                    return;
                }
                serializer.startTag(KGCUBEResource.NS, "Variable");
                if (component.getKey() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Key").text(component.getKey()).endTag(KGCUBEResource.NS, "Key");
                }
                if (component.getValue() != null) {
                    serializer.startTag(KGCUBEResource.NS, "Value").text(component.getValue()).endTag(KGCUBEResource.NS, "Value");
                }
                serializer.endTag(KGCUBEResource.NS, "Variable");
            }
        }
    }

    public static class KBenchmark {
        public static Description.Benchmark load(KXmlParser parser) throws Exception {
            Description.Benchmark b = new Description.Benchmark();
            b.setSI00(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "SI00")));
            b.setSI00(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "SF00")));
            return b;
        }

        public static void store(Description.Benchmark component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Benchmark");
            serializer.attribute(KGCUBEResource.NS, "SI00", component.getSI00() + "");
            serializer.attribute(KGCUBEResource.NS, "SF00", component.getSI00() + "");
            serializer.endTag(KGCUBEResource.NS, "Benchmark");
        }
    }

    public static class KAdapter {
        public static Description.NetworkAdapter load(KXmlParser parser) throws Exception {
            Description.NetworkAdapter a = new Description.NetworkAdapter();
            a.setInboundIP(parser.getAttributeValue(KGCUBEResource.NS, "InboundIP"));
            a.setOutboundIP(parser.getAttributeValue(KGCUBEResource.NS, "OutboundIP"));
            a.setName(parser.getAttributeValue(KGCUBEResource.NS, "Name"));
            a.setIPAddress(parser.getAttributeValue(KGCUBEResource.NS, "IPAddress"));
            a.setMTU(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "MTU")));
            return a;
        }

        public static void store(Description.NetworkAdapter component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "NetworkAdapter");
            if (component.getInboundIP() != null) {
                serializer.attribute(KGCUBEResource.NS, "InboundIP", component.getInboundIP());
            }
            if (component.getOutboundIP() != null) {
                serializer.attribute(KGCUBEResource.NS, "OutboundIP", component.getOutboundIP());
            }
            if (component.getName() != null) {
                serializer.attribute(KGCUBEResource.NS, "Name", component.getName());
            }
            if (component.getIPAddress() != null) {
                serializer.attribute(KGCUBEResource.NS, "IPAddress", component.getIPAddress());
            }
            serializer.attribute(KGCUBEResource.NS, "MTU", component.getMTU() + "");
            serializer.endTag(KGCUBEResource.NS, "NetworkAdapter");
        }
    }

    public static class KProcessor {
        public static Description.Processor load(KXmlParser parser) throws Exception {
            Description.Processor p = new Description.Processor();
            p.setVendor(parser.getAttributeValue(KGCUBEResource.NS, "Vendor"));
            p.setModel(parser.getAttributeValue(KGCUBEResource.NS, "Model"));
            p.setModelName(parser.getAttributeValue(KGCUBEResource.NS, "ModelName"));
            p.setFamily(parser.getAttributeValue(KGCUBEResource.NS, "Family"));
            p.setClockSpeedMHZ(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "ClockSpeedMhz")));
            p.setBogomips(Double.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "Bogomips")));
            p.setCacheL1(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "CacheL1")));
            p.setCacheL1I(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "CacheL1I")));
            p.setCacheL1D(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "CacheL1D")));
            p.setCacheL2(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "CacheL2")));
            return p;
        }

        public static void store(Description.Processor component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Processor");
            if (component.getVendor() != null) {
                serializer.attribute(KGCUBEResource.NS, "Vendor", component.getVendor());
            }
            if (component.getModel() != null) {
                serializer.attribute(KGCUBEResource.NS, "Model", component.getModel());
            }
            if (component.getModelName() != null) {
                serializer.attribute(KGCUBEResource.NS, "ModelName", component.getModelName());
            }
            if (component.getFamily() != null) {
                serializer.attribute(KGCUBEResource.NS, "Family", component.getFamily());
            }
            serializer.attribute(KGCUBEResource.NS, "ClockSpeedMhz", component.getClockSpeedMHZ() + "");
            serializer.attribute(KGCUBEResource.NS, "Bogomips", component.getBogomips() + "");
            serializer.attribute(KGCUBEResource.NS, "CacheL1", component.getCacheL1() + "");
            serializer.attribute(KGCUBEResource.NS, "CacheL1I", component.getCacheL1I() + "");
            serializer.attribute(KGCUBEResource.NS, "CacheL1D", component.getCacheL1D() + "");
            serializer.attribute(KGCUBEResource.NS, "CacheL2", component.getCacheL2() + "");
            serializer.endTag(KGCUBEResource.NS, "Processor");
        }
    }

    public static class KOS {
        public static Description.OperatingSystem load(KXmlParser parser) throws Exception {
            Description.OperatingSystem os = new Description.OperatingSystem();
            os.setName(parser.getAttributeValue(KGCUBEResource.NS, "Name"));
            os.setRelease(parser.getAttributeValue(KGCUBEResource.NS, "Release"));
            os.setVersion(parser.getAttributeValue(KGCUBEResource.NS, "Version"));
            return os;
        }

        public static void store(Description.OperatingSystem component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "OperatingSystem");
            if (component.getName() != null) {
                serializer.attribute(KGCUBEResource.NS, "Name", component.getName());
            }
            if (component.getRelease() != null) {
                serializer.attribute(KGCUBEResource.NS, "Release", component.getRelease() + "");
            }
            if (component.getVersion() != null) {
                serializer.attribute(KGCUBEResource.NS, "Version", component.getVersion() + "");
            }
            serializer.endTag(KGCUBEResource.NS, "OperatingSystem");
        }
    }

    public static class KSecurityData {
        /*
         * Enabled aggressive block sorting
         */
        public static Description.SecurityData load(KXmlParser parser) throws Exception {
            Description.SecurityData data = new Description.SecurityData();
            while (true) {
                switch (parser.next()) {
                    case 2: {
                        if (parser.getName().equals("CredentialsExpireOn")) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(KGCUBEResource.fromXMLDateAndTime(parser.nextText()));
                            data.setCredentianlsExpireOn(cal);
                        }
                        if (parser.getName().equals("CredentialsDistinguishedName")) {
                            data.setCredentialsDistinguishedName(parser.nextText());
                        }
                        if (parser.getName().equals("CA")) {
                            data.setCA(parser.nextText());
                        }
                    }
                    case 3: {
                        if (!parser.getName().equals("SecurityData")) break;
                        return data;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at SecurityData");
                    }
                }
            }
        }

        public static void store(Description.SecurityData component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "SecurityData");
            if (component.getCredentialsDistinguishedName() != null) {
                serializer.startTag(KGCUBEResource.NS, "CA").text(component.getCA()).endTag(KGCUBEResource.NS, "CA");
            }
            if (component.getCredentialsDistinguishedName() != null) {
                serializer.startTag(KGCUBEResource.NS, "CredentialsDistinguishedName").text(component.getCredentialsDistinguishedName()).endTag(KGCUBEResource.NS, "CredentialsDistinguishedName");
            }
            if (component.getCredentianlsExpireOn() != null) {
                serializer.startTag(KGCUBEResource.NS, "CredentialsExpireOn").text(KGCUBEResource.toXMLDateAndTime(component.getCredentianlsExpireOn().getTime())).endTag(KGCUBEResource.NS, "CredentialsExpireOn");
            }
            serializer.endTag(KGCUBEResource.NS, "SecurityData");
        }
    }

    public static class KArchitecture {
        public static Description.Architecture load(KXmlParser parser) throws Exception {
            Description.Architecture a = new Description.Architecture();
            a.setPlatformType(parser.getAttributeValue(KGCUBEResource.NS, "PlatformType"));
            a.setSMPSize(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "SMPSize")));
            a.setSMPSize(Long.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "SMTSize")));
            return a;
        }

        public static void store(Description.Architecture component, KXmlSerializer serializer) throws Exception {
            if (component == null) {
                return;
            }
            serializer.startTag(KGCUBEResource.NS, "Architecture");
            if (component.getPlatformType() != null) {
                serializer.attribute(KGCUBEResource.NS, "PlatformType", component.getPlatformType());
            }
            serializer.attribute(KGCUBEResource.NS, "SMPSize", component.getSMPSize() + "");
            serializer.attribute(KGCUBEResource.NS, "SMTSize", component.getSMTSize() + "");
            serializer.endTag(KGCUBEResource.NS, "Architecture");
        }
    }
}

