/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.GarbageCollector;

import java.io.File;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.resultsetservice.stubs.ReclaimNotificationMessageType;
import org.gcube.common.searchservice.resultsetservice.stubs.ReclaimNotificationMessageWrapperType;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.Arnold;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCHelper;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCPolicy;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCProperties;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.globus.wsrf.impl.SimpleTopic;

public class GarbageCollect
implements Runnable {
    private static Logger log = Logger.getLogger(GarbageCollect.class);
    private static SimpleTopic reclaimingEprs;

    public GarbageCollect(SimpleTopic simpleTopic) {
        reclaimingEprs = simpleTopic;
    }

    public static void main(String[] stringArray) throws Exception {
        File file = new File("/tmp/resultset/");
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            log.error((Object)"Could not initialize message digest for SHA-1. Throwing Exception", (Throwable)exception);
            throw new Exception("Could not initialize message digest for SHA-1");
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            int n;
            ReclaimNotificationMessageWrapperType reclaimNotificationMessageWrapperType;
            Object[] objectArray;
            Vector<String> vector = new Vector<String>();
            try {
                if (!file.exists() || !file.isDirectory()) {
                    log.warn((Object)"Base directory /tmp/resultset/ is not a directory");
                } else {
                    objectArray = file.listFiles();
                    for (int i = 0; i < objectArray.length; ++i) {
                        try {
                            if (!((File)objectArray[i]).isDirectory()) continue;
                            reclaimNotificationMessageWrapperType = ((File)objectArray[i]).listFiles();
                            for (n = 0; n < ((File[])reclaimNotificationMessageWrapperType).length; ++n) {
                                try {
                                    int n2;
                                    log.trace((Object)("checking for file " + reclaimNotificationMessageWrapperType[n].toString()));
                                    if (!reclaimNotificationMessageWrapperType[n].exists()) {
                                        log.trace((Object)"doesn't exist aymore");
                                        continue;
                                    }
                                    if (GCHelper.alreadyChecked(reclaimNotificationMessageWrapperType[n].toString(), messageDigest, hashSet)) continue;
                                    if (reclaimNotificationMessageWrapperType[n].isFile() && (reclaimNotificationMessageWrapperType[n].toString().endsWith(".prs") || reclaimNotificationMessageWrapperType[n].toString().endsWith(".tmp"))) {
                                        if (!GCPolicy.reclaim((File)reclaimNotificationMessageWrapperType[n])) continue;
                                        Arnold.terminate((File)reclaimNotificationMessageWrapperType[n]);
                                        continue;
                                    }
                                    if (reclaimNotificationMessageWrapperType[n].isFile() && reclaimNotificationMessageWrapperType[n].toString().endsWith(".rs") && !new File(RSFileHelper.contentToHeader((String)reclaimNotificationMessageWrapperType[n].toString())).exists()) {
                                        if (!GCPolicy.reclaim((File)reclaimNotificationMessageWrapperType[n])) continue;
                                        Arnold.terminate((File)reclaimNotificationMessageWrapperType[n]);
                                        continue;
                                    }
                                    if (!reclaimNotificationMessageWrapperType[n].isFile() || !reclaimNotificationMessageWrapperType[n].toString().endsWith(".hrs")) continue;
                                    GCProperties gCProperties = new GCProperties();
                                    gCProperties.addToChain(reclaimNotificationMessageWrapperType[n].toString());
                                    String string = GCHelper.goToHead(reclaimNotificationMessageWrapperType[n].toString(), gCProperties);
                                    String string2 = GCHelper.goToLast(reclaimNotificationMessageWrapperType[n].toString(), gCProperties);
                                    GCHelper.headPoperties(string, gCProperties);
                                    GCHelper.tailPoperties(string2, gCProperties);
                                    if (GCPolicy.reclaim(gCProperties)) {
                                        for (n2 = 0; n2 < gCProperties.getWSEPRs().size(); ++n2) {
                                            vector.add(gCProperties.getWSEPRs().get(n2));
                                        }
                                        Arnold.terminate(gCProperties);
                                        continue;
                                    }
                                    for (n2 = 0; n2 < gCProperties.getChainOfFiles().size(); ++n2) {
                                        GCHelper.alreadyChecked(gCProperties.getChainOfFiles().get(n2), messageDigest, hashSet);
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    log.error((Object)"Could not evaluate file. Continuing", (Throwable)exception);
                                }
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            log.error((Object)"Could not evaluate directory. Continuing", (Throwable)exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)"Could not complete iteration. Continuing", (Throwable)exception);
            }
            try {
                objectArray = vector.toArray(new String[vector.size()]);
                if (objectArray != null && objectArray.length > 0) {
                    ReclaimNotificationMessageType reclaimNotificationMessageType = new ReclaimNotificationMessageType();
                    reclaimNotificationMessageType.setReclaimedEpr((String[])objectArray);
                    reclaimNotificationMessageWrapperType = new ReclaimNotificationMessageWrapperType(reclaimNotificationMessageType);
                    reclaimingEprs.notify((Object)reclaimNotificationMessageWrapperType);
                    log.info((Object)("notification sent for " + objectArray.length + " eprs: "));
                    for (n = 0; n < objectArray.length; ++n) {
                        log.info((Object)(n + ": " + (String)objectArray[n]));
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)"Could not send Notification. Continuing", (Throwable)exception);
            }
            hashSet.clear();
            try {
                log.info((Object)"Garbadge collector sleep");
                Thread.sleep(300000L);
                continue;
            }
            catch (Exception exception) {
                log.info((Object)"Garbadge collector wake up");
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        try {
            log.info((Object)"Garbadge collector to start in 10");
            Thread.currentThread().setPriority(1);
            Thread.sleep(300000L);
            log.info((Object)"Garbadge collector is enabled");
            GarbageCollect.main(null);
        }
        catch (Exception exception) {
            log.error((Object)"Garbadge collector failed to start", (Throwable)exception);
        }
    }
}

