/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.message.addressing.tools.wsdl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaAddressingServiceIfaceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaAddressingServiceIfaceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "Addressing", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends " + this.sEntry.getName();
    }

    protected String getClassText() {
        return "interface ";
    }

    protected String getImplementsText() {
        return " ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        Map portMap = service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBinding01", (String[])new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBindingEntry01", (String[])new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoPortType01", (String[])new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId((String)portName)) {
                portName = Utils.xmlNameToJavaClass((String)portName);
            }
            String stubClass = bEntry.getName() + "Stub";
            String bindingType = (String)bEntry.getDynamicVar((Object)JavaBindingWriter.INTERFACE_NAME);
            pw.println("    public " + bindingType + " get" + portName + "(org.apache.axis.message.addressing.EndpointReferenceType reference) " + "throws javax.xml.rpc.ServiceException;");
            pw.println();
        }
        pw.println();
    }
}

