/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.servicegroup.client;

import commonj.timers.Timer;
import commonj.timers.TimerListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.mds.servicegroup.client.ServiceGroupRegistrationParameters;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClientCallback;
import org.globus.wsrf.impl.timer.TimerManagerImpl;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsrf.lifetime.ScheduledResourceTermination;
import org.oasis.wsrf.lifetime.SetTerminationTime;
import org.oasis.wsrf.lifetime.WSResourceLifetimeServiceAddressingLocator;
import org.oasis.wsrf.properties.GetResourceProperty;
import org.oasis.wsrf.properties.GetResourcePropertyResponse;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.WSResourcePropertiesServiceAddressingLocator;
import org.oasis.wsrf.servicegroup.Add;
import org.oasis.wsrf.servicegroup.ServiceGroupRegistration;
import org.oasis.wsrf.servicegroup.ServiceGroupServiceAddressingLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceGroupRegistrationClient {
    static final int INITIAL_DELAY_CONTAINER = 30000;
    private int initialDelay = 0;
    private static ServiceGroupRegistrationClient containerClient = null;
    private List registrations = Collections.synchronizedList(new ArrayList());
    private TimerManagerImpl timerManager = new TimerManagerImpl();
    private BaseClient baseClient = null;
    private EndpointReferenceType defaultServiceGroupEPR = null;
    private EndpointReferenceType defaultRegistrantEPR = null;
    private String defaultSecDescFile = null;
    private ServiceGroupRegistrationClientCallback clientCallback = null;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$servicegroup$client$ServiceGroupRegistrationClient == null ? (class$org$globus$wsrf$impl$servicegroup$client$ServiceGroupRegistrationClient = ServiceGroupRegistrationClient.class$("org.globus.wsrf.impl.servicegroup.client.ServiceGroupRegistrationClient")) : class$org$globus$wsrf$impl$servicegroup$client$ServiceGroupRegistrationClient).getName());
    private static final ServiceGroupServiceAddressingLocator sgloc = new ServiceGroupServiceAddressingLocator();
    private static final WSResourceLifetimeServiceAddressingLocator lifetimeloc = new WSResourceLifetimeServiceAddressingLocator();
    private static final int LIFETIMECONST = 2;
    public boolean isDebug = false;
    public boolean outputToConsole = false;
    private boolean outputToLog = logger.isErrorEnabled();
    public static final String TAG_SG_EPR = "defaultServiceGroupEPR";
    public static final String TAG_REG_EPR = "defaultRegistrantEPR";
    public static final String TAG_SEC_DESC = "defaultSecurityDecriptorFile";
    public static final String TAG_PARAMS = "ServiceGroupRegistrationParameters";
    public static final String TAG_NS = "http://mds.globus.org/servicegroup/client";
    private static final int LOG_I = 0;
    private static final int LOG_E = 1;
    private static final int LOG_W = 2;
    private static final int LOG_D = 3;
    static /* synthetic */ Class class$org$globus$wsrf$impl$servicegroup$client$ServiceGroupRegistrationClient;
    static /* synthetic */ Class class$org$apache$axis$message$addressing$EndpointReferenceType;
    static /* synthetic */ Class class$org$globus$mds$servicegroup$client$ServiceGroupRegistrationParameters;
    static /* synthetic */ Class class$java$util$Calendar;

    public ServiceGroupRegistrationClient() {
        this.isDebug = logger.isDebugEnabled();
    }

    public ServiceGroupRegistrationClient(BaseClient baseClient) {
        this.baseClient = baseClient;
        this.defaultServiceGroupEPR = baseClient.getEPR();
        if (this.baseClient != null) {
            this.outputToConsole = true;
            this.isDebug = this.baseClient.isDebugMode();
        }
    }

    public void setClientCallback(ServiceGroupRegistrationClientCallback callback) {
        this.clientCallback = callback;
    }

    public ServiceGroupRegistrationClientCallback getClientCallback() {
        return this.clientCallback;
    }

    public void setDefaultEPR(EndpointReferenceType defaultEPR) {
        this.setDefaultServiceGroupEPR(defaultEPR);
    }

    public void setDefaultServiceGroupEPR(EndpointReferenceType epr) {
        this.defaultServiceGroupEPR = epr;
    }

    public EndpointReferenceType getDefaultServiceGroupEPR() {
        return this.defaultServiceGroupEPR;
    }

    public void setRegistrantEPR(EndpointReferenceType epr) {
        this.defaultRegistrantEPR = epr;
    }

    public EndpointReferenceType getRegistrantEPR() {
        return this.defaultRegistrantEPR;
    }

    public void setDefaultSecDescFile(String f) {
        this.defaultSecDescFile = f;
    }

    public void setInitialDelay(int d) {
        this.initialDelay = d;
    }

    /*
     * Unable to fully structure code
     */
    public void processConfigFile(String fileName) throws Exception {
        block17: {
            input = null;
            doc = null;
            root = null;
            try {
                this.status(3, "Trying to locate config file: " + fileName);
                input = new FileInputStream(fileName);
                doc = XmlUtils.newDocument((InputStream)input);
                root = doc.getDocumentElement();
                var7_5 = null;
                ** if (input == null) goto lbl-1000
            }
            catch (Throwable var6_13) {
                var7_6 = null;
                if (input != null) {
                    input.close();
                }
                throw var6_13;
            }
lbl-1000:
            // 1 sources

            {
                input.close();
            }
lbl-1000:
            // 1 sources

            {
                break block17;
                catch (Exception e) {
                    throw e;
                }
            }
        }
        nodes = root.getChildNodes();
        length = nodes.getLength();
        if (length == 0) {
            throw new Exception("Configuration File Error: No valid elements to process");
        }
        numEntries = 0;
        for (i = 0; i < length; ++i) {
            node = nodes.item(i);
            if ("defaultServiceGroupEPR".equalsIgnoreCase(node.getLocalName())) {
                epr = (EndpointReferenceType)ObjectDeserializer.toObject((Element)((Element)node), (Class)(ServiceGroupRegistrationClient.class$org$apache$axis$message$addressing$EndpointReferenceType == null ? ServiceGroupRegistrationClient.class$("org.apache.axis.message.addressing.EndpointReferenceType") : ServiceGroupRegistrationClient.class$org$apache$axis$message$addressing$EndpointReferenceType));
                if (epr == null) continue;
                this.defaultServiceGroupEPR = epr;
                continue;
            }
            if ("defaultRegistrantEPR".equalsIgnoreCase(node.getLocalName())) {
                epr = (EndpointReferenceType)ObjectDeserializer.toObject((Element)((Element)node), (Class)(ServiceGroupRegistrationClient.class$org$apache$axis$message$addressing$EndpointReferenceType == null ? ServiceGroupRegistrationClient.class$("org.apache.axis.message.addressing.EndpointReferenceType") : ServiceGroupRegistrationClient.class$org$apache$axis$message$addressing$EndpointReferenceType));
                if (epr == null) continue;
                this.defaultRegistrantEPR = epr;
                continue;
            }
            if ("defaultSecurityDecriptorFile".equalsIgnoreCase(node.getLocalName())) {
                file = node.getNodeValue();
                if (file == null) continue;
                this.defaultSecDescFile = file;
                continue;
            }
            if (!"ServiceGroupRegistrationParameters".equalsIgnoreCase(node.getLocalName())) continue;
            params = null;
            try {
                this.status(3, "Deserializing Registration entry...");
                params = (ServiceGroupRegistrationParameters)ObjectDeserializer.toObject((Element)((Element)node), (Class)(ServiceGroupRegistrationClient.class$org$globus$mds$servicegroup$client$ServiceGroupRegistrationParameters == null ? ServiceGroupRegistrationClient.class$("org.globus.mds.servicegroup.client.ServiceGroupRegistrationParameters") : ServiceGroupRegistrationClient.class$org$globus$mds$servicegroup$client$ServiceGroupRegistrationParameters));
            }
            catch (Exception e) {
                this.status(1, "Configuration File Error: " + e.toString());
                if (!this.isDebug) continue;
                this.status(3, "Deserialization Failed for: " + XMLUtils.ElementToString((Element)((Element)node)));
                continue;
            }
            ++numEntries;
            this.register(params, 0L);
        }
        if (numEntries == 0) {
            throw new Exception("Configuration File Error: No valid entries to register");
        }
        this.status("Processed " + Integer.toString(numEntries) + " registration entries");
    }

    public Timer register(ServiceGroupRegistrationParameters params, long delayMillis) {
        Timer timer = this.timerManager.schedule((TimerListener)new RegTimer(params), delayMillis, (long)(params.getRefreshIntervalSecs() * 1000));
        this.registrations.add(timer);
        return timer;
    }

    public Timer register(ServiceGroupRegistrationParameters params) {
        return this.register(params, this.initialDelay);
    }

    public void terminate() {
        this.reset();
        this.status("ServiceGroupRegistrationClient shut down");
    }

    private void reset() {
        this.status(3, "Reset registrant list");
        int i = 0;
        while (!this.registrations.isEmpty()) {
            Timer timer = (Timer)this.registrations.remove(0);
            if (timer == null) {
                this.status(2, "Null Timer found during reset");
                continue;
            }
            timer.cancel();
            ++i;
        }
        this.status(i + " registration event(s) cancelled");
    }

    private void status(Object obj) {
        this.status(0, obj);
    }

    private void status(int msgType, Object obj) {
        if (this.outputToConsole) {
            if (msgType == 1 || msgType == 2) {
                System.err.println(obj);
            } else if (msgType == 3) {
                if (this.isDebug) {
                    System.out.println(obj);
                }
            } else {
                System.out.println(obj);
            }
        } else if (this.outputToLog) {
            switch (msgType) {
                case 1: {
                    logger.error(obj);
                    break;
                }
                case 2: {
                    logger.warn(obj);
                    break;
                }
                case 3: {
                    logger.debug(obj);
                    break;
                }
                default: {
                    logger.info(obj);
                }
            }
        }
    }

    public static synchronized ServiceGroupRegistrationClient getContainerClient() {
        if (containerClient != null) {
            return containerClient;
        }
        containerClient = new ServiceGroupRegistrationClient();
        containerClient.setInitialDelay(30000);
        try {
            containerClient.setDefaultServiceGroupEPR(null);
        }
        catch (Exception e) {
            logger.error((Object)("Exception when setting default index service: " + e));
        }
        return containerClient;
    }

    public static EndpointReferenceType getIndexEPR() throws MalformedURLException, IOException, URI.MalformedURIException {
        EndpointReferenceType indexEPR = new EndpointReferenceType();
        URL baseURL = ServiceHost.getBaseURL();
        URL indexURL = new URL(baseURL, "DefaultIndexService");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Container registration client will register to local index at " + indexURL));
        }
        indexEPR.setAddress((AttributedURI)new Address(indexURL.toString()));
        return indexEPR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceGroupRegistrationParameters readParams(String filename) throws Exception {
        FileInputStream inputStream = null;
        try {
            ServiceGroupRegistrationParameters params;
            inputStream = new FileInputStream(filename);
            Document doc = XMLUtils.newDocument((InputStream)inputStream);
            ServiceGroupRegistrationParameters serviceGroupRegistrationParameters = params = (ServiceGroupRegistrationParameters)ObjectDeserializer.toObject((Element)doc.getDocumentElement(), (Class)(class$org$globus$mds$servicegroup$client$ServiceGroupRegistrationParameters == null ? (class$org$globus$mds$servicegroup$client$ServiceGroupRegistrationParameters = ServiceGroupRegistrationClient.class$("org.globus.mds.servicegroup.client.ServiceGroupRegistrationParameters")) : class$org$globus$mds$servicegroup$client$ServiceGroupRegistrationParameters));
            return serviceGroupRegistrationParameters;
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    public static Timer register(EndpointReferenceType epr, String regFile) throws Exception {
        return ServiceGroupRegistrationClient.register(ResourceContext.getResourceContext(), epr, regFile);
    }

    public static Timer register(ResourceContext ctx, EndpointReferenceType epr, String regFile) throws Exception {
        String regPath = ctx.getProperty("configPath") + regFile;
        ServiceGroupRegistrationParameters params = ServiceGroupRegistrationClient.readParams(regPath);
        params.setRegistrantEPR(epr);
        ServiceGroupRegistrationClient client = ServiceGroupRegistrationClient.getContainerClient();
        return client.register(params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RegTimer
    implements TimerListener {
        private boolean maybeHasLifetime = true;
        private ServiceGroupRegistrationParameters parameters = null;
        private EndpointReferenceType entryEPR = null;
        private final WSResourcePropertiesServiceAddressingLocator rpLocator = new WSResourcePropertiesServiceAddressingLocator();

        public RegTimer(ServiceGroupRegistrationParameters parameters) {
            this.parameters = parameters;
        }

        public ServiceGroupRegistrationParameters getParameters() {
            return this.parameters;
        }

        public void cancel(Timer timer) {
            try {
                timer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServiceGroupRegistrationClient.this.registrations.remove(timer);
        }

        public void setSecurity(Stub port) throws Exception {
            if (ServiceGroupRegistrationClient.this.baseClient != null) {
                ServiceGroupRegistrationClient.this.baseClient.setOptions(port);
            } else {
                String secDescFile = null;
                secDescFile = this.parameters.getSecurityDescriptorFile();
                if (secDescFile == null) {
                    secDescFile = ServiceGroupRegistrationClient.this.defaultSecDescFile;
                }
                if (secDescFile != null) {
                    port._setProperty("clientDescriptorFile", (Object)secDescFile);
                } else {
                    port._setProperty("org.globus.gsi.anonymous", (Object)Boolean.TRUE);
                    port._setProperty("org.globus.security.authorization", (Object)org.globus.wsrf.impl.security.authorization.NoAuthorization.getInstance());
                    port._setProperty("org.globus.gsi.authorization", (Object)NoAuthorization.getInstance());
                }
            }
        }

        public void timerExpired(Timer timer) {
            block24: {
                EndpointReferenceType registrantEPR;
                EndpointReferenceType epr;
                if (this.parameters == null) {
                    String msg = "Error: Registration event got null parameters (Registration event will be canceled)";
                    ServiceGroupRegistrationClient.this.status(1, msg);
                    this.cancel(timer);
                    return;
                }
                ServiceGroupRegistrationClientCallback callback = ServiceGroupRegistrationClient.this.getClientCallback();
                EndpointReferenceType endpointReferenceType = epr = this.parameters.getServiceGroupEPR() != null ? this.parameters.getServiceGroupEPR() : ServiceGroupRegistrationClient.this.defaultServiceGroupEPR;
                if (epr == null) {
                    try {
                        epr = ServiceGroupRegistrationClient.getIndexEPR();
                    }
                    catch (Exception e) {
                        logger.error((Object)("When forming local target index EPR: " + e));
                    }
                }
                EndpointReferenceType endpointReferenceType2 = registrantEPR = this.parameters.getRegistrantEPR() != null ? this.parameters.getRegistrantEPR() : ServiceGroupRegistrationClient.this.defaultRegistrantEPR;
                if (registrantEPR == null) {
                    try {
                        registrantEPR = ServiceGroupRegistrationClient.getIndexEPR();
                    }
                    catch (Exception e) {
                        logger.error((Object)("When forming local registrant index EPR: " + e));
                    }
                }
                try {
                    boolean successfullyRenewed;
                    ServiceGroupRegistration port;
                    block23: {
                        port = sgloc.getServiceGroupRegistrationPort(epr);
                        this.setSecurity((Stub)port);
                        if (ServiceGroupRegistrationClient.this.isDebug) {
                            ServiceGroupRegistrationClient.this.status(3, "Renewing/Adding: " + ObjectSerializer.toString((Object)this.parameters, (QName)ServiceGroupRegistrationParameters.getTypeDesc().getXmlType()));
                        }
                        Calendar term = this.getCurrentTimePreferringRemote(this.entryEPR);
                        term.add(13, 2 * this.parameters.getRefreshIntervalSecs());
                        this.parameters.setInitialTerminationTime(term);
                        successfullyRenewed = false;
                        if (this.entryEPR != null && this.maybeHasLifetime) {
                            try {
                                ServiceGroupRegistrationClient.this.status(3, "Attempting lifetime extension of entry");
                                ScheduledResourceTermination lifetimePort = lifetimeloc.getScheduledResourceTerminationPort(this.entryEPR);
                                this.setSecurity((Stub)lifetimePort);
                                SetTerminationTime setTermTimeReq = new SetTerminationTime();
                                setTermTimeReq.setRequestedTerminationTime(this.parameters.getInitialTerminationTime());
                                lifetimePort.setTerminationTime(setTermTimeReq);
                                successfullyRenewed = true;
                                if (callback != null && !callback.setRegistrationStatus(this.parameters, true, true, null)) {
                                    this.cancel(timer);
                                    if (ServiceGroupRegistrationClient.this.isDebug) {
                                        ServiceGroupRegistrationClient.this.status(3, "Canceled registration event for: " + this.entryEPR.getAddress());
                                    }
                                    return;
                                }
                            }
                            catch (Exception e) {
                                ServiceGroupRegistrationClient.this.status(2, "Exception renewing entry lifetime of a registration for " + this.entryEPR.getAddress() + " - " + e);
                                if (callback == null || callback.setRegistrationStatus(this.parameters, false, true, e)) break block23;
                                this.cancel(timer);
                                if (ServiceGroupRegistrationClient.this.isDebug) {
                                    ServiceGroupRegistrationClient.this.status(3, "Canceled registration event for: " + this.entryEPR.getAddress());
                                }
                                return;
                            }
                        }
                    }
                    if (!successfullyRenewed) {
                        ServiceGroupRegistrationClient.this.status(3, "Attempting add");
                        Add request = new Add();
                        request.setMemberEPR(registrantEPR);
                        request.setContent(this.parameters.getContent());
                        if (this.parameters.getInitialTerminationTime() == null) {
                            ServiceGroupRegistrationClient.this.status(1, "No termination time computed for new registation.");
                        }
                        request.setInitialTerminationTime(this.parameters.getInitialTerminationTime());
                        this.entryEPR = port.add(request);
                        if (ServiceGroupRegistrationClient.this.isDebug) {
                            ServiceGroupRegistrationClient.this.status(3, "Add response: " + AnyHelper.toSingleString((AnyContentType)this.entryEPR));
                        }
                        if (callback != null && !callback.setRegistrationStatus(this.parameters, true, false, null)) {
                            this.cancel(timer);
                            if (ServiceGroupRegistrationClient.this.isDebug) {
                                ServiceGroupRegistrationClient.this.status(3, "Canceled registration event for: " + this.entryEPR.getAddress());
                            }
                            return;
                        }
                        if (ServiceGroupRegistrationClient.this.outputToConsole || ServiceGroupRegistrationClient.this.isDebug) {
                            String msg = "Successfully registered " + registrantEPR.getAddress() + " to servicegroup at " + epr.getAddress();
                            ServiceGroupRegistrationClient.this.status(msg);
                        }
                    }
                }
                catch (Exception e) {
                    String msg = "Warning: Could not register " + registrantEPR.getAddress() + " to servicegroup at " + epr.getAddress() + " -- check the URL and that the remote service is up. " + " Remote exception was " + FaultHelper.getMessage((Throwable)e);
                    ServiceGroupRegistrationClient.this.status(2, msg);
                    if (callback == null || callback.setRegistrationStatus(this.parameters, false, false, e)) break block24;
                    this.cancel(timer);
                    if (ServiceGroupRegistrationClient.this.isDebug) {
                        ServiceGroupRegistrationClient.this.status(3, "Canceled registration event for: " + this.entryEPR.getAddress());
                    }
                    return;
                }
            }
        }

        private Calendar getCurrentTimePreferringRemote(EndpointReferenceType epr) {
            ServiceGroupRegistrationClient.this.status(3, "Attempting to get current time, preferring remote.");
            Calendar now = null;
            if (epr != null && this.maybeHasLifetime) {
                try {
                    GetResourceProperty getRPPort = this.rpLocator.getGetResourcePropertyPort(epr);
                    this.setSecurity((Stub)getRPPort);
                    GetResourcePropertyResponse resp = getRPPort.getResourceProperty(WSRFConstants.CURRENT_TIME);
                    MessageElement[] any = resp.get_any();
                    return (Calendar)ObjectDeserializer.toObject((SOAPElement)any[0], (Class)(class$java$util$Calendar == null ? (class$java$util$Calendar = ServiceGroupRegistrationClient.class$("java.util.Calendar")) : class$java$util$Calendar));
                }
                catch (InvalidResourcePropertyQNameFaultType e) {
                    this.maybeHasLifetime = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (now == null) {
                ServiceGroupRegistrationClient.this.status(3, "No remote current time available. Getting from local clock instead.");
                now = Calendar.getInstance();
            }
            return now;
        }
    }
}

