/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.kxml.service;

import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.PortType;
import org.gcube.common.resources.kxml.KGCUBEResource;
import org.gcube.common.resources.kxml.service.KPackage;
import org.gcube.common.resources.kxml.service.KPortType;
import org.gcube.common.resources.kxml.utils.KAny;
import org.gcube.common.resources.kxml.utils.KStringList;
import org.kxml2.io.KXmlParser;
import org.kxml2.io.KXmlSerializer;

public class KMain {
    /*
     * Enabled aggressive block sorting
     */
    public static MainPackage load(KXmlParser parser) throws Exception {
        MainPackage main = new MainPackage();
        if (parser.getAttributeValue(KGCUBEResource.NS, "deployable") != null) {
            main.setDeployable(Boolean.valueOf(parser.getAttributeValue(KGCUBEResource.NS, "deployable")));
        }
        while (true) {
            switch (parser.next()) {
                case 2: {
                    KPackage.load(main, parser);
                    if (parser.getName().equals("GARArchive")) {
                        main.setGarArchive(parser.nextText().trim());
                    }
                    if (parser.getName().equals("ServiceEquivalenceFunctions")) {
                        main.getServiceEquivalenceFunctions().add(KFunction.load(parser));
                    }
                    if (!parser.getName().equals("PortType")) break;
                    main.getPorttypes().add(KPortType.load(parser));
                    break;
                }
                case 3: {
                    if (!parser.getName().equals("Main")) break;
                    return main;
                }
                case 1: {
                    throw new Exception("Parsing failed at Main");
                }
            }
        }
    }

    public static void store(MainPackage component, KXmlSerializer serializer) throws Exception {
        if (component == null) {
            return;
        }
        serializer.startTag(KGCUBEResource.NS, "Main");
        if (component.isDeployable()) {
            serializer.attribute(KGCUBEResource.NS, "deployable", component.isDeployable() + "");
        }
        KPackage.store(component, serializer);
        if (component.getGarArchive() != null) {
            serializer.startTag(KGCUBEResource.NS, "GARArchive").text(component.getGarArchive().trim()).endTag(KGCUBEResource.NS, "GARArchive");
        }
        if (component.getServiceEquivalenceFunctions().size() != 0) {
            serializer.startTag(KGCUBEResource.NS, "ServiceEquivalenceFunctions");
            for (PortType.Function fun : component.getServiceEquivalenceFunctions()) {
                KFunction.store(fun, serializer);
            }
            serializer.endTag(KGCUBEResource.NS, "ServiceEquivalenceFunctions");
        }
        if (component.getPorttypes().size() != 0) {
            for (PortType entry : component.getPorttypes()) {
                KPortType.store(entry, serializer);
            }
        }
        serializer.endTag(KGCUBEResource.NS, "Main");
    }

    public static class KFunction {
        /*
         * Enabled aggressive block sorting
         */
        public static PortType.Function load(KXmlParser parser) throws Exception {
            PortType.Function fun = new PortType.Function();
            while (true) {
                int tokenType = parser.next();
                switch (tokenType) {
                    case 2: {
                        String tag = parser.getName();
                        if (tag.equals("Name")) {
                            fun.setName(parser.nextText());
                        }
                        if (tag.equals("FormalParameters")) {
                            fun.setFormalParameters(KStringList.load("FormalParameters", parser));
                        }
                        if (!tag.equals("Body")) break;
                        fun.setBody(KAny.load("Body", parser));
                        break;
                    }
                    case 3: {
                        if (!parser.getName().equals("Function")) break;
                        return fun;
                    }
                    case 1: {
                        throw new Exception("Parsing failed at Function");
                    }
                }
            }
        }

        public static void store(PortType.Function component, KXmlSerializer serializer) throws Exception {
            serializer.startTag(KGCUBEResource.NS, "Function");
            serializer.startTag(KGCUBEResource.NS, "Name").text(component.getName()).endTag(KGCUBEResource.NS, "Name");
            if (component.getFormalParameters().size() != 0) {
                KStringList.store("FormalParameters", "Name", component.getFormalParameters(), serializer);
            }
            KAny.store("Body", component.getBody(), serializer);
            serializer.endTag(KGCUBEResource.NS, "Function");
        }
    }
}

