/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer.multiplex;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreEntry;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreAccessException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.IMultiplex;
import java.util.ArrayList;

public class FifoMultiplex
implements IMultiplex {
    private ArrayList<BufferStoreEntry> entries = null;
    private IBufferStore bufferStore = null;
    private Object modificationNotify = null;

    @Override
    public void setModificationNotify(Object notify) {
        this.modificationNotify = notify;
    }

    @Override
    public void setEntries(ArrayList<BufferStoreEntry> entries) {
        this.entries = entries;
    }

    @Override
    public void setBufferStore(IBufferStore bufferStore) {
        this.bufferStore = bufferStore;
    }

    @Override
    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multiplex() throws GRS2BufferStoreException {
        try {
            for (BufferStoreEntry entry : this.entries) {
                BufferEvent event;
                for (Record rec : entry.getReader()) {
                    BufferEvent event2;
                    this.bufferStore.markActivity();
                    entry.getRecordManager().persist(rec);
                    while ((event2 = entry.getReader().receive()) != null) {
                        entry.getEventManager().persist(event2);
                    }
                    Object object = this.modificationNotify;
                    synchronized (object) {
                        this.modificationNotify.notifyAll();
                    }
                }
                while ((event = entry.getReader().receive()) != null) {
                    entry.getEventManager().persist(event);
                }
                this.bufferStore.markActivity();
                entry.getReader().close();
                entry.setStatus(BufferStoreEntry.EntryStatus.Close);
                Object object = this.modificationNotify;
                synchronized (object) {
                    this.modificationNotify.notifyAll();
                }
            }
            this.bufferStore.markActivity();
            Object i$ = this.modificationNotify;
            synchronized (i$) {
                this.modificationNotify.notifyAll();
            }
        }
        catch (GRS2Exception ex) {
            throw new GRS2BufferStoreAccessException("Could not complete multiplexing operation", ex);
        }
    }
}

