/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.amq;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.JournalQueueAck;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.JournalTrace;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.command.Message;
import org.apache.activemq.filter.NonCachedMessageEvaluationContext;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.index.hash.HashIndex;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.ReferenceStore;
import org.apache.activemq.store.ReferenceStoreAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TopicReferenceStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.amq.AMQMessageStore;
import org.apache.activemq.store.amq.AMQTopicMessageStore;
import org.apache.activemq.store.amq.AMQTransactionStore;
import org.apache.activemq.store.amq.AMQTx;
import org.apache.activemq.store.amq.AMQTxOperation;
import org.apache.activemq.store.kahadaptor.KahaReferenceStoreAdapter;
import org.apache.activemq.thread.DefaultThreadPools;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.thread.Task;
import org.apache.activemq.thread.TaskRunner;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.wireformat.WireFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQPersistenceAdapter
implements PersistenceAdapter,
UsageListener,
BrokerServiceAware {
    private static final Log LOG = LogFactory.getLog(AMQPersistenceAdapter.class);
    private final ConcurrentHashMap<ActiveMQQueue, AMQMessageStore> queues = new ConcurrentHashMap();
    private final ConcurrentHashMap<ActiveMQTopic, AMQTopicMessageStore> topics = new ConcurrentHashMap();
    private static final String PROPERTY_PREFIX = "org.apache.activemq.store.amq";
    private static final boolean BROKEN_FILE_LOCK = "true".equals(System.getProperty("org.apache.activemq.store.amq.FileLockBroken", "false"));
    private static final boolean DISABLE_LOCKING = "true".equals(System.getProperty("org.apache.activemq.store.amq.DisableLocking", "false"));
    private static final int JOURNAL_LOCKED_WAIT_DELAY = 10000;
    private AsyncDataManager asyncDataManager;
    private ReferenceStoreAdapter referenceStoreAdapter;
    private TaskRunnerFactory taskRunnerFactory;
    private WireFormat wireFormat = new OpenWireFormat();
    private SystemUsage usageManager;
    private long checkpointInterval = 20000L;
    private int maxCheckpointMessageAddSize = 4096;
    private AMQTransactionStore transactionStore = new AMQTransactionStore(this);
    private TaskRunner checkpointTask;
    private CountDownLatch nextCheckpointCountDownLatch = new CountDownLatch(1);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Runnable periodicCheckpointTask;
    private Runnable periodicCleanupTask;
    private boolean deleteAllMessages;
    private boolean syncOnWrite;
    private boolean syncOnTransaction = true;
    private String brokerName = "";
    private File directory;
    private File directoryArchive;
    private BrokerService brokerService;
    private AtomicLong storeSize = new AtomicLong();
    private boolean persistentIndex = true;
    private boolean useNio = true;
    private boolean archiveDataLogs = false;
    private long cleanupInterval = 30000L;
    private int maxFileLength = 0x2000000;
    private int indexBinSize = HashIndex.DEFAULT_BIN_SIZE;
    private int indexKeySize = HashIndex.DEFAULT_KEY_SIZE;
    private int indexPageSize = HashIndex.DEFAULT_PAGE_SIZE;
    private int indexMaxBinSize = HashIndex.MAXIMUM_CAPACITY;
    private int indexLoadFactor = HashIndex.DEFAULT_LOAD_FACTOR;
    private int maxReferenceFileLength = 0x200000;
    private Map<AMQMessageStore, Map<Integer, AtomicInteger>> dataFilesInProgress = new ConcurrentHashMap<AMQMessageStore, Map<Integer, AtomicInteger>>();
    private String directoryPath = "";
    private RandomAccessFile lockFile;
    private FileLock lock;
    private boolean disableLocking = DISABLE_LOCKING;
    private boolean failIfJournalIsLocked;
    private boolean lockLogged;
    private boolean lockAquired;
    private boolean recoverReferenceStore = true;
    private boolean forceRecoverReferenceStore = false;

    public String getBrokerName() {
        return this.brokerName;
    }

    @Override
    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
        if (this.referenceStoreAdapter != null) {
            this.referenceStoreAdapter.setBrokerName(brokerName);
        }
    }

    public BrokerService getBrokerService() {
        return this.brokerService;
    }

    @Override
    public void setBrokerService(BrokerService brokerService) {
        this.brokerService = brokerService;
    }

    @Override
    public synchronized void start() throws Exception {
        Location location;
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        if (this.directory == null) {
            if (this.brokerService != null) {
                this.directory = this.brokerService.getBrokerDataDirectory();
            } else {
                this.directory = new File(IOHelper.getDefaultDataDirectory(), IOHelper.toFileSystemSafeName(this.brokerName));
                this.directory = new File(this.directory, "amqstore");
                this.directoryPath = this.directory.getAbsolutePath();
            }
        }
        if (this.directoryArchive == null) {
            this.directoryArchive = new File(this.directory, "archive");
        }
        IOHelper.mkdirs(this.directory);
        this.lockFile = new RandomAccessFile(new File(this.directory, "lock"), "rw");
        this.lock();
        LOG.info((Object)("AMQStore starting using directory: " + this.directory));
        if (this.archiveDataLogs) {
            IOHelper.mkdirs(this.directoryArchive);
        }
        if (this.usageManager != null) {
            this.usageManager.getMemoryUsage().addUsageListener(this);
        }
        if (this.asyncDataManager == null) {
            this.asyncDataManager = this.createAsyncDataManager();
        }
        if (this.referenceStoreAdapter == null) {
            this.referenceStoreAdapter = this.createReferenceStoreAdapter();
        }
        this.referenceStoreAdapter.setDirectory(new File(this.directory, "kr-store"));
        this.referenceStoreAdapter.setBrokerName(this.getBrokerName());
        this.referenceStoreAdapter.setUsageManager(this.usageManager);
        this.referenceStoreAdapter.setMaxDataFileLength(this.getMaxReferenceFileLength());
        if (this.taskRunnerFactory == null) {
            this.taskRunnerFactory = this.createTaskRunnerFactory();
        }
        if (this.failIfJournalIsLocked) {
            this.asyncDataManager.lock();
        } else {
            while (true) {
                try {
                    this.asyncDataManager.lock();
                }
                catch (IOException e) {
                    LOG.info((Object)"Journal is locked... waiting 10 seconds for the journal to be unlocked.");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e1) {}
                    continue;
                }
                break;
            }
        }
        this.asyncDataManager.start();
        if (this.deleteAllMessages) {
            this.asyncDataManager.delete();
            try {
                JournalTrace trace = new JournalTrace();
                trace.setMessage("DELETED " + new Date());
                location = this.asyncDataManager.write(this.wireFormat.marshal(trace), false);
                this.asyncDataManager.setMark(location, true);
                LOG.info((Object)"Journal deleted: ");
                this.deleteAllMessages = false;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw IOExceptionSupport.create(e);
            }
            this.referenceStoreAdapter.deleteAllMessages();
        }
        this.referenceStoreAdapter.start();
        Set<Integer> files = this.referenceStoreAdapter.getReferenceFileIdsInUse();
        LOG.info((Object)("Active data files: " + files));
        this.checkpointTask = this.taskRunnerFactory.createTaskRunner(new Task(){

            public boolean iterate() {
                AMQPersistenceAdapter.this.doCheckpoint();
                return false;
            }
        }, "ActiveMQ Journal Checkpoint Worker");
        this.createTransactionStore();
        if (this.isForceRecoverReferenceStore() || this.isRecoverReferenceStore() && !this.referenceStoreAdapter.isStoreValid()) {
            LOG.warn((Object)"The ReferenceStore is not valid - recovering ...");
            this.recover();
            LOG.info((Object)"Finished recovering the ReferenceStore");
        } else {
            location = this.writeTraceMessage("RECOVERED " + new Date(), true);
            this.asyncDataManager.setMark(location, true);
            this.getTransactionStore().setPreparedTransactions(this.referenceStoreAdapter.retrievePreparedState());
        }
        this.periodicCheckpointTask = new Runnable(){

            public void run() {
                AMQPersistenceAdapter.this.checkpoint(false);
            }
        };
        Scheduler.executePeriodically(this.periodicCheckpointTask, this.getCheckpointInterval());
        this.periodicCleanupTask = new Runnable(){

            public void run() {
                AMQPersistenceAdapter.this.cleanup();
            }
        };
        Scheduler.executePeriodically(this.periodicCleanupTask, this.getCleanupInterval());
        if (this.lockAquired && this.lockLogged) {
            LOG.info((Object)("Aquired lock for AMQ Store" + this.getDirectory()));
            if (this.brokerService != null) {
                this.brokerService.getBroker().nowMasterBroker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        Service ms3;
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.unlock();
        if (this.lockFile != null) {
            this.lockFile.close();
            this.lockFile = null;
        }
        this.usageManager.getMemoryUsage().removeUsageListener(this);
        AMQPersistenceAdapter aMQPersistenceAdapter = this;
        synchronized (aMQPersistenceAdapter) {
            Scheduler.cancel(this.periodicCheckpointTask);
            Scheduler.cancel(this.periodicCleanupTask);
        }
        for (AMQMessageStore ms2 : this.queues.values()) {
            ms2.stop();
        }
        for (Service ms3 : this.topics.values()) {
            ms3.stop();
        }
        this.checkpoint(true);
        ms3 = this;
        synchronized (ms3) {
            this.checkpointTask.shutdown();
        }
        this.referenceStoreAdapter.savePreparedState(this.getTransactionStore().getPreparedTransactions());
        this.queues.clear();
        this.topics.clear();
        IOException firstException = null;
        this.referenceStoreAdapter.stop();
        try {
            LOG.debug((Object)"Journal close");
            this.asyncDataManager.close();
        }
        catch (Exception e) {
            firstException = IOExceptionSupport.create("Failed to close journals: " + e, e);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkpoint(boolean sync) {
        try {
            if (this.asyncDataManager == null) {
                throw new IllegalStateException("Journal is closed.");
            }
            CountDownLatch latch = null;
            AMQPersistenceAdapter aMQPersistenceAdapter = this;
            synchronized (aMQPersistenceAdapter) {
                latch = this.nextCheckpointCountDownLatch;
                this.checkpointTask.wakeup();
            }
            if (sync) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Waitng for checkpoint to complete.");
                }
                latch.await();
            }
            this.referenceStoreAdapter.checkpoint(sync);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.warn((Object)("Request to start checkpoint failed: " + e), (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)("checkpoint failed: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doCheckpoint() {
        CountDownLatch latch = null;
        AMQPersistenceAdapter aMQPersistenceAdapter = this;
        synchronized (aMQPersistenceAdapter) {
            latch = this.nextCheckpointCountDownLatch;
            this.nextCheckpointCountDownLatch = new CountDownLatch(1);
        }
        try {
            Location currentMark;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checkpoint started.");
            }
            Location newMark = currentMark = this.asyncDataManager.getMark();
            for (AMQMessageStore ms : this.queues.values()) {
                Location mark = ms.getMark();
                if (mark == null || newMark != null && mark.compareTo(newMark) <= 0) continue;
                newMark = mark;
            }
            for (AMQTopicMessageStore ms : this.topics.values()) {
                Location mark = ms.getMark();
                if (mark == null || newMark != null && mark.compareTo(newMark) <= 0) continue;
                newMark = mark;
            }
            try {
                if (newMark != currentMark) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Marking journal at: " + newMark));
                    }
                    this.asyncDataManager.setMark(newMark, false);
                    this.writeTraceMessage("CHECKPOINT " + new Date(), true);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to mark the Journal: " + e), (Throwable)e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checkpoint done.");
            }
        }
        finally {
            latch.countDown();
        }
        return true;
    }

    public void cleanup() {
        try {
            HashSet<Integer> inProgress = new HashSet<Integer>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("dataFilesInProgress.values: (" + this.dataFilesInProgress.values().size() + ") " + this.dataFilesInProgress.values()));
            }
            for (Map<Integer, AtomicInteger> set : this.dataFilesInProgress.values()) {
                inProgress.addAll(set.keySet());
            }
            Integer lastDataFile = this.asyncDataManager.getCurrentDataFileId();
            inProgress.add(lastDataFile);
            lastDataFile = this.asyncDataManager.getMark().getDataFileId();
            inProgress.addAll(this.referenceStoreAdapter.getReferenceFileIdsInUse());
            Location lastActiveTx = this.transactionStore.checkpoint();
            if (lastActiveTx != null) {
                lastDataFile = Math.min(lastDataFile, lastActiveTx.getDataFileId());
            }
            LOG.debug((Object)("lastDataFile: " + lastDataFile));
            this.asyncDataManager.consolidateDataFilesNotIn(inProgress, lastDataFile - 1);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not cleanup data files: " + e), (Throwable)e);
        }
    }

    @Override
    public Set<ActiveMQDestination> getDestinations() {
        HashSet<ActiveMQDestination> destinations = new HashSet<ActiveMQDestination>(this.referenceStoreAdapter.getDestinations());
        destinations.addAll(this.queues.keySet());
        destinations.addAll(this.topics.keySet());
        return destinations;
    }

    MessageStore createMessageStore(ActiveMQDestination destination) throws IOException {
        if (destination.isQueue()) {
            return this.createQueueMessageStore((ActiveMQQueue)destination);
        }
        return this.createTopicMessageStore((ActiveMQTopic)destination);
    }

    @Override
    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        AMQMessageStore store = this.queues.get(destination);
        if (store == null) {
            ReferenceStore checkpointStore = this.referenceStoreAdapter.createQueueReferenceStore(destination);
            store = new AMQMessageStore(this, checkpointStore, destination);
            try {
                store.start();
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
            this.queues.put(destination, store);
        }
        return store;
    }

    @Override
    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destinationName) throws IOException {
        AMQTopicMessageStore store = this.topics.get(destinationName);
        if (store == null) {
            TopicReferenceStore checkpointStore = this.referenceStoreAdapter.createTopicReferenceStore(destinationName);
            store = new AMQTopicMessageStore(this, checkpointStore, destinationName);
            try {
                store.start();
            }
            catch (Exception e) {
                throw IOExceptionSupport.create(e);
            }
            this.topics.put(destinationName, store);
        }
        return store;
    }

    @Override
    public TransactionStore createTransactionStore() throws IOException {
        return this.transactionStore;
    }

    @Override
    public long getLastMessageBrokerSequenceId() throws IOException {
        return this.referenceStoreAdapter.getLastMessageBrokerSequenceId();
    }

    @Override
    public void beginTransaction(ConnectionContext context) throws IOException {
        this.referenceStoreAdapter.beginTransaction(context);
    }

    @Override
    public void commitTransaction(ConnectionContext context) throws IOException {
        this.referenceStoreAdapter.commitTransaction(context);
    }

    @Override
    public void rollbackTransaction(ConnectionContext context) throws IOException {
        this.referenceStoreAdapter.rollbackTransaction(context);
    }

    public boolean isPersistentIndex() {
        return this.persistentIndex;
    }

    public void setPersistentIndex(boolean persistentIndex) {
        this.persistentIndex = persistentIndex;
    }

    public DataStructure readCommand(Location location) throws IOException {
        try {
            ByteSequence packet = this.asyncDataManager.read(location);
            return (DataStructure)this.wireFormat.unmarshal(packet);
        }
        catch (IOException e) {
            throw this.createReadException(location, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void recover() throws IllegalStateException, IOException {
        this.referenceStoreAdapter.clearMessages();
        this.referenceStoreAdapter.recoverState();
        Location pos = null;
        int redoCounter = 0;
        LOG.info((Object)("Journal Recovery Started from: " + this.asyncDataManager));
        long start = System.currentTimeMillis();
        ConnectionContext context = new ConnectionContext(new NonCachedMessageEvaluationContext());
        block13: while (true) {
            AMQMessageStore store;
            if ((pos = this.asyncDataManager.getNextLocation(pos)) == null) {
                Location location = this.writeTraceMessage("RECOVERED " + new Date(), true);
                this.asyncDataManager.setMark(location, true);
                long end = System.currentTimeMillis();
                LOG.info((Object)("Recovered " + redoCounter + " operations from redo log in " + (float)(end - start) / 1000.0f + " seconds."));
                return;
            }
            ByteSequence data = this.asyncDataManager.read(pos);
            DataStructure c = (DataStructure)this.wireFormat.unmarshal(data);
            if (c instanceof Message) {
                Message message = (Message)c;
                store = (AMQMessageStore)this.createMessageStore(message.getDestination());
                if (message.isInTransaction()) {
                    this.transactionStore.addMessage(store, message, pos);
                    continue;
                }
                if (!store.replayAddMessage(context, message, pos)) continue;
                ++redoCounter;
                continue;
            }
            switch (c.getDataStructureType()) {
                case 52: {
                    DataStructure command = (JournalQueueAck)c;
                    store = (AMQMessageStore)this.createMessageStore(((JournalQueueAck)command).getDestination());
                    if (((JournalQueueAck)command).getMessageAck().isInTransaction()) {
                        this.transactionStore.removeMessage(store, ((JournalQueueAck)command).getMessageAck(), pos);
                        continue block13;
                    }
                    if (!store.replayRemoveMessage(context, ((JournalQueueAck)command).getMessageAck())) continue block13;
                    ++redoCounter;
                    continue block13;
                }
                case 50: {
                    DataStructure command = (JournalTopicAck)c;
                    store = (AMQTopicMessageStore)this.createMessageStore(((JournalTopicAck)command).getDestination());
                    if (((JournalTopicAck)command).getTransactionId() != null) {
                        this.transactionStore.acknowledge((AMQTopicMessageStore)store, (JournalTopicAck)command, pos);
                        continue block13;
                    }
                    if (!((AMQTopicMessageStore)store).replayAcknowledge(context, ((JournalTopicAck)command).getClientId(), ((JournalTopicAck)command).getSubscritionName(), ((JournalTopicAck)command).getMessageId())) continue block13;
                    ++redoCounter;
                    continue block13;
                }
                case 54: {
                    DataStructure command = (JournalTransaction)c;
                    try {
                        switch (((JournalTransaction)command).getType()) {
                            case 1: {
                                this.transactionStore.replayPrepare(((JournalTransaction)command).getTransactionId());
                                break;
                            }
                            case 2: 
                            case 4: {
                                AMQTx tx = this.transactionStore.replayCommit(((JournalTransaction)command).getTransactionId(), ((JournalTransaction)command).getWasPrepared());
                                if (tx == null) break;
                                tx.getOperations();
                                Iterator<AMQTxOperation> iter = tx.getOperations().iterator();
                                while (true) {
                                    if (!iter.hasNext()) continue block13;
                                    AMQTxOperation op = iter.next();
                                    if (!op.replay(this, context)) continue;
                                    ++redoCounter;
                                }
                            }
                            case 3: 
                            case 5: {
                                this.transactionStore.replayRollback(((JournalTransaction)command).getTransactionId());
                                break;
                            }
                            default: {
                                throw new IOException("Invalid journal command type: " + ((JournalTransaction)command).getType());
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Recovery Failure: Could not replay: " + c + ", reason: " + e), (Throwable)e);
                    }
                    continue block13;
                }
                case 53: {
                    JournalTrace trace = (JournalTrace)c;
                    LOG.debug((Object)("TRACE Entry: " + trace.getMessage()));
                    continue block13;
                }
            }
            LOG.error((Object)("Unknown type of record in transaction log which will be discarded: " + c));
        }
    }

    private IOException createReadException(Location location, Exception e) {
        return IOExceptionSupport.create("Failed to read to journal for: " + location + ". Reason: " + e, e);
    }

    protected IOException createWriteException(DataStructure packet, Exception e) {
        return IOExceptionSupport.create("Failed to write to journal for: " + packet + ". Reason: " + e, e);
    }

    protected IOException createWriteException(String command, Exception e) {
        return IOExceptionSupport.create("Failed to write to journal for command: " + command + ". Reason: " + e, e);
    }

    protected IOException createRecoveryFailedException(Exception e) {
        return IOExceptionSupport.create("Failed to recover from journal. Reason: " + e, e);
    }

    public Location writeCommand(DataStructure command, boolean syncHint) throws IOException {
        return this.writeCommand(command, syncHint, false);
    }

    public Location writeCommand(DataStructure command, boolean syncHint, boolean forceSync) throws IOException {
        return this.asyncDataManager.write(this.wireFormat.marshal(command), forceSync || syncHint && this.syncOnWrite);
    }

    private Location writeTraceMessage(String message, boolean sync) throws IOException {
        JournalTrace trace = new JournalTrace();
        trace.setMessage(message);
        return this.writeCommand(trace, sync);
    }

    @Override
    public void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        newPercentUsage = newPercentUsage / 10 * 10;
        oldPercentUsage = oldPercentUsage / 10 * 10;
        if (newPercentUsage >= 70 && oldPercentUsage < newPercentUsage) {
            this.checkpoint(false);
        }
    }

    public AMQTransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    @Override
    public synchronized void deleteAllMessages() throws IOException {
        this.deleteAllMessages = true;
    }

    public String toString() {
        return "AMQPersistenceAdapter(" + this.directory + ")";
    }

    protected AsyncDataManager createAsyncDataManager() {
        AsyncDataManager manager = new AsyncDataManager(this.storeSize);
        manager.setDirectory(new File(this.directory, "journal"));
        manager.setDirectoryArchive(this.getDirectoryArchive());
        manager.setArchiveDataLogs(this.isArchiveDataLogs());
        manager.setMaxFileLength(this.maxFileLength);
        manager.setUseNio(this.useNio);
        return manager;
    }

    protected KahaReferenceStoreAdapter createReferenceStoreAdapter() throws IOException {
        KahaReferenceStoreAdapter adaptor = new KahaReferenceStoreAdapter(this.storeSize);
        adaptor.setPersistentIndex(this.isPersistentIndex());
        adaptor.setIndexBinSize(this.getIndexBinSize());
        adaptor.setIndexKeySize(this.getIndexKeySize());
        adaptor.setIndexPageSize(this.getIndexPageSize());
        adaptor.setIndexMaxBinSize(this.getIndexMaxBinSize());
        adaptor.setIndexLoadFactor(this.getIndexLoadFactor());
        return adaptor;
    }

    protected TaskRunnerFactory createTaskRunnerFactory() {
        return DefaultThreadPools.getDefaultTaskRunnerFactory();
    }

    public AsyncDataManager getAsyncDataManager() {
        return this.asyncDataManager;
    }

    public void setAsyncDataManager(AsyncDataManager asyncDataManager) {
        this.asyncDataManager = asyncDataManager;
    }

    public ReferenceStoreAdapter getReferenceStoreAdapter() {
        return this.referenceStoreAdapter;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public SystemUsage getUsageManager() {
        return this.usageManager;
    }

    @Override
    public void setUsageManager(SystemUsage usageManager) {
        this.usageManager = usageManager;
    }

    public int getMaxCheckpointMessageAddSize() {
        return this.maxCheckpointMessageAddSize;
    }

    public void setMaxCheckpointMessageAddSize(int maxCheckpointMessageAddSize) {
        this.maxCheckpointMessageAddSize = maxCheckpointMessageAddSize;
    }

    public synchronized File getDirectory() {
        return this.directory;
    }

    @Override
    public synchronized void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isSyncOnWrite() {
        return this.syncOnWrite;
    }

    public void setSyncOnWrite(boolean syncOnWrite) {
        this.syncOnWrite = syncOnWrite;
    }

    public boolean isSyncOnTransaction() {
        return this.syncOnTransaction;
    }

    public void setSyncOnTransaction(boolean syncOnTransaction) {
        this.syncOnTransaction = syncOnTransaction;
    }

    public void setReferenceStoreAdapter(ReferenceStoreAdapter referenceStoreAdapter) {
        this.referenceStoreAdapter = referenceStoreAdapter;
    }

    @Override
    public long size() {
        return this.storeSize.get();
    }

    public boolean isUseNio() {
        return this.useNio;
    }

    public void setUseNio(boolean useNio) {
        this.useNio = useNio;
    }

    public int getMaxFileLength() {
        return this.maxFileLength;
    }

    public void setMaxFileLength(int maxFileLength) {
        this.maxFileLength = maxFileLength;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCleanupInterval(long cleanupInterval) {
        this.cleanupInterval = cleanupInterval;
    }

    public long getCheckpointInterval() {
        return this.checkpointInterval;
    }

    public void setCheckpointInterval(long checkpointInterval) {
        this.checkpointInterval = checkpointInterval;
    }

    public int getIndexBinSize() {
        return this.indexBinSize;
    }

    public void setIndexBinSize(int indexBinSize) {
        this.indexBinSize = indexBinSize;
    }

    public int getIndexKeySize() {
        return this.indexKeySize;
    }

    public void setIndexKeySize(int indexKeySize) {
        this.indexKeySize = indexKeySize;
    }

    public int getIndexPageSize() {
        return this.indexPageSize;
    }

    public int getIndexMaxBinSize() {
        return this.indexMaxBinSize;
    }

    public void setIndexMaxBinSize(int maxBinSize) {
        this.indexMaxBinSize = maxBinSize;
    }

    public void setIndexPageSize(int indexPageSize) {
        this.indexPageSize = indexPageSize;
    }

    public void setIndexLoadFactor(int factor) {
        this.indexLoadFactor = factor;
    }

    public int getIndexLoadFactor() {
        return this.indexLoadFactor;
    }

    public int getMaxReferenceFileLength() {
        return this.maxReferenceFileLength;
    }

    public void setMaxReferenceFileLength(int maxReferenceFileLength) {
        this.maxReferenceFileLength = maxReferenceFileLength;
    }

    public File getDirectoryArchive() {
        return this.directoryArchive;
    }

    public void setDirectoryArchive(File directoryArchive) {
        this.directoryArchive = directoryArchive;
    }

    public boolean isArchiveDataLogs() {
        return this.archiveDataLogs;
    }

    public void setArchiveDataLogs(boolean archiveDataLogs) {
        this.archiveDataLogs = archiveDataLogs;
    }

    public boolean isDisableLocking() {
        return this.disableLocking;
    }

    public void setDisableLocking(boolean disableLocking) {
        this.disableLocking = disableLocking;
    }

    public boolean isRecoverReferenceStore() {
        return this.recoverReferenceStore;
    }

    public void setRecoverReferenceStore(boolean recoverReferenceStore) {
        this.recoverReferenceStore = recoverReferenceStore;
    }

    public boolean isForceRecoverReferenceStore() {
        return this.forceRecoverReferenceStore;
    }

    public void setForceRecoverReferenceStore(boolean forceRecoverReferenceStore) {
        this.forceRecoverReferenceStore = forceRecoverReferenceStore;
    }

    protected void addInProgressDataFile(AMQMessageStore store, int dataFileId) {
        AtomicInteger count;
        Map<Integer, AtomicInteger> map = this.dataFilesInProgress.get(store);
        if (map == null) {
            map = new ConcurrentHashMap<Integer, AtomicInteger>();
            this.dataFilesInProgress.put(store, map);
        }
        if ((count = map.get(dataFileId)) == null) {
            count = new AtomicInteger(0);
            map.put(dataFileId, count);
        }
        count.incrementAndGet();
    }

    protected void removeInProgressDataFile(AMQMessageStore store, int dataFileId) {
        Map<Integer, AtomicInteger> map = this.dataFilesInProgress.get(store);
        if (map != null) {
            int newCount;
            AtomicInteger count = map.get(dataFileId);
            if (count != null && (newCount = count.decrementAndGet()) <= 0) {
                map.remove(dataFileId);
            }
            if (map.isEmpty()) {
                this.dataFilesInProgress.remove(store);
            }
        }
    }

    protected void lock() throws Exception {
        this.lockLogged = false;
        this.lockAquired = false;
        do {
            if (this.doLock()) {
                this.lockAquired = true;
                continue;
            }
            if (!this.lockLogged) {
                LOG.warn((Object)("Waiting to Lock the Store " + this.getDirectory()));
                this.lockLogged = true;
            }
            Thread.sleep(1000L);
        } while (!this.lockAquired && !this.disableLocking);
    }

    private synchronized void unlock() throws IOException {
        if (!this.disableLocking && null != this.lock) {
            System.getProperties().remove(this.getPropertyKey());
            System.clearProperty(this.getPropertyKey());
            assert (System.getProperty(this.getPropertyKey()) == null);
            if (this.lock.isValid()) {
                this.lock.release();
                this.lock.channel().close();
            }
            this.lock = null;
        }
    }

    protected boolean doLock() throws IOException {
        boolean result = true;
        if (!this.disableLocking && this.directory != null && this.lock == null) {
            String key = this.getPropertyKey();
            String property = System.getProperty(key);
            if (null == property) {
                if (!BROKEN_FILE_LOCK) {
                    this.lock = this.lockFile.getChannel().tryLock();
                    if (this.lock == null) {
                        result = false;
                    } else {
                        System.setProperty(key, new Date().toString());
                    }
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    private String getPropertyKey() throws IOException {
        return this.getClass().getName() + ".lock." + this.directory.getCanonicalPath();
    }
}

