/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.resources;

import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEConsumer;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBEProducer;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;

public abstract class GCUBEResource {
    protected GCUBELog logger = new GCUBELog(this);
    private String id = UUIDGenFactory.getUUIDGen().nextUUID();
    protected String type;
    private Map<String, GCUBEScope> scopes = new LinkedHashMap<String, GCUBEScope>();
    protected String resourceVersion;
    protected GCUBEProducer<ResourceTopic, Object> eventProducer = new GCUBEProducer();

    public void setLogger(GCUBELog logger) {
        this.logger = logger;
    }

    public String getType() {
        return this.type;
    }

    public String getID() {
        if (this.id == null || this.id.compareTo("") == 0) {
            this.id = UUIDGenFactory.getUUIDGen().nextUUID();
        }
        return this.id;
    }

    public synchronized boolean setID(String id) {
        if (id != null) {
            this.id = id;
            return true;
        }
        this.logger.warn("Attempt to change identifier of gCUBE resource " + this.getID());
        return false;
    }

    public synchronized Map<String, GCUBEScope> getScopes() {
        return Collections.unmodifiableMap(this.scopes);
    }

    public synchronized Set<GCUBEScope> addScope(GCUBEScope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        Set<GCUBEScope> validScopes = this.validateAddScopes(scopes);
        HashSet<GCUBEScope> validScopesCopy = new HashSet<GCUBEScope>();
        validScopesCopy.addAll(validScopes);
        for (GCUBEScope scope : validScopesCopy) {
            if (this.scopes.containsKey(scope.toString())) {
                validScopes.remove(scope);
                continue;
            }
            this.scopes.put(scope.toString(), scope);
        }
        if (validScopes.size() > 0) {
            this.logger.info("Added scope(s) " + validScopes);
            this.eventProducer.notify(ResourceTopic.ADDSCOPE, new AddScopeEvent(validScopes.toArray(new GCUBEScope[0])));
        }
        return validScopes;
    }

    public synchronized Set<GCUBEScope> validateAddScopes(GCUBEScope ... scopes) {
        LinkedHashSet<GCUBEScope> set = new LinkedHashSet<GCUBEScope>();
        Collections.addAll(set, scopes);
        return set;
    }

    public synchronized Set<GCUBEScope> removeScope(GCUBEScope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        Set<GCUBEScope> validScopes = this.validateRemoveScopes(scopes);
        for (GCUBEScope scope : validScopes) {
            if (this.scopes.size() == 0) {
                this.logger.info("Cannot remove from scope " + scope + " because resource must at least remain in one scope.");
                continue;
            }
            if (this.scopes.remove(scope.toString()) == null) {
                validScopes.remove(scope);
                this.logger.info("Cannot remove from scope " + scope + " because it is not in it");
                continue;
            }
            this.logger.info("Removed from scope " + scope);
        }
        if (validScopes.size() > 0) {
            this.eventProducer.notify(ResourceTopic.REMOVESCOPE, new RemoveScopeEvent(validScopes.toArray(new GCUBEScope[0])));
        }
        return validScopes;
    }

    public synchronized Set<GCUBEScope> validateRemoveScopes(GCUBEScope ... scopes) {
        LinkedHashSet<GCUBEScope> set = new LinkedHashSet<GCUBEScope>();
        Collections.addAll(set, scopes);
        return set;
    }

    public synchronized boolean inScope(GCUBEScope ... scopes) {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        block0: for (GCUBEScope scope : scopes) {
            if (scope == null) {
                return false;
            }
            for (GCUBEScope resScope : this.getScopes().values()) {
                if (!(resScope.isInfrastructure() ? scope.equals(resScope) : scope.isEnclosedIn(resScope))) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        GCUBEResource other = (GCUBEResource)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.scopes == null ? other.scopes != null : !((Object)this.scopes).equals(other.scopes));
    }

    public abstract void load(Reader var1) throws Exception;

    public abstract void store(Writer var1) throws Exception;

    public void subscribeResourceEvents(ResourceConsumer consumer, ResourceTopic ... topics) throws Exception {
        if (topics == null || topics.length == 0) {
            topics = ResourceTopic.values();
        }
        this.eventProducer.subscribe(consumer, topics);
    }

    public String getResourceVersion() {
        return this.resourceVersion != null ? this.resourceVersion : "0.4.x";
    }

    public void setResourceVersion(String version) {
        this.resourceVersion = version;
    }

    public String getLastResourceVersion() {
        return "0.4.x";
    }

    public static class InvalidScopeException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class ResourceConsumer
    implements GCUBEConsumer<ResourceTopic, Object> {
        @Override
        public <T1 extends ResourceTopic, P1> void onEvent(GCUBEEvent<T1, P1> ... events) {
            if (events == null) {
                return;
            }
            block4: for (GCUBEEvent<T1, P1> event : events) {
                ResourceTopic topic = (ResourceTopic)event.getTopic();
                switch (topic) {
                    case ADDSCOPE: {
                        this.onAddScope((AddScopeEvent)event);
                        continue block4;
                    }
                    case REMOVESCOPE: {
                        this.onRemoveScope((RemoveScopeEvent)event);
                    }
                }
            }
        }

        protected void onAddScope(AddScopeEvent event) {
        }

        protected void onRemoveScope(RemoveScopeEvent event) {
        }
    }

    public class RemoveScopeEvent
    extends ResourceEvent<GCUBEScope[]> {
        RemoveScopeEvent(GCUBEScope ... scopes) {
            this.payload = scopes;
        }
    }

    public class AddScopeEvent
    extends ResourceEvent<GCUBEScope[]> {
        AddScopeEvent(GCUBEScope ... scopes) {
            this.payload = scopes;
        }
    }

    public abstract class ResourceEvent<PAYLOAD>
    extends GCUBEEvent<ResourceTopic, PAYLOAD> {
    }

    public static enum ResourceTopic implements GCUBETopic
    {
        ADDSCOPE,
        REMOVESCOPE;

    }
}

