/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.jdbc.JDBCAdapter;
import org.apache.activemq.store.jdbc.JDBCMessageRecoveryListener;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.Statements;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJDBCAdapter
implements JDBCAdapter {
    private static final Log LOG = LogFactory.getLog(DefaultJDBCAdapter.class);
    protected Statements statements;
    protected boolean batchStatments = true;

    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBytes(index, data);
    }

    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        return rs.getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doCreateTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        try {
            boolean alreadyExists = false;
            ResultSet rs = null;
            try {
                rs = c.getConnection().getMetaData().getTables(null, null, this.statements.getFullMessageTableName(), new String[]{"TABLE"});
                alreadyExists = rs.next();
            }
            catch (Throwable ignore) {
                DefaultJDBCAdapter.close(rs);
                catch (Throwable throwable) {
                    DefaultJDBCAdapter.close(rs);
                    throw throwable;
                }
            }
            DefaultJDBCAdapter.close(rs);
            s = c.getConnection().createStatement();
            String[] createStatments = this.statements.getCreateSchemaStatements();
            for (int i = 0; i < createStatments.length; ++i) {
                try {
                    LOG.debug((Object)("Executing SQL: " + createStatments[i]));
                    s.execute(createStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    if (alreadyExists) {
                        LOG.debug((Object)("Could not create JDBC tables; The message table already existed. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                        continue;
                    }
                    LOG.warn((Object)("Could not create JDBC tables; they could already exist. Failure was: " + createStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                    JDBCPersistenceAdapter.log("Failure details: ", e);
                }
            }
            c.getConnection().commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDropTables(TransactionContext c) throws SQLException, IOException {
        Statement s = null;
        try {
            s = c.getConnection().createStatement();
            String[] dropStatments = this.statements.getDropSchemaStatements();
            for (int i = 0; i < dropStatments.length; ++i) {
                try {
                    LOG.debug((Object)("Executing SQL: " + dropStatments[i]));
                    s.execute(dropStatments[i]);
                    continue;
                }
                catch (SQLException e) {
                    LOG.warn((Object)("Could not drop JDBC tables; they may not exist. Failure was: " + dropStatments[i] + " Message: " + e.getMessage() + " SQLState: " + e.getSQLState() + " Vendor code: " + e.getErrorCode()));
                    JDBCPersistenceAdapter.log("Failure details: ", e);
                }
            }
            c.getConnection().commit();
        }
        finally {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetLastMessageBrokerSequenceId(TransactionContext c) throws SQLException, IOException {
        long l;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInMsgsStatement());
            rs = s.executeQuery();
            long seq1 = 0L;
            if (rs.next()) {
                seq1 = rs.getLong(1);
            }
            rs.close();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInAcksStatement());
            rs = s.executeQuery();
            long seq2 = 0L;
            if (rs.next()) {
                seq2 = rs.getLong(1);
            }
            l = Math.max(seq1, seq2);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddMessage(TransactionContext c, MessageId messageID, ActiveMQDestination destination, byte[] data, long expiration) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
                if (this.batchStatments) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, messageID.getBrokerSequenceId());
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expiration);
            this.setBinaryData(s, 6, data);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments && s != null) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAddMessageReference(TransactionContext c, MessageId messageID, ActiveMQDestination destination, long expirationTime, String messageRef) throws SQLException, IOException {
        PreparedStatement s = c.getAddMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getAddMessageStatement());
                if (this.batchStatments) {
                    c.setAddMessageStatement(s);
                }
            }
            s.setLong(1, messageID.getBrokerSequenceId());
            s.setString(2, messageID.getProducerId().toString());
            s.setLong(3, messageID.getProducerSequenceId());
            s.setString(4, destination.getQualifiedName());
            s.setLong(5, expirationTime);
            s.setString(6, messageRef);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getBrokerSequenceId(TransactionContext c, MessageId messageID) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            long l;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageSequenceIdStatement());
                s.setString(1, messageID.getProducerId().toString());
                s.setLong(2, messageID.getProducerSequenceId());
                rs = s.executeQuery();
                if (rs.next()) break block3;
                l = 0L;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return l;
        }
        long l = rs.getLong(1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doGetMessage(TransactionContext c, long seq) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
                s.setLong(1, seq);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGetMessageReference(TransactionContext c, long seq) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            String string;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindMessageStatement());
                s.setLong(1, seq);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                string = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return string;
        }
        String string = rs.getString(1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemoveMessage(TransactionContext c, long seq) throws SQLException, IOException {
        PreparedStatement s = c.getRemovedMessageStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getRemoveMessageStatment());
                if (this.batchStatments) {
                    c.setRemovedMessageStatement(s);
                }
            }
            s.setLong(1, seq);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed to remove message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecover(TransactionContext c, ActiveMQDestination destination, JDBCMessageRecoveryListener listener) throws Exception {
        ResultSet rs;
        PreparedStatement s;
        block5: {
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindAllMessagesStatement());
                s.setString(1, destination.getQualifiedName());
                rs = s.executeQuery();
                if (this.statements.isUseExternalMessageReferences()) {
                    while (rs.next() && listener.recoverMessageReference(rs.getString(2))) {
                    }
                    break block5;
                }
                while (rs.next() && listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                }
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetLastAck(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq) throws SQLException, IOException {
        PreparedStatement s = c.getUpdateLastAckStatement();
        try {
            if (s == null) {
                s = c.getConnection().prepareStatement(this.statements.getUpdateLastAckOfDurableSubStatement());
                if (this.batchStatments) {
                    c.setUpdateLastAckStatement(s);
                }
            }
            s.setLong(1, seq);
            s.setString(2, destination.getQualifiedName());
            s.setString(3, clientId);
            s.setString(4, subscriptionName);
            if (this.batchStatments) {
                s.addBatch();
            } else if (s.executeUpdate() != 1) {
                throw new SQLException("Failed add a message");
            }
        }
        finally {
            if (!this.batchStatments) {
                s.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, JDBCMessageRecoveryListener listener) throws Exception {
        ResultSet rs;
        PreparedStatement s;
        block5: {
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindAllDurableSubMessagesStatement());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriptionName);
                rs = s.executeQuery();
                if (this.statements.isUseExternalMessageReferences()) {
                    while (rs.next() && listener.recoverMessageReference(rs.getString(2))) {
                    }
                    break block5;
                }
                while (rs.next() && listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                }
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverNextMessages(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName, long seq, int maxReturned, JDBCMessageRecoveryListener listener) throws Exception {
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            int count;
            s = c.getConnection().prepareStatement(this.statements.getFindDurableSubMessagesStatement());
            s.setMaxRows(maxReturned);
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.setLong(4, seq);
            rs = s.executeQuery();
            if (this.statements.isUseExternalMessageReferences()) {
                for (count = 0; rs.next() && count < maxReturned && listener.recoverMessageReference(rs.getString(1)); ++count) {
                }
            } else {
                while (rs.next() && count < maxReturned && listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                    ++count;
                }
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doGetDurableSubscriberMessageCount(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        int result = 0;
        try {
            s = c.getConnection().prepareStatement(this.statements.getDurableSubscriberMessageCountStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            rs = s.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSetSubscriberEntry(TransactionContext c, SubscriptionInfo info, boolean retroactive) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            long lastMessageId = -1L;
            if (!retroactive) {
                s = c.getConnection().prepareStatement(this.statements.getFindLastSequenceIdInMsgsStatement());
                ResultSet rs = null;
                try {
                    rs = s.executeQuery();
                    if (rs.next()) {
                        lastMessageId = rs.getLong(1);
                    }
                }
                finally {
                    DefaultJDBCAdapter.close(rs);
                    DefaultJDBCAdapter.close(s);
                }
            }
            s = c.getConnection().prepareStatement(this.statements.getCreateDurableSubStatement());
            s.setString(1, info.getDestination().getQualifiedName());
            s.setString(2, info.getClientId());
            s.setString(3, info.getSubscriptionName());
            s.setString(4, info.getSelector());
            s.setLong(5, lastMessageId);
            s.setString(6, info.getSubscribedDestination().getQualifiedName());
            if (s.executeUpdate() != 1) {
                throw new IOException("Could not create durable subscription for: " + info.getClientId());
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo doGetSubscriberEntry(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            SubscriptionInfo subscriptionInfo;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getFindDurableSubStatement());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriptionName);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                subscriptionInfo = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return subscriptionInfo;
        }
        SubscriptionInfo subscription = new SubscriptionInfo();
        subscription.setDestination(destination);
        subscription.setClientId(clientId);
        subscription.setSubscriptionName(subscriptionName);
        subscription.setSelector(rs.getString(1));
        subscription.setSubscribedDestination(ActiveMQDestination.createDestination(rs.getString(2), (byte)1));
        SubscriptionInfo subscriptionInfo = subscription;
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo[] doGetAllSubscriptions(TransactionContext c, ActiveMQDestination destination) throws SQLException, IOException {
        SubscriptionInfo[] subscriptionInfoArray;
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDurableSubsStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            ArrayList<SubscriptionInfo> rc = new ArrayList<SubscriptionInfo>();
            while (rs.next()) {
                SubscriptionInfo subscription = new SubscriptionInfo();
                subscription.setDestination(destination);
                subscription.setSelector(rs.getString(1));
                subscription.setSubscriptionName(rs.getString(2));
                subscription.setClientId(rs.getString(3));
                subscription.setSubscribedDestination(ActiveMQDestination.createDestination(rs.getString(4), (byte)1));
                rc.add(subscription);
            }
            subscriptionInfoArray = rc.toArray(new SubscriptionInfo[rc.size()]);
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return subscriptionInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRemoveAllMessages(TransactionContext c, ActiveMQDestination destinationName) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getRemoveAllMessagesStatement());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
            s.close();
            s = c.getConnection().prepareStatement(this.statements.getRemoveAllSubscriptionsStatement());
            s.setString(1, destinationName.getQualifiedName());
            s.executeUpdate();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteSubscription(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriptionName) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getDeleteSubscriptionStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriptionName);
            s.executeUpdate();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doDeleteOldMessages(TransactionContext c) throws SQLException, IOException {
        PreparedStatement s = null;
        try {
            LOG.debug((Object)("Executing SQL: " + this.statements.getDeleteOldMessagesStatement()));
            s = c.getConnection().prepareStatement(this.statements.getDeleteOldMessagesStatement());
            s.setLong(1, System.currentTimeMillis());
            int i = s.executeUpdate();
            LOG.debug((Object)("Deleted " + i + " old message(s)."));
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long doGetLastAckedDurableSubscriberMessageId(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriberName) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        long result = -1L;
        try {
            s = c.getConnection().prepareStatement(this.statements.getLastAckedDurableSubscriberMessageStatement());
            s.setString(1, destination.getQualifiedName());
            s.setString(2, clientId);
            s.setString(3, subscriberName);
            rs = s.executeQuery();
            if (rs.next()) {
                result = rs.getLong(1);
            }
            rs.close();
            s.close();
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    private static void close(PreparedStatement s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void close(ResultSet rs) {
        try {
            rs.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ActiveMQDestination> doGetDestinations(TransactionContext c) throws SQLException, IOException {
        HashSet<ActiveMQDestination> rc = new HashSet<ActiveMQDestination>();
        PreparedStatement s = null;
        ResultSet rs = null;
        try {
            s = c.getConnection().prepareStatement(this.statements.getFindAllDestinationsStatement());
            rs = s.executeQuery();
            while (rs.next()) {
                rc.add(ActiveMQDestination.createDestination(rs.getString(1), (byte)1));
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return rc;
    }

    public boolean isBatchStatments() {
        return this.batchStatments;
    }

    public void setBatchStatments(boolean batchStatments) {
        this.batchStatments = batchStatments;
    }

    @Override
    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.statements.setUseExternalMessageReferences(useExternalMessageReferences);
    }

    public Statements getStatements() {
        return this.statements;
    }

    @Override
    public void setStatements(Statements statements) {
        this.statements = statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] doGetNextDurableSubscriberMessageStatement(TransactionContext c, ActiveMQDestination destination, String clientId, String subscriberName) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement s;
        block3: {
            byte[] byArray;
            s = null;
            rs = null;
            try {
                s = c.getConnection().prepareStatement(this.statements.getNextDurableSubscriberMessageStatement());
                s.setString(1, destination.getQualifiedName());
                s.setString(2, clientId);
                s.setString(3, subscriberName);
                rs = s.executeQuery();
                if (rs.next()) break block3;
                byArray = null;
            }
            catch (Throwable throwable) {
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
                throw throwable;
            }
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            return byArray;
        }
        byte[] byArray = this.getBinaryData(rs, 1);
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doGetMessageCount(TransactionContext c, ActiveMQDestination destination) throws SQLException, IOException {
        PreparedStatement s = null;
        ResultSet rs = null;
        int result = 0;
        try {
            s = c.getConnection().prepareStatement(this.statements.getDestinationMessageCountStatement());
            s.setString(1, destination.getQualifiedName());
            rs = s.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            DefaultJDBCAdapter.close(rs);
            DefaultJDBCAdapter.close(s);
            throw throwable;
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRecoverNextMessages(TransactionContext c, ActiveMQDestination destination, long nextSeq, int maxReturned, JDBCMessageRecoveryListener listener) throws Exception {
        ResultSet rs;
        PreparedStatement s;
        block9: {
            s = null;
            rs = null;
            try {
                int count;
                s = c.getConnection().prepareStatement(this.statements.getFindNextMessagesStatement());
                s.setMaxRows(maxReturned);
                s.setString(1, destination.getQualifiedName());
                s.setLong(2, nextSeq);
                rs = s.executeQuery();
                if (this.statements.isUseExternalMessageReferences()) {
                    for (count = 0; rs.next() && count < maxReturned; ++count) {
                        if (listener.recoverMessageReference(rs.getString(1))) {
                            continue;
                        }
                        LOG.debug((Object)"Stopped recover next messages");
                        break block9;
                    }
                    break block9;
                }
                while (rs.next() && count < maxReturned) {
                    if (listener.recoverMessage(rs.getLong(1), this.getBinaryData(rs, 2))) {
                        ++count;
                        continue;
                    }
                    LOG.debug((Object)"Stopped recover next messages");
                    break;
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    DefaultJDBCAdapter.close(rs);
                    DefaultJDBCAdapter.close(s);
                    throw throwable;
                }
                DefaultJDBCAdapter.close(rs);
                DefaultJDBCAdapter.close(s);
            }
        }
        DefaultJDBCAdapter.close(rs);
        DefaultJDBCAdapter.close(s);
    }
}

