/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.aggregator.impl;

import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.mds.aggregator.impl.AggregatorException;
import org.globus.mds.aggregator.impl.AggregatorParamTypeNotSupportedException;
import org.globus.mds.aggregator.impl.AggregatorServiceGroupEntryResource;
import org.globus.mds.aggregator.impl.AggregatorSink;
import org.globus.mds.aggregator.impl.AggregatorSource;
import org.globus.mds.aggregator.types.AggregatorConfig;
import org.globus.mds.aggregator.types.AggregatorData;
import org.globus.mds.aggregator.types.AggregatorSubscriptionType;
import org.globus.wsrf.NotificationConsumerManager;
import org.globus.wsrf.NotifyCallback;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.XmlUtils;
import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.SubscribeResponse;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.lifetime.Destroy;
import org.oasis.wsrf.lifetime.ImmediateResourceTermination;
import org.oasis.wsrf.lifetime.WSResourceLifetimeServiceAddressingLocator;
import org.w3c.dom.Element;

public class SubscriptionAggregatorSource
implements AggregatorSource {
    private boolean initialized = false;
    private AggregatorSink sink = null;
    private Object sinkParameters = null;
    private String resDescFilename = null;
    private Hashtable sessions = new Hashtable();
    private NotificationConsumerManager consumer = null;
    WSBaseNotificationServiceAddressingLocator locator = new WSBaseNotificationServiceAddressingLocator();
    WSResourceLifetimeServiceAddressingLocator lifetimeLocator = new WSResourceLifetimeServiceAddressingLocator();
    private static Log logger = LogFactory.getLog((String)(class$org$globus$mds$aggregator$impl$SubscriptionAggregatorSource == null ? (class$org$globus$mds$aggregator$impl$SubscriptionAggregatorSource = SubscriptionAggregatorSource.class$("org.globus.mds.aggregator.impl.SubscriptionAggregatorSource")) : class$org$globus$mds$aggregator$impl$SubscriptionAggregatorSource).getName());
    static /* synthetic */ Class class$org$globus$mds$aggregator$impl$SubscriptionAggregatorSource;
    static /* synthetic */ Class class$org$globus$mds$aggregator$types$AggregatorSubscriptionType;

    public SubscriptionAggregatorSource(AggregatorSink sink, Object sinkParameters) {
        this.setAggregatorSink(sink, sinkParameters);
    }

    public SubscriptionAggregatorSource(AggregatorSink sink) {
        this.setAggregatorSink(sink, null);
    }

    public void initialize(Object parameters) throws AggregatorException, Exception {
        if (this.initialized) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Reinitializing");
            }
            this.terminate();
        }
        if (this.getAggregatorSink() == null) {
            throw new AggregatorException("Aggregator Sink not set!");
        }
        this.sink.initialize(this.sinkParameters);
        this.consumer = NotificationConsumerManager.getInstance();
        this.consumer.startListening();
        this.initialized = true;
    }

    public AggregatorServiceGroupEntryResource getSessionContext(String sessionKey) {
        return (AggregatorServiceGroupEntryResource)this.sessions.get(sessionKey);
    }

    public String getSessionKey(AggregatorServiceGroupEntryResource entry) throws AggregatorException {
        NotificationCallback callback;
        if (entry == null) {
            throw new AggregatorException("Null Argument");
        }
        String key = "";
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext() && !entry.equals((callback = (NotificationCallback)this.sessions.get(key = (String)keys.next())).getEntry())) {
        }
        return key;
    }

    public boolean isValidSession(String sessionKey) throws AggregatorException {
        return this.sessions.containsKey(sessionKey);
    }

    public AggregatorSink getAggregatorSink() {
        return this.sink;
    }

    public void setAggregatorSink(AggregatorSink sink, Object sinkParameters) {
        this.sink = sink;
        if (this.sink != null) {
            this.sink.setSource(this);
            this.sinkParameters = sinkParameters;
        }
    }

    public String addAggregation(Object parameters, AggregatorServiceGroupEntryResource entry) throws AggregatorParamTypeNotSupportedException, AggregatorException, Exception {
        if (!this.initialized) {
            throw new AggregatorException("Not Initialized");
        }
        AggregatorConfig config = (AggregatorConfig)parameters;
        MessageElement[] any = config.get_any();
        if (any == null) {
            throw new AggregatorException("Got null any from AggregatorConfig");
        }
        AggregatorSubscriptionType aggrSub = null;
        for (int i = 0; i < any.length; ++i) {
            try {
                if (!ObjectDeserializer.contains((SOAPElement)any[i], (Class)(class$org$globus$mds$aggregator$types$AggregatorSubscriptionType == null ? SubscriptionAggregatorSource.class$("org.globus.mds.aggregator.types.AggregatorSubscriptionType") : class$org$globus$mds$aggregator$types$AggregatorSubscriptionType))) continue;
                aggrSub = (AggregatorSubscriptionType)ObjectDeserializer.toObject((SOAPElement)any[i], (Class)(class$org$globus$mds$aggregator$types$AggregatorSubscriptionType == null ? SubscriptionAggregatorSource.class$("org.globus.mds.aggregator.types.AggregatorSubscriptionType") : class$org$globus$mds$aggregator$types$AggregatorSubscriptionType));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Exception deserializing parameters: " + e.toString()));
            }
        }
        if (aggrSub == null) {
            throw new AggregatorParamTypeNotSupportedException();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got AggregatorSubscriptionType from AggregatorConfig: " + XmlUtils.toString((Element)ObjectSerializer.toElement(aggrSub, (QName)aggrSub.getTypeDesc().getXmlType()))));
        }
        try {
            NotificationProducer port = this.locator.getNotificationProducerPort(entry.getMemberEPR());
            this.setAnonymous((Stub)port);
            ResourceSecurityDescriptor resDesc = null;
            if (this.resDescFilename != null) {
                ResourceSecurityConfig secConfig = new ResourceSecurityConfig(this.resDescFilename);
                secConfig.init();
                resDesc = secConfig.getSecurityDescriptor();
            }
            NotificationCallback callback = new NotificationCallback(entry);
            callback.consumerEPR = this.consumer.createNotificationConsumer((NotifyCallback)callback, resDesc);
            Subscribe request = new Subscribe();
            request.setUseNotify(Boolean.TRUE);
            request.setConsumerReference(callback.consumerEPR);
            request.setTopicExpression(aggrSub.getTopicExpression());
            request.setPrecondition(aggrSub.getPrecondition());
            request.setSelector(aggrSub.getSelector());
            request.setSubscriptionPolicy(aggrSub.getSubscriptionPolicy());
            Calendar cal = aggrSub.getInitialTerminationTime();
            request.setInitialTerminationTime(cal);
            if (cal == null && logger.isDebugEnabled()) {
                logger.debug((Object)("Subscribe request for " + entry.getMemberEPR().getAddress() + " has INFINITE lifetime"));
            }
            SubscribeResponse response = port.subscribe(request);
            callback.sourceEPR = response.getSubscriptionReference();
            String sessionKey = Integer.toString(callback.hashCode());
            this.sessions.put(sessionKey, callback);
            String string = sessionKey;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to subscribe to " + entry.getMemberEPR().getAddress() + ": " + FaultHelper.getMessage((Throwable)e)));
            throw e;
        }
        finally {
            if (this.consumer != null) {
                // empty if block
            }
        }
    }

    public void removeAggregation(String sessionKey) throws AggregatorException, Exception {
        NotificationCallback callback = (NotificationCallback)this.sessions.remove(sessionKey);
        try {
            ImmediateResourceTermination port = this.lifetimeLocator.getImmediateResourceTerminationPort(callback.sourceEPR);
            this.setAnonymous((Stub)port);
            port.destroy(new Destroy());
        }
        catch (Exception e) {
            logger.error((Object)("Exception while trying to remove subscription to " + callback.sourceEPR.getAddress() + ": " + FaultHelper.getMessage((Throwable)e)));
            throw e;
        }
        finally {
            this.consumer.removeNotificationConsumer(callback.consumerEPR);
        }
    }

    public void terminate() {
        if (!this.initialized) {
            return;
        }
        this.getAggregatorSink().terminate();
        Iterator keys = this.sessions.keySet().iterator();
        while (keys.hasNext()) {
            try {
                this.removeAggregation((String)keys.next());
            }
            catch (Exception e) {
                logger.error((Object)("Exception during removeAggregation: " + e));
            }
        }
        try {
            this.consumer.stopListening();
        }
        catch (Exception e) {
            logger.error((Object)("Exception: " + e.toString()));
        }
        this.initialized = false;
    }

    private void setAnonymous(Stub stub) {
        stub._setProperty("org.globus.gsi.anonymous", (Object)Boolean.TRUE);
        stub._setProperty("org.globus.security.authorization", (Object)org.globus.wsrf.impl.security.authorization.NoAuthorization.getInstance());
        stub._setProperty("org.globus.gsi.authorization", (Object)NoAuthorization.getInstance());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class NotificationCallback
    implements NotifyCallback {
        public EndpointReferenceType sourceEPR = null;
        public EndpointReferenceType consumerEPR = null;
        private AggregatorServiceGroupEntryResource entry = null;

        public NotificationCallback(AggregatorServiceGroupEntryResource entry) {
            this.entry = entry;
        }

        public Object getEntry() {
            return this.entry;
        }

        public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
            AggregatorSink sink = SubscriptionAggregatorSource.this.getAggregatorSink();
            AggregatorData data = new AggregatorData();
            data.set_any(AnyHelper.toAnyArray((Object)message));
            try {
                sink.deliver((AnyContentType)data, this.entry);
            }
            catch (Exception e) {
                logger.error((Object)"Exception during sink message delivery");
            }
        }
    }
}

