/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.container.ServiceDispatcher;
import org.globus.wsrf.container.ServiceThread;

public class ServiceThreadPool {
    private Vector serviceThreads = new Vector();
    protected ServiceDispatcher dispatcher;
    static Log logger = LogFactory.getLog((String)ServiceThreadPool.class.getName());

    public ServiceThreadPool(ServiceDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void startThreads(int threads) {
        for (int i = 0; i < threads; ++i) {
            ServiceThread serviceThread = this.createThread();
            this.serviceThreads.addElement(serviceThread);
            serviceThread.start();
        }
    }

    public int getThreads() {
        return this.serviceThreads.size();
    }

    protected ServiceThread createThread() {
        return new ServiceThread(this.dispatcher);
    }

    public void stopThreads(int numThreads) {
        this.dispatcher.getServiceRequestQueue().stopThreads(numThreads);
    }

    public void stopThreads() {
        this.stopThreads(this.getThreads());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(ServiceThread thread) {
        this.serviceThreads.removeElement(thread);
        ServiceThreadPool serviceThreadPool = this;
        synchronized (serviceThreadPool) {
            this.notifyAll();
        }
    }

    public synchronized void waitForThreads() throws InterruptedException {
        while (!this.isDone()) {
            this.wait();
        }
    }

    public synchronized void waitForThreads(int timeout) throws InterruptedException {
        while (timeout > 0 && !this.isDone()) {
            this.wait(5000L);
            timeout -= 5000;
        }
    }

    private boolean isDone() {
        int size = this.serviceThreads.size();
        return size == 0 || size == 1 && this.serviceThreads.contains(Thread.currentThread());
    }
}

