/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.security;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class HeadMnemonic {
    private RSAPublicKey publickey = null;
    private PrivateKey privatekey = null;
    private Cipher RSACipher = Cipher.getInstance("RSA");
    private static Logger logger = Logger.getLogger(HeadMnemonic.class);

    public void EnableEncryption(PublicKey pk) throws Exception {
        logger.trace((Object)"EnableEncryption");
        this.setPublickey((RSAPublicKey)pk);
    }

    public void EnableEncryption(byte[] pk) throws Exception {
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(pk);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.setPublickey((RSAPublicKey)kf.generatePublic(publicKeySpec));
    }

    public void EnableDecryption(PrivateKey pk) throws Exception {
        this.setPrivatekey(pk);
    }

    public void EnableDecryption(byte[] pk) throws Exception {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pk);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        this.setPrivatekey(kf.generatePrivate(privateKeySpec));
    }

    public String Encrypt(byte[] input) throws Exception {
        this.RSACipher.init(1, this.publickey);
        return new BASE64Encoder().encode(this.RSACipher.doFinal(input));
    }

    public byte[] Decrypt(String input) throws Exception {
        this.RSACipher.init(2, this.privatekey);
        return this.RSACipher.doFinal(new BASE64Decoder().decodeBuffer(input));
    }

    public PrivateKey getPrivatekey() {
        return this.privatekey;
    }

    public void setPrivatekey(PrivateKey privatekey) {
        this.privatekey = privatekey;
    }

    public RSAPublicKey getPublickey() {
        return this.publickey;
    }

    public void setPublickey(RSAPublicKey publickey) {
        this.publickey = publickey;
    }
}

