/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.layerindependent.servicehelper;

import java.io.File;

public class UUIDUtils {
    static UUIDSParts parseUUIDParts(String hexadecimalUUIDRepresentation) {
        UUIDSParts uuid = new UUIDSParts();
        String[] uuidParts = hexadecimalUUIDRepresentation.split("-");
        uuid.time_low = uuidParts[0];
        uuid.time_mid = uuidParts[1];
        uuid.time_high_and_version = uuidParts[2];
        uuid.clock_seq_and_reserved = uuidParts[3].substring(0, 2);
        uuid.clock_seq_low = uuidParts[3].substring(2, 4);
        uuid.node = uuidParts[4];
        return uuid;
    }

    public static String getLocationFromUUID(String hexadecimalUUIDRepresentation) {
        UUIDSParts parts = UUIDUtils.parseUUIDParts(hexadecimalUUIDRepresentation);
        String path = File.separator + parts.getInvariantPart().substring(0, 7) + File.separator + parts.getInvariantPart().substring(7) + File.separator + parts.getSlowlyVariantPart().substring(0, 2) + File.separator + parts.getSlowlyVariantPart().substring(2) + File.separator + parts.getRapidlyVariantPart();
        return path;
    }

    static class UUIDSParts {
        private String time_low;
        private String time_mid;
        private String time_high_and_version;
        private String clock_seq_and_reserved;
        private String clock_seq_low;
        private String node;

        UUIDSParts() {
        }

        public String getInvariantPart() {
            return this.time_high_and_version + this.node;
        }

        public String getSlowlyVariantPart() {
            return this.time_mid;
        }

        public String getRapidlyVariantPart() {
            return this.time_low + this.clock_seq_and_reserved + this.clock_seq_low;
        }
    }
}

