/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import org.opensaml.MalformedException;
import org.opensaml.QName;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensaml.SAMLSubjectQuery;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAuthenticationQuery
extends SAMLSubjectQuery
implements Cloneable {
    protected String authMethod = null;

    public SAMLAuthenticationQuery() {
    }

    public SAMLAuthenticationQuery(SAMLSubject sAMLSubject, String string) throws SAMLException {
        super(sAMLSubject);
        this.authMethod = string;
    }

    public SAMLAuthenticationQuery(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public SAMLAuthenticationQuery(InputStream inputStream) throws SAMLException {
        this.fromDOM(SAMLAuthenticationQuery.fromStream(inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery")) {
            QName qName = QName.getQNameAttribute(element, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Query") && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "SubjectQuery") && qName != null && "urn:oasis:names:tc:SAML:1.0:protocol".equals(qName.getNamespaceURI()) && "AuthenticationQueryType".equals(qName.getLocalName()))) {
                throw new MalformedException(SAMLException.REQUESTER, "SAMLAuthenticationQuery.fromDOM() requires samlp:AuthenticationQuery at root");
            }
        }
        this.authMethod = element.getAttributeNS(null, "AuthenticationMethod");
        this.checkValidity();
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("authMethod cannot be null or empty");
        }
        this.authMethod = string;
        if (this.root != null) {
            ((Element)this.root).getAttributeNodeNS(null, "AuthenticationMethod").setNodeValue(string);
        }
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        this.root = super.toDOM(document, bl);
        if (this.root != null) {
            if (bl) {
                ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            }
            return this.root;
        }
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AuthenticationQuery");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
        }
        if (!XML.isEmpty(this.authMethod)) {
            element.setAttributeNS(null, "AuthenticationMethod", this.authMethod);
        }
        element.appendChild(this.subject.toDOM(document));
        this.root = element;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

