/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.usage.Usage;
import org.apache.activemq.usage.UsageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStoreCursor
extends AbstractPendingMessageCursor
implements MessageRecoveryListener,
UsageListener {
    private static final Log LOG = LogFactory.getLog(AbstractStoreCursor.class);
    protected final Destination regionDestination;
    private final LinkedHashMap<MessageId, Message> batchList = new LinkedHashMap();
    private Iterator<Map.Entry<MessageId, Message>> iterator = null;
    protected boolean cacheEnabled = false;
    protected boolean batchResetNeeded = true;
    protected boolean storeHasMessages = false;
    protected int size;

    protected AbstractStoreCursor(Destination destination) {
        this.regionDestination = destination;
    }

    public final synchronized void start() throws Exception {
        if (!this.isStarted()) {
            super.start();
            this.clear();
            this.resetBatch();
            this.size = this.getStoreSize();
            boolean bl = this.storeHasMessages = this.size > 0;
            if (!this.storeHasMessages && this.useCache) {
                this.cacheEnabled = true;
            }
        }
        this.getSystemUsage().getMemoryUsage().addUsageListener(this);
    }

    public final synchronized void stop() throws Exception {
        this.getSystemUsage().getMemoryUsage().removeUsageListener(this);
        this.resetBatch();
        super.stop();
        this.gc();
    }

    public final boolean recoverMessage(Message message) throws Exception {
        return this.recoverMessage(message, false);
    }

    public synchronized boolean recoverMessage(Message message, boolean cached) throws Exception {
        if (!this.isDuplicate(message.getMessageId())) {
            if (!cached) {
                message.setRegionDestination(this.regionDestination);
                if (message.getMemoryUsage() == null) {
                    message.setMemoryUsage(this.getSystemUsage().getMemoryUsage());
                }
            }
            message.incrementReferenceCount();
            this.batchList.put(message.getMessageId(), message);
            this.clearIterator(true);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Ignoring batched duplicated from store: " + message));
            }
            this.storeHasMessages = true;
        }
        return true;
    }

    public final void reset() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.clearIterator(true);
        this.size();
    }

    public synchronized void release() {
        this.clearIterator(false);
    }

    private synchronized void clearIterator(boolean ensureIterator) {
        boolean haveIterator = this.iterator != null;
        this.iterator = null;
        if (haveIterator && ensureIterator) {
            this.ensureIterator();
        }
    }

    private synchronized void ensureIterator() {
        if (this.iterator == null) {
            this.iterator = this.batchList.entrySet().iterator();
        }
    }

    public final void finished() {
    }

    public final synchronized boolean hasNext() {
        if (this.batchList.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.ensureIterator();
        return this.iterator.hasNext();
    }

    public final synchronized MessageReference next() {
        Message result = null;
        if (!this.batchList.isEmpty() && this.iterator.hasNext()) {
            result = this.iterator.next().getValue();
            result.decrementReferenceCount();
        }
        return result;
    }

    public final synchronized void addMessageLast(MessageReference node) throws Exception {
        if (this.cacheEnabled && this.hasSpace()) {
            this.recoverMessage(node.getMessage(), true);
        } else {
            this.cacheEnabled = false;
        }
        ++this.size;
    }

    public final synchronized void addMessageFirst(MessageReference node) throws Exception {
        this.cacheEnabled = false;
        ++this.size;
    }

    public final synchronized void remove() {
        --this.size;
        if (this.size == 0 && this.isStarted() && this.useCache) {
            this.cacheEnabled = true;
        }
        if (this.iterator != null) {
            this.iterator.remove();
        }
    }

    public final synchronized void remove(MessageReference node) {
        --this.size;
        this.cacheEnabled = false;
        this.batchList.remove(node.getMessageId());
    }

    public final synchronized void onUsageChanged(Usage usage, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage > newPercentUsage && oldPercentUsage >= this.memoryUsageHighWaterMark) {
            this.storeHasMessages = true;
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch ", (Throwable)e);
            }
        }
    }

    public final synchronized void clear() {
        this.gc();
    }

    public final synchronized void gc() {
        for (Message msg : this.batchList.values()) {
            this.rollback(msg.getMessageId());
            msg.decrementReferenceCount();
        }
        this.batchList.clear();
        this.clearIterator(false);
        this.batchResetNeeded = true;
        this.cacheEnabled = false;
        this.size = this.isStarted() ? this.getStoreSize() : 0;
    }

    protected final synchronized void fillBatch() {
        if (this.batchResetNeeded) {
            this.resetBatch();
            this.batchResetNeeded = false;
        }
        if (this.batchList.isEmpty() && (this.storeHasMessages || this.size > 0)) {
            this.storeHasMessages = false;
            try {
                this.doFillBatch();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
            if (!this.batchList.isEmpty()) {
                this.storeHasMessages = true;
            }
        }
    }

    public final synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public final synchronized boolean hasMessagesBufferedToDeliver() {
        return !this.batchList.isEmpty();
    }

    public final synchronized int size() {
        if (this.size < 0) {
            this.size = this.getStoreSize();
        }
        return this.size;
    }

    protected abstract void doFillBatch() throws Exception;

    protected abstract void resetBatch();

    protected abstract int getStoreSize();
}

