/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.calls;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.calls.GCUBECall;
import org.gcube.common.core.utils.handlers.GCUBEServiceClient;
import org.gcube.common.core.utils.handlers.GCUBEServiceClientImpl;
import org.gcube.common.core.utils.handlers.GCUBEStatefulServiceHandler;
import org.gcube.common.scope.api.ScopeProvider;

public abstract class WSCall
extends GCUBECall<WSResourceQuery> {
    public WSCall(GCUBEScopeManager scopeManager, GCUBESecurityManager ... securityManager) throws Exception {
        super(scopeManager, securityManager);
    }

    public WSCall(GCUBEScope scope, GCUBESecurityManager ... securityManager) throws Exception {
        super(scope, securityManager);
    }

    public WSCall(GCUBEServiceContext ctxt) throws Exception {
        super(ctxt, ctxt);
    }

    @Override
    protected WSResourceQuery getInitQuery() throws Exception {
        WSResourceQuery q = GHNContext.getImplementation(ISClient.class).getQuery(WSResourceQuery.class);
        q.addAtomicConditions(new AtomicCondition("/gc:ServiceName", this.getServiceName()), new AtomicCondition("/gc:ServiceClass", this.getServiceClass()));
        return q;
    }

    public abstract class WSCallHandler
    extends GCUBEStatefulServiceHandler<GCUBEServiceClientImpl> {
        public WSCallHandler() {
            super((GCUBEServiceClient)GCUBECall.clients.get(WSCall.this.getClass()));
            this.setLogger(WSCall.this.getLogger());
        }

        @Override
        protected void _interact(EndpointReferenceType epr) throws Exception {
            super._interact(epr);
            WSCall.this.setEndpointReference(epr);
        }

        @Override
        protected EndpointReferenceType getCachedEPR() {
            return WSCall.this.getEndpointReference() == null ? super.getCachedEPR() : WSCall.this.getEndpointReference();
        }

        @Override
        protected String getTargetPortTypeName() {
            return WSCall.this.getPortTypeName();
        }

        @Override
        public GCUBEScopeManager getScopeManager() {
            return WSCall.this.getScopeManager();
        }

        @Override
        protected List<RPDocument> findWSResources() throws Exception {
            ArrayList<RPDocument> documents = new ArrayList<RPDocument>();
            for (RPDocument d : GHNContext.getImplementation(ISClient.class).execute(WSCall.this.getQuery(), GCUBEScope.getScope(ScopeProvider.instance.get()))) {
                if (!d.getEndpoint().getAddress().getPath().endsWith(WSCall.this.getPortTypeName())) continue;
                documents.add(d);
            }
            return documents;
        }
    }
}

