/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.messages;

import org.gcube.common.core.monitoring.GCUBEMessage;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.Test;

public class RIMessage<TEST extends Test>
extends GCUBEMessage {
    private static final long serialVersionUID = 1L;
    public static final String RI = "MONITORING.RI";
    private TEST test;
    private String serviceName;
    private String serviceClass;

    public RIMessage() {
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public TEST getTest() {
        return this.test;
    }

    public void setTest(TEST test) {
        this.test = test;
    }

    public RIMessage(String ghnName, GCUBEScope VO) {
        this.sourceGHN = ghnName;
        this.topic = this.createTopicName(ghnName, VO);
        this.scope = VO.toString();
    }

    public String toString() {
        return this.sourceGHN + "/" + this.serviceClass + "/" + this.serviceName + "/" + this.time + "/" + ((Test)this.test).toString() + "/" + this.topic + "/" + this.scope;
    }

    private String createTopicName(String ghnName, GCUBEScope scope) {
        if (scope.isInfrastructure()) {
            return Test.replaceUnderscore(scope.getInfrastructure().getName()) + "." + RI + "." + Test.replaceUnderscore(ghnName);
        }
        if (scope.getType().compareTo((Enum)GCUBEScope.Type.VO) == 0) {
            String voName = scope.getName();
            return Test.replaceUnderscore(scope.getInfrastructure().getName()) + "." + Test.replaceUnderscore(voName) + "." + RI + "." + Test.replaceUnderscore(ghnName);
        }
        return null;
    }
}

