/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.md;

import cryptix.CryptixException;
import java.security.MessageDigest;

abstract class BlockMessageDigest
extends MessageDigest {
    private static final long MAX_COUNT = 0x1FFFFFFFFFFFFFFFL;
    private byte[] buffer;
    private int buffered;
    private long count;
    private int data_length = this.engineGetDataLength();

    protected long bitcount() {
        return this.count * 8L;
    }

    protected void engineReset() {
        this.buffered = 0;
        this.count = 0L;
    }

    protected void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        int n3;
        this.count += (long)n2;
        if (this.count > 0x1FFFFFFFFFFFFFFFL) {
            throw new CryptixException(this.getAlgorithm() + ": Maximum input length exceeded");
        }
        int n4 = this.data_length;
        while (n2 >= (n3 = n4 - this.buffered)) {
            System.arraycopy(byArray, n, this.buffer, this.buffered, n3);
            this.engineTransform(this.buffer);
            n2 -= n3;
            n += n3;
            this.buffered = 0;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, this.buffered, n2);
            this.buffered += n2;
        }
    }

    protected byte[] engineDigest() {
        return this.engineDigest(this.buffer, this.buffered);
    }

    protected abstract byte[] engineDigest(byte[] var1, int var2);

    protected abstract void engineTransform(byte[] var1);

    protected abstract int engineGetDataLength();

    protected BlockMessageDigest(String string) {
        super(string);
        this.buffer = new byte[this.data_length];
    }
}

