/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.GarbageCollector;

import java.io.File;
import java.util.Calendar;
import org.apache.log4j.Logger;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCProperties;

public class GCPolicy {
    private static Logger log = Logger.getLogger(GCPolicy.class);
    private static final short TRUE = 0;
    private static final short FALSE = 1;
    private static final short UNDEF = 2;
    private static final long defaultTime = 3600000L;

    public static boolean reclaim(GCProperties gCProperties) {
        long l = Calendar.getInstance().getTimeInMillis();
        short s = GCPolicy.lifeSpanPolicy(l, gCProperties);
        short s2 = GCPolicy.ssPolicy(gCProperties);
        short s3 = GCPolicy.defaultPolicy(l, gCProperties);
        log.debug((Object)("lsPolicy: " + s + " ssPolicy: " + s2 + " defPolicy: " + s3));
        log.debug((Object)("last access : " + gCProperties.getLastAccessed()));
        return GCPolicy.prioritize(s, s2, s3) == 0;
    }

    private static short prioritize(short s, short s2, short s3) {
        if (s2 != 2) {
            return s2;
        }
        if (s != 2) {
            return s;
        }
        return s3;
    }

    public static boolean reclaim(File file) {
        return file.lastModified() + 3600000L < Calendar.getInstance().getTimeInMillis();
    }

    private static short lifeSpanPolicy(long l, GCProperties gCProperties) {
        long l2 = l - gCProperties.getLastAccessed();
        long l3 = l - gCProperties.getLastAuthored();
        long l4 = gCProperties.getMaxLifeSpan();
        if (l4 == 0L) {
            return 2;
        }
        if (l2 > l4 && l3 > l4) {
            return 0;
        }
        return 1;
    }

    private static short ssPolicy(GCProperties gCProperties) {
        return 2;
    }

    private static short defaultPolicy(long l, GCProperties gCProperties) {
        long l2 = l - gCProperties.getLastAccessed();
        long l3 = l - gCProperties.getLastAuthored();
        if (l2 > 3600000L && l3 > 3600000L) {
            return 0;
        }
        return 1;
    }
}

