/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.layerindependent.descriptions;

import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicPropertyDescription;
import org.gcube.contentmanagement.layerindependent.descriptions.BasicReferenceDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicInfoObjectDescription {
    public static final String ANY_OBJECT = "*";
    public static final String OBJECT_ID = "contentmanagement:objectID";
    public static final String OBJECT_FLAVOUR = "contentmanagement:objectFlavour";
    public static final String LOCATION = "contentmanagement:location";
    public static final String OBJECT_TYPE_COLLECTION = "contentmanagement:collection";
    public static final String OBJECT_TYPE_DOCUMENT = "contentmanagement:document";
    public static final String OBJECT_TYPE_METADATA = "contentmanagement:metadata";
    public static final String OBJECT_TYPE_METADATA_COLLECTION = "contentmanagement:metadatacollection";
    @Deprecated
    public static final String OBJECT_TYPE_ANNOTATION = "contentmanagement:annotation";
    public static final String OBJECT_FLAVOUR_VIRTUAL = "contentmanagement:Virtual";
    public static final String OBJECT_FLAVOUR_MATERIALIZED = "contentmanagement:Materialized";
    public static final String RAW_CONTENT_DO_NOT_TRANSFER = "/dev/null";
    @Deprecated
    public static final String RAW_CONTENT_DO_NOT_TRANFER = "/dev/null";
    public static final String RAW_CONTENT_IN_MESSAGE = "inmessage://";
    public static final String OBJECT_NAME_NOT_SET = "(unnamed object)";
    private String objectID;
    private String name = "(unnamed object)";
    private String type;
    private long lastUpdate;
    private byte[] rawContent;
    private List<BasicReferenceDescription> references;
    private Map<String, BasicPropertyDescription> properties;

    public BasicInfoObjectDescription() {
        this.objectID = null;
        this.references = null;
        this.properties = null;
        this.rawContent = null;
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setObjectID(String objectID) {
        this.objectID = objectID;
    }

    @Deprecated
    public BasicPropertyDescription[] getProperties() {
        return this.properties.values().toArray(new BasicPropertyDescription[this.properties.size()]);
    }

    public Map<String, BasicPropertyDescription> getPropertyMap() {
        return this.properties;
    }

    public BasicPropertyDescription getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void setProperties(Map<String, BasicPropertyDescription> properties) {
        this.properties = properties;
    }

    @Deprecated
    public BasicReferenceDescription[] getReferences() {
        return this.references.toArray(new BasicReferenceDescription[this.references.size()]);
    }

    public List<BasicReferenceDescription> getReferencesCollection() {
        return this.references;
    }

    public void setReferences(List<BasicReferenceDescription> references) {
        this.references = references;
    }

    public BasicInfoObjectDescription(String objectid, String name, String type, Map<String, BasicPropertyDescription> properties, List<BasicReferenceDescription> references) {
        this.name = name;
        this.objectID = objectid;
        this.properties = properties;
        this.references = references;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.length() == 0) {
            this.name = OBJECT_NAME_NOT_SET;
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static boolean isDocumentType(String type) {
        return OBJECT_TYPE_DOCUMENT.equalsIgnoreCase(type);
    }

    public boolean isInstanceofDocumentType() {
        return BasicInfoObjectDescription.isDocumentType(this.getType());
    }

    public static boolean isCollectionType(String type) {
        return OBJECT_TYPE_COLLECTION.equalsIgnoreCase(type);
    }

    public boolean isInstanceofCollectionType() {
        return BasicInfoObjectDescription.isCollectionType(this.getType());
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean updatedSince(long time) {
        return time < this.lastUpdate;
    }

    public boolean transportsRawContent() {
        return this.rawContent != null;
    }

    public void setTemporaryRawContent(byte[] content) {
        this.rawContent = content;
    }

    public byte[] getTemporaryRawContent() {
        return this.rawContent;
    }
}

