/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.util;

import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSAndCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSBooleanPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSNotCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSOrCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSPropertyExistenceCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSStringPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSTimeInMillisecondsPropertyValueBetweenCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.WSTimeInMillisecondsPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.AndCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.BooleanPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.NotCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.OrCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.PropertyExistenceCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.StringPropertyValueCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.TimeInMillisecondsPropertyValueBetweenCondition;
import org.gcube.contentmanagement.storagelayer.storagemanagementservice.stubs.filter.property.TimeInMillisecondsPropertyValueCondition;

public class WSToObjectConditionsConverter {
    public static PropertyCondition convertToPropertyCondition(WSPropertyCondition condition) {
        if (condition.getAndCondition() != null) {
            return WSToObjectConditionsConverter.convertToAndCondition(condition.getAndCondition());
        }
        if (condition.getOrCondition() != null) {
            return WSToObjectConditionsConverter.convertToOrCondition(condition.getOrCondition());
        }
        if (condition.getNotCondition() != null) {
            return WSToObjectConditionsConverter.convertToNotCondition(condition.getNotCondition());
        }
        if (condition.getBooleanPropertyValueCondition() != null) {
            return WSToObjectConditionsConverter.convertToBooleanPropertyValueCondition(condition.getBooleanPropertyValueCondition());
        }
        if (condition.getStringPropertyValueCondition() != null) {
            return WSToObjectConditionsConverter.convertToStringPropertyValueCondition(condition.getStringPropertyValueCondition());
        }
        if (condition.getTimeInMillisecondsPropertyValueCondition() != null) {
            return WSToObjectConditionsConverter.convertToTimeInMillisecondsPropertyValueCondition(condition.getTimeInMillisecondsPropertyValueCondition());
        }
        if (condition.getTimeInMillisecondsPropertyValueBetweenCondition() != null) {
            return WSToObjectConditionsConverter.convertToTimeInMillisecondsPropertyValueBetweenCondition(condition.getTimeInMillisecondsPropertyValueBetweenCondition());
        }
        if (condition.getPropertyExistenceCondition() != null) {
            return WSToObjectConditionsConverter.convertToPropertyExistenceCondition(condition.getPropertyExistenceCondition());
        }
        return null;
    }

    public static StringPropertyValueCondition convertToStringPropertyValueCondition(WSStringPropertyValueCondition condition) {
        return new StringPropertyValueCondition(condition.getPropertyName(), condition.getPropertyValue());
    }

    public static BooleanPropertyValueCondition convertToBooleanPropertyValueCondition(WSBooleanPropertyValueCondition condition) {
        return new BooleanPropertyValueCondition(condition.getPropertyName(), condition.isPropertyValue());
    }

    public static TimeInMillisecondsPropertyValueCondition convertToTimeInMillisecondsPropertyValueCondition(WSTimeInMillisecondsPropertyValueCondition condition) {
        return new TimeInMillisecondsPropertyValueCondition(condition.getPropertyName(), condition.getPropertyValue());
    }

    public static TimeInMillisecondsPropertyValueBetweenCondition convertToTimeInMillisecondsPropertyValueBetweenCondition(WSTimeInMillisecondsPropertyValueBetweenCondition condition) {
        return new TimeInMillisecondsPropertyValueBetweenCondition(condition.getPropertyName(), condition.getLowerBound(), condition.getUpperBound());
    }

    public static PropertyExistenceCondition convertToPropertyExistenceCondition(WSPropertyExistenceCondition condition) {
        return new PropertyExistenceCondition(condition.getPropertyName());
    }

    public static AndCondition convertToAndCondition(WSAndCondition condition) {
        PropertyCondition leftCondition = WSToObjectConditionsConverter.convertToPropertyCondition(condition.getLeftCondition());
        PropertyCondition rightCondition = WSToObjectConditionsConverter.convertToPropertyCondition(condition.getRightCondition());
        return new AndCondition(leftCondition, rightCondition);
    }

    public static OrCondition convertToOrCondition(WSOrCondition condition) {
        PropertyCondition leftCondition = WSToObjectConditionsConverter.convertToPropertyCondition(condition.getLeftCondition());
        PropertyCondition rightCondition = WSToObjectConditionsConverter.convertToPropertyCondition(condition.getRightCondition());
        return new OrCondition(leftCondition, rightCondition);
    }

    public static NotCondition convertToNotCondition(WSNotCondition condition) {
        PropertyCondition notCondition = WSToObjectConditionsConverter.convertToPropertyCondition(condition.getNotCondition());
        return new NotCondition(notCondition);
    }
}

