/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.proxies;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.core.utils.proxies.AccessControlProxyContext;
import org.gcube.common.core.utils.proxies.ForwardProxyContext;
import org.gcube.common.core.utils.proxies.GCUBEProxyContext;
import org.gcube.common.core.utils.proxies.ReadOnlyProxyContext;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

public class GCUBEProxyFactory {
    static GCUBELog logger = new GCUBELog(GCUBEProxyFactory.class);
    protected static Map<Class<? extends Annotation>, Class<? extends GCUBEProxyContext<?>>> proxyClasses = new HashMap();

    public static synchronized void registerContexts(Class<? extends GCUBEProxyContext<?>> ... contextClasses) throws Exception {
        if (contextClasses == null) {
            return;
        }
        for (Class<GCUBEProxyContext<?>> clazz : contextClasses) {
            if (proxyClasses.containsKey(clazz)) {
                throw new Exception("A proxy for annotations of type " + clazz.getSimpleName() + " is alread registered");
            }
            proxyClasses.put(clazz.newInstance().getAnnotationClass(), clazz);
        }
    }

    protected static synchronized <ANNOTATION extends Annotation> GCUBEProxyContext<ANNOTATION> getProxy(Class<? extends ANNOTATION> annotationClass) throws Exception {
        Class<GCUBEProxyContext<?>> contextClass = proxyClasses.get(annotationClass);
        return contextClass == null ? null : contextClass.newInstance();
    }

    public static <TYPE> TYPE getProxy(TYPE proxied, Class<?> ... optionalInterface) throws Exception {
        return GCUBEProxyFactory.getProxy(new ForwardProxyContext(), proxied, optionalInterface);
    }

    public static <TYPE> TYPE getProxy(GCUBEProxyContext<?> context, TYPE proxied, Class<?> ... optionalInterface) throws Exception {
        Class<?> proxyInterface = optionalInterface != null && optionalInterface.length == 1 ? optionalInterface[0] : proxied.getClass();
        FlexEnhancer enhancer = new FlexEnhancer();
        enhancer.setCallbackType(MethodInterceptor.class);
        enhancer.setSuperclass(proxyInterface);
        Class proxyClass = enhancer.createClass();
        ObjenesisStd objenesis = new ObjenesisStd();
        ObjectInstantiator proxyInstantiator = objenesis.getInstantiatorOf(proxyClass);
        Factory proxy = (Factory)proxyInstantiator.newInstance();
        proxy.setCallback(0, (Callback)context.getInterceptor(proxied));
        return (TYPE)proxy;
    }

    static {
        try {
            GCUBEProxyFactory.registerContexts(AccessControlProxyContext.class, ReadOnlyProxyContext.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class FlexEnhancer
    extends Enhancer {
        protected void filterConstructors(Class sc, List constructors) {
        }
    }
}

