/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts.ghn;

import java.io.IOException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.node.Description;
import org.gcube.common.core.security.utils.HostCertificateReader;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class Builder {
    static GCUBELog logger = new GCUBELog(Builder.class);

    public static synchronized void createGHNResource(GHNContext context) throws GCUBEResource.InvalidScopeException {
        logger.setContext(context);
        context.getGHN().setResourceVersion(context.getGHN().getLastResourceVersion());
        context.getGHN().setInfrastructure((String)context.getProperty("infrastructure", true));
        GCUBEHostingNode.Site site = new GCUBEHostingNode.Site();
        site.setCountry((String)context.getProperty("country", false));
        site.setLocation((String)context.getProperty("location", false));
        String[] coordinates = ((String)context.getProperty("coordinates", false)).split(",");
        site.setLongitude(coordinates[1]);
        site.setLatitude(coordinates[0]);
        try {
            site.setDomain(context.getPublishedHostDomain());
        }
        catch (IOException e) {
            site.setDomain("unable-to-detect");
        }
        context.getGHN().setSite(site);
        Description.NetworkAdapter adapter = new Description.NetworkAdapter();
        adapter.setInboundIP("");
        adapter.setMTU(0L);
        adapter.setOutboundIP("");
        adapter.setName("local-adapter");
        adapter.setIPAddress(context.getIP());
        Properties prop = System.getProperties();
        Description.OperatingSystem os = new Description.OperatingSystem();
        os.setName(prop.getProperty("os.name"));
        os.setVersion(prop.getProperty("os.version"));
        os.setRelease("");
        Description.Architecture architecture = new Description.Architecture();
        architecture.setPlatformType(prop.getProperty("os.arch"));
        architecture.setSMPSize(0L);
        architecture.setSMTSize(0L);
        Description description = new Description();
        description.setArchitecture(architecture);
        description.setName(context.getPublishedHostnameAndPort());
        description.getNetworkAdapters().add(adapter);
        description.setOS(os);
        if (((Boolean)context.getProperty("securityenabled", false)).booleanValue() && !GHNContext.getContext().isClientMode()) {
            description.setSecurityEnabled(true);
            Description.SecurityData data = new Description.SecurityData();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                calendar.add(13, HostCertificateReader.getHostCertificateLifetime());
                data.setCredentianlsExpireOn(calendar);
            }
            catch (HostCertificateReader.ExpiredCredentialsException e) {
                calendar.set(1, 1970);
                data.setCredentianlsExpireOn(calendar);
            }
            catch (HostCertificateReader.IndefiniteLifetimeCredentialsException e) {
                calendar.set(1, 2010);
                data.setCredentianlsExpireOn(calendar);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                data.setCredentialsDistinguishedName(HostCertificateReader.getHostCertificateDN());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                data.setCA(HostCertificateReader.getHostCertificateCA());
            }
            catch (Exception e) {
                // empty catch block
            }
            description.addSecurityData(data);
        }
        ArrayList<HashMap<String, String>> CPU = context.getCPUInfo();
        List<Description.Processor> procs = description.getProcessors();
        for (HashMap<String, String> map : CPU) {
            Description.Processor p = new Description.Processor();
            p.setBogomips(new Double(map.get("bogomips")));
            p.setClockSpeedMHZ(new Double(map.get("cpu_MHz")));
            p.setFamily(map.get("cpu_family"));
            p.setModelName(map.get("model_name"));
            p.setModel(map.get("model"));
            p.setVendor(map.get("vendor_id"));
            p.setCacheL1(new Long(map.get("cache_size")));
            p.setCacheL1D(0L);
            p.setCacheL1I(0L);
            p.setCacheL2(0L);
            procs.add(p);
        }
        Description.RuntimeEnvironment runtime = new Description.RuntimeEnvironment();
        Builder.compileRuntime(context, runtime);
        description.setRuntime(runtime);
        String type = (String)context.getProperty("GHNtype", false);
        if (type.compareToIgnoreCase(GHNContext.Type.DYNAMIC.toString()) == 0) {
            description.setType(Description.Type.Dynamic);
        } else if (type.compareToIgnoreCase(GHNContext.Type.STATIC.toString()) == 0) {
            description.setType(Description.Type.Static);
        } else if (type.compareToIgnoreCase(GHNContext.Type.SELFCLEANING.toString()) == 0) {
            description.setType(Description.Type.Selfcleaning);
        }
        Description.FileSystem fs = new Description.FileSystem();
        fs.setName("");
        fs.setRoot(context.getLocation());
        fs.setReadOnly(false);
        context.getGHN().setNodeDescription(description);
        Builder.updateGHNResource(context, true);
    }

    public static synchronized void updateGHNResource(GHNContext context, boolean ... startup) {
        logger.setContext(context);
        Description description = context.getGHN().getNodeDescription();
        if (description == null) {
            logger.error("GHN description in the node profile is NULL");
            return;
        }
        if (startup != null && startup.length > 0 && startup[0]) {
            description.setActivationTime(new GregorianCalendar());
            description.setName(context.getPublishedHostnameAndPort());
            Description.RuntimeEnvironment runtime = new Description.RuntimeEnvironment();
            Builder.compileRuntime(context, runtime);
            description.setRuntime(runtime);
            GCUBEHostingNode.Site site = new GCUBEHostingNode.Site();
            site.setCountry((String)context.getProperty("country", false));
            site.setLocation((String)context.getProperty("location", false));
            String[] coordinates = ((String)context.getProperty("coordinates", false)).split(",");
            site.setLongitude(coordinates[1]);
            site.setLatitude(coordinates[0]);
            try {
                site.setDomain(context.getPublishedHostDomain());
            }
            catch (IOException e) {
                site.setDomain("unable-to-detect");
            }
            context.getGHN().setSite(site);
        }
        description.setStatus(context.getStatus(), new String[0]);
        Map<String, Long> mem = context.getMemoryUsage();
        Description.Memory memory = new Description.Memory();
        memory.setAvailable(mem.get("MemoryAvailable"));
        memory.setSize(mem.get("MemoryTotalSize"));
        memory.setVirtualAvailable(mem.get("VirtualAvailable"));
        memory.setVirtualSize(mem.get("VirtualSize"));
        description.setMemory(memory);
        description.setLocalAvailableSpace(context.getFreeSpace(context.getLocation()));
        description.setUptime(context.getUptime());
        description.setLastUpdate(new GregorianCalendar());
        if (((Boolean)context.getProperty("securityenabled", false)).booleanValue() && !GHNContext.getContext().isClientMode()) {
            description.setSecurityEnabled(true);
            Description.SecurityData data = new Description.SecurityData();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                calendar.add(13, HostCertificateReader.getHostCertificateLifetime());
                data.setCredentianlsExpireOn(calendar);
            }
            catch (HostCertificateReader.ExpiredCredentialsException e) {
                calendar.set(1, 1970);
                data.setCredentianlsExpireOn(calendar);
            }
            catch (HostCertificateReader.IndefiniteLifetimeCredentialsException e) {
                calendar.set(1, 2010);
                data.setCredentianlsExpireOn(calendar);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                data.setCredentialsDistinguishedName(HostCertificateReader.getHostCertificateDN());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                data.setCA(HostCertificateReader.getHostCertificateCA());
            }
            catch (Exception e) {
                // empty catch block
            }
            description.addSecurityData(data);
        }
        Map<String, Double> loads = context.getLoadStatistics();
        Description.Load load = new Description.Load();
        load.setLast1min(loads.get("1min"));
        load.setLast5min(loads.get("5mins"));
        load.setLast15min(loads.get("15mins"));
        description.setLoad(load);
        context.getGHN().setNodeDescription(description);
    }

    private static void compileRuntime(GHNContext context, Description.RuntimeEnvironment runtime) {
        HashMap<String, String> envvars = new HashMap<String, String>();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(context.getFile((String)context.getProperty("labels", true), new boolean[0]));
            doc.getDocumentElement().normalize();
            doc.getDocumentElement().getNodeName();
            NodeList listOfVariables = doc.getElementsByTagName("Variable");
            for (int s = 0; s < listOfVariables.getLength(); ++s) {
                Node varNode = listOfVariables.item(s);
                if (varNode.getNodeType() != 1) continue;
                Element varElement = (Element)varNode;
                NodeList keyList = varElement.getElementsByTagName("Key");
                Element element = (Element)keyList.item(0);
                NodeList textList = element.getChildNodes();
                String key = textList.item(0).getNodeValue().trim();
                keyList = varElement.getElementsByTagName("Value");
                element = (Element)keyList.item(0);
                textList = element.getChildNodes();
                String value = textList.item(0).getNodeValue().trim();
                envvars.put(key, value);
            }
        }
        catch (SAXParseException err) {
            logger.error("Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
        }
        catch (Exception e) {
            logger.error("Parsing error ", e);
        }
        envvars.putAll(System.getenv());
        List<Description.RuntimeEnvironment.Variable> vars = runtime.getVariables();
        for (String varname : envvars.keySet()) {
            if (varname.compareToIgnoreCase("CLASSPATH") == 0 || varname.compareToIgnoreCase("PATH") == 0 || varname.contains("SSH") || varname.contains("MAIL") || varname.compareToIgnoreCase("LS_COLORS") == 0) continue;
            vars.add(Builder.newVariable(varname, (String)envvars.get(varname)));
        }
        vars.add(Builder.newVariable("Java", System.getProperty("java.version")));
        vars.add(Builder.newVariable("gCF-version", "1.6.0"));
        vars.add(Builder.newVariable("gCore-version", "1.6.0"));
        vars.add(Builder.newVariable("ghn-update-interval-in-secs", ((Long)context.getProperty("updateInterval", false)).toString()));
    }

    private static Description.RuntimeEnvironment.Variable newVariable(String key, String value) {
        Description.RuntimeEnvironment.Variable var = new Description.RuntimeEnvironment.Variable();
        var.setKey(key);
        var.setValue(value);
        return var;
    }
}

