package org.gcube.common.clients;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An instrumentation agent of the JVM that starts a {@link ClientRuntime}.
 * <p>
 * It is invoked by JVMs started with the property <code>-javaagent:</code> pointing to the path of this class' jar.
 * 
 * @author Fabio Simeoni
 *
 */
public class Launcher {

	private static Logger log = LoggerFactory.getLogger(Launcher.class);
	
	public static void premain(String agentArgs) {

		try {
			ClientRuntime.start();
		}
		catch(Throwable t) {
			log.error("could not start the client container and its services",t);
		}

	}
}
