/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.handlers;

import java.io.IOException;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMConnection;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.FLAP;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLV;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.handlers.AdminListener;
import org.walluck.oscar.handlers.MiscHandler;
import org.walluck.oscar.handlers.SNACHandler;

public class AdminHandler
extends SNACHandler {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$handlers$AdminHandler == null ? (class$org$walluck$oscar$handlers$AdminHandler = AdminHandler.class$("org.walluck.oscar.handlers.AdminHandler")) : class$org$walluck$oscar$handlers$AdminHandler).getName());
    static /* synthetic */ Class class$org$walluck$oscar$handlers$AdminHandler;

    public AdminHandler() {
        this.setFamily(7);
        this.setVersion(1);
    }

    public void getInfo(AIMSession sess, AIMConnection conn, int info) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(7, 2, 0, null, true);
        AIMOutputStream buffer = new AIMOutputStream(4);
        buffer.writeShort(info);
        buffer.writeShort(0);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    private void infoChange(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short perms = buffer.readShort();
        short tlvcount = buffer.readShort();
        short err = -1;
        String url = null;
        String sn = null;
        String email = null;
        TLVChain tlvchain = buffer.readTLVChainByCount(tlvcount);
        Iterator i = tlvchain.iterator();
        while (i.hasNext()) {
            TLV tlv = (TLV)i.next();
            switch (tlv.getType()) {
                case 1: {
                    sn = tlv.getValueString();
                    break;
                }
                case 4: {
                    url = tlv.getValueString();
                    break;
                }
                case 8: {
                    err = tlv.getValueShort();
                    break;
                }
                case 17: {
                    email = tlv.getLength() == 0 ? "*suppressed*" : tlv.getValueString();
                    break;
                }
                default: {
                    LOG.warn((Object)("Unknown tlv type=" + Integer.toHexString(tlv.getType())));
                }
            }
            Iterator i2 = frame.getConn().getListeners(7, snac.getSubtype());
            while (i2.hasNext()) {
                ((AdminListener)i2.next()).infoChange(sess, frame, snac.getSubtype() == 5, perms, err, url, sn, email);
            }
        }
    }

    public void setNick(AIMSession sess, AIMConnection conn, String newNick) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(7, 4, 0, null, true);
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addString(1, newNick);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void changePassword(AIMSession sess, AIMConnection conn, String newPw, String curPw) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(7, 4, 0, null, true);
        TLVChain tlvchain = new TLVChain(2);
        tlvchain.addString(2, newPw);
        tlvchain.addString(18, curPw);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void setEmail(AIMSession sess, AIMConnection conn, String newEmail) throws IOException {
        FLAP flap = new FLAP(2);
        SNAC snac = new SNAC(7, 4, 0, null, true);
        TLVChain tlvchain = new TLVChain(1);
        tlvchain.addString(17, newEmail);
        AIMOutputStream buffer = new AIMOutputStream(tlvchain.length());
        buffer.writeTLVChain(tlvchain);
        conn.enqueueFrame(new AIMFrame(conn, 0, flap, snac, buffer));
    }

    public void reqConfirm(AIMSession sess, AIMConnection conn) throws IOException {
        MiscHandler misc = (MiscHandler)sess.getHandler(65535);
        misc.genericReqNull(sess, conn, 7, 4);
    }

    private void accountConfirm(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        short status = buffer.readShort();
        Iterator i = frame.getConn().getListeners(7, 7);
        while (i.hasNext()) {
            ((AdminListener)i.next()).accountConfirm(sess, frame, status);
        }
    }

    public void handleSNAC(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, AIMInputStream buffer) throws IOException {
        if (snac.getSubtype() == 3 || snac.getSubtype() == 5) {
            this.infoChange(sess, handler, frame, snac, buffer);
        } else if (snac.getSubtype() == 7) {
            this.accountConfirm(sess, handler, frame, snac, buffer);
        } else {
            LOG.warn((Object)("Unrecognized SNAC(" + Integer.toHexString(snac.getFamily()) + ", " + Integer.toHexString(snac.getSubtype()) + ")"));
            frame.setHandled(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

