/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.trash;

import com.liferay.portal.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.model.ContainerModel;
import com.liferay.portal.model.TrashedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.RepositoryServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppHelperLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileShortcutLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import com.liferay.portlet.documentlibrary.trash.DLBaseTrashHandler;
import com.liferay.portlet.documentlibrary.trash.DLFileShortcutTrashRenderer;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.trash.model.TrashEntry;
import javax.portlet.PortletRequest;

public class DLFileShortcutTrashHandler
extends DLBaseTrashHandler {
    public void deleteTrashEntry(long classPK) throws PortalException, SystemException {
        DLAppLocalServiceUtil.deleteFileShortcut((long)classPK);
    }

    public String getClassName() {
        return DLFileShortcut.class.getName();
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        long parentFolderId = dlFileShortcut.getFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public ContainerModel getParentContainerModel(TrashedModel trashedModel) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = (DLFileShortcut)trashedModel;
        return this.getContainerModel(fileShortcut.getFolderId());
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        return DLUtil.getDLFileEntryControlPanelLink((PortletRequest)portletRequest, (long)dlFileShortcut.getToFileEntryId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getDLFileShortcut(classPK);
        return DLUtil.getDLFolderControlPanelLink((PortletRequest)portletRequest, (long)fileShortcut.getFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getDLFileShortcut(classPK);
        return DLUtil.getAbsolutePath((PortletRequest)portletRequest, (long)fileShortcut.getFolderId());
    }

    public TrashEntry getTrashEntry(long classPK) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getDLFileShortcut(classPK);
        return fileShortcut.getTrashEntry();
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getDLFileShortcut(classPK);
        return new DLFileShortcutTrashRenderer(fileShortcut);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException, SystemException {
        if (trashActionId.equals("MOVE")) {
            return DLFolderPermission.contains(permissionChecker, groupId, classPK, "ADD_SHORTCUT");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isInTrash(long classPK) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getDLFileShortcut(classPK);
        return fileShortcut.isInTrash();
    }

    public boolean isInTrashContainer(long classPK) throws PortalException, SystemException {
        DLFileShortcut fileShortcut = this.getDLFileShortcut(classPK);
        return fileShortcut.isInTrashContainer();
    }

    public boolean isRestorable(long classPK) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        try {
            dlFileShortcut.getFolder();
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return false;
        }
        return !dlFileShortcut.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        DLAppLocalServiceUtil.updateFileShortcut((long)userId, (long)classPK, (long)containerModelId, (long)dlFileShortcut.getToFileEntryId(), (ServiceContext)serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException, SystemException {
        DLAppHelperLocalServiceUtil.moveFileShortcutFromTrash((long)userId, (DLFileShortcut)this.getDLFileShortcut(classPK), (long)containerModelId, (ServiceContext)serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException, SystemException {
        DLAppHelperLocalServiceUtil.restoreFileShortcutFromTrash((long)userId, (DLFileShortcut)this.getDLFileShortcut(classPK));
    }

    protected DLFileShortcut getDLFileShortcut(long classPK) throws PortalException, SystemException {
        return DLFileShortcutLocalServiceUtil.getDLFileShortcut((long)classPK);
    }

    @Override
    protected Repository getRepository(long classPK) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        Repository repository = RepositoryServiceUtil.getRepositoryImpl((long)0L, (long)dlFileShortcut.getToFileEntryId(), (long)0L);
        if (!(repository instanceof LiferayRepository)) {
            throw new InvalidRepositoryException("Repository " + repository.getRepositoryId() + " does not support trash operations");
        }
        return repository;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException, SystemException {
        DLFileShortcut dlFileShortcut = this.getDLFileShortcut(classPK);
        if (dlFileShortcut.isInHiddenFolder() && actionId.equals("VIEW")) {
            return false;
        }
        return DLFileShortcutPermission.contains(permissionChecker, classPK, actionId);
    }
}

