/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.base.UserGroupGroupRoleServiceBaseImpl;
import com.liferay.portal.service.permission.UserGroupRolePermissionUtil;

public class UserGroupGroupRoleServiceImpl
extends UserGroupGroupRoleServiceBaseImpl {
    public void addUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) throws PortalException, SystemException {
        this.checkPermission(groupId, roleIds);
        this.userGroupGroupRoleLocalService.addUserGroupGroupRoles(userGroupId, groupId, roleIds);
    }

    public void addUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) throws PortalException, SystemException {
        this.checkPermission(groupId, new long[]{roleId});
        this.userGroupGroupRoleLocalService.addUserGroupGroupRoles(userGroupIds, groupId, roleId);
    }

    public void deleteUserGroupGroupRoles(long userGroupId, long groupId, long[] roleIds) throws PortalException, SystemException {
        this.checkPermission(groupId, roleIds);
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupId, groupId, roleIds);
    }

    public void deleteUserGroupGroupRoles(long[] userGroupIds, long groupId, long roleId) throws PortalException, SystemException {
        this.checkPermission(groupId, new long[]{roleId});
        this.userGroupGroupRoleLocalService.deleteUserGroupGroupRoles(userGroupIds, groupId, roleId);
    }

    protected void checkPermission(long groupId, long[] roleIds) throws PortalException, SystemException {
        long[] lArray = roleIds;
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            UserGroupRolePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (long)roleId);
            ++n2;
        }
    }
}

