/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.index.IndexEncoder;
import com.liferay.portal.kernel.cache.index.PortalCacheIndexer;
import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.util.AutoResetThreadLocal;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Role;
import com.liferay.portal.security.permission.PermissionCheckerBag;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.security.permission.UserPermissionCheckerBag;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class PermissionCacheUtil {
    public static final String PERMISSION_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_PERMISSION";
    public static final String PERMISSION_CHECKER_BAG_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_PERMISSION_CHECKER_BAG";
    public static final String RESOURCE_BLOCK_IDS_BAG_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_RESOURCE_BLOCK_IDS_BAG";
    public static final String USER_PERMISSION_CHECKER_BAG_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_USER_PERMISSION_CHECKER_BAG";
    public static final String USER_ROLE_CACHE_NAME = String.valueOf(PermissionCacheUtil.class.getName()) + "_USER_ROLE";
    private static ThreadLocal<LRUMap> _localCache;
    private static boolean _localCacheAvailable;
    private static final PortalCache<BagKey, PermissionCheckerBag> _permissionCheckerBagPortalCache;
    private static final PortalCacheIndexer<Long, BagKey, PermissionCheckerBag> _permissionCheckerBagPortalCacheIndexer;
    private static final PortalCache<PermissionKey, Boolean> _permissionPortalCache;
    private static final PortalCacheIndexer<Long, PermissionKey, Boolean> _permissionPortalCacheGroupIdIndexer;
    private static final PortalCacheIndexer<String, PermissionKey, Boolean> _permissionPortalCacheNamePrimKeyIndexer;
    private static final PortalCache<ResourceBlockIdsBagKey, ResourceBlockIdsBag> _resourceBlockIdsBagCache;
    private static final PortalCacheIndexer<String, ResourceBlockIdsBagKey, ResourceBlockIdsBag> _resourceBlockIdsBagCacheIndexer;
    private static final PortalCache<Long, UserPermissionCheckerBag> _userPermissionCheckerBagPortalCache;
    private static final PortalCache<UserRoleKey, Boolean> _userRolePortalCache;
    private static final PortalCacheIndexer<Long, UserRoleKey, Boolean> _userRolePortalCacheIndexer;

    static {
        _permissionCheckerBagPortalCache = MultiVMPoolUtil.getCache((String)PERMISSION_CHECKER_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _permissionCheckerBagPortalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new BagKeyIndexEncoder(), _permissionCheckerBagPortalCache);
        _permissionPortalCache = MultiVMPoolUtil.getCache((String)PERMISSION_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _permissionPortalCacheGroupIdIndexer = new PortalCacheIndexer((IndexEncoder)new PermissionKeyGroupIdIndexEncoder(), _permissionPortalCache);
        _permissionPortalCacheNamePrimKeyIndexer = new PortalCacheIndexer((IndexEncoder)new PermissionKeyNamePrimKeyIndexEncoder(), _permissionPortalCache);
        _resourceBlockIdsBagCache = MultiVMPoolUtil.getCache((String)RESOURCE_BLOCK_IDS_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _resourceBlockIdsBagCacheIndexer = new PortalCacheIndexer((IndexEncoder)new ResourceBlockIdsBagKeyIndexEncoder(), _resourceBlockIdsBagCache);
        _userPermissionCheckerBagPortalCache = MultiVMPoolUtil.getCache((String)USER_PERMISSION_CHECKER_BAG_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _userRolePortalCache = MultiVMPoolUtil.getCache((String)USER_ROLE_CACHE_NAME, (boolean)PropsValues.PERMISSIONS_OBJECT_BLOCKING_CACHE);
        _userRolePortalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new UserRoleKeyIndexEncoder(), _userRolePortalCache);
        if (PropsValues.PERMISSIONS_THREAD_LOCAL_CACHE_MAX_SIZE > 0) {
            _localCache = new AutoResetThreadLocal(PermissionCacheUtil.class + "._localCache", (Object)new LRUMap(PropsValues.PERMISSIONS_THREAD_LOCAL_CACHE_MAX_SIZE));
            _localCacheAvailable = true;
        }
    }

    public static void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        PermissionCacheUtil.clearLocalCache();
        _permissionCheckerBagPortalCache.removeAll();
        _permissionPortalCache.removeAll();
        _resourceBlockIdsBagCache.removeAll();
        _userPermissionCheckerBagPortalCache.removeAll();
        _userRolePortalCache.removeAll();
    }

    public static void clearLocalCache() {
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.clear();
        }
    }

    public static void clearCache(long ... userIds) {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        PermissionCacheUtil.clearLocalCache();
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            _userPermissionCheckerBagPortalCache.remove((Serializable)Long.valueOf(userId));
            _permissionCheckerBagPortalCacheIndexer.removeKeys((Object)userId);
            _userRolePortalCacheIndexer.removeKeys((Object)userId);
            ++n2;
        }
        _permissionPortalCache.removeAll();
        _resourceBlockIdsBagCache.removeAll();
    }

    public static void clearResourceBlockCache(long companyId, long groupId, String name) {
        if (ExportImportThreadLocal.isImportInProcess() || !PermissionThreadLocal.isFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name)) {
            return;
        }
        PermissionCacheUtil.clearLocalCache();
        _resourceBlockIdsBagCacheIndexer.removeKeys((Object)ResourceBlockIdsBagKeyIndexEncoder.encode(companyId, groupId, name));
    }

    public static void clearResourceCache() {
        if (!ExportImportThreadLocal.isImportInProcess()) {
            PermissionCacheUtil.clearLocalCache();
            _resourceBlockIdsBagCache.removeAll();
            _permissionPortalCache.removeAll();
        }
    }

    public static void clearResourcePermissionCache(int scope, String name, String primKey) {
        if (ExportImportThreadLocal.isImportInProcess() || !PermissionThreadLocal.isFlushResourcePermissionEnabled((String)name, (String)primKey)) {
            return;
        }
        PermissionCacheUtil.clearLocalCache();
        if (scope == 4) {
            _permissionPortalCacheNamePrimKeyIndexer.removeKeys((Object)PermissionKeyNamePrimKeyIndexEncoder.encode(name, primKey));
        } else if (scope == 2) {
            _permissionPortalCacheGroupIdIndexer.removeKeys((Object)Long.valueOf(primKey));
        } else {
            _permissionPortalCache.removeAll();
        }
    }

    public static PermissionCheckerBag getBag(long userId, long groupId) {
        BagKey bagKey = new BagKey(userId, groupId);
        return (PermissionCheckerBag)PermissionCacheUtil.get(bagKey, _permissionCheckerBagPortalCache);
    }

    public static Boolean getPermission(long userId, boolean signedIn, long groupId, String name, String primKey, String actionId) {
        PermissionKey permissionKey = new PermissionKey(userId, signedIn, groupId, name, primKey, actionId);
        return (Boolean)PermissionCacheUtil.get(permissionKey, _permissionPortalCache);
    }

    public static ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long groupId, long userId, String name) {
        ResourceBlockIdsBagKey resourceBlockIdsBagKey = new ResourceBlockIdsBagKey(companyId, groupId, userId, name);
        return (ResourceBlockIdsBag)PermissionCacheUtil.get(resourceBlockIdsBagKey, _resourceBlockIdsBagCache);
    }

    public static UserPermissionCheckerBag getUserBag(long userId) {
        return (UserPermissionCheckerBag)PermissionCacheUtil.get(userId, _userPermissionCheckerBagPortalCache);
    }

    public static Boolean getUserRole(long userId, Role role) {
        UserRoleKey userRoleKey = new UserRoleKey(userId, role.getRoleId());
        Boolean userRole = (Boolean)_userRolePortalCache.get((Serializable)userRoleKey);
        if (userRole != null) {
            return userRole;
        }
        return null;
    }

    public static void putBag(long userId, long groupId, PermissionCheckerBag bag) {
        if (bag == null) {
            return;
        }
        BagKey bagKey = new BagKey(userId, groupId);
        PermissionCacheUtil.put(bagKey, bag, _permissionCheckerBagPortalCache);
    }

    public static void putPermission(long userId, boolean signedIn, long groupId, String name, String primKey, String actionId, Boolean value) {
        PermissionKey permissionKey = new PermissionKey(userId, signedIn, groupId, name, primKey, actionId);
        PermissionCacheUtil.put(permissionKey, value, _permissionPortalCache);
    }

    public static void putResourceBlockIdsBag(long companyId, long groupId, long userId, String name, ResourceBlockIdsBag resourceBlockIdsBag) {
        if (resourceBlockIdsBag == null) {
            return;
        }
        ResourceBlockIdsBagKey resourceBlockIdsBagKey = new ResourceBlockIdsBagKey(companyId, groupId, userId, name);
        PermissionCacheUtil.put(resourceBlockIdsBagKey, resourceBlockIdsBag, _resourceBlockIdsBagCache);
    }

    public static void putUserBag(long userId, UserPermissionCheckerBag userPermissionCheckerBag) {
        PermissionCacheUtil.put(userId, userPermissionCheckerBag, _userPermissionCheckerBagPortalCache);
    }

    protected static <K extends Serializable, V, C extends PortalCache<K, V>> V get(K key, C portalCache) {
        Object value = null;
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            value = localCache.get(key);
        }
        if (value == null) {
            value = portalCache.get(key);
        }
        return (V)value;
    }

    protected static <K extends Serializable, V, C extends PortalCache<K, V>> void put(K key, V value, C portalCache) {
        if (_localCacheAvailable) {
            Map localCache = (Map)_localCache.get();
            localCache.put(key, value);
        }
        portalCache.put(key, value);
    }

    public static void putUserRole(long userId, Role role, Boolean value) {
        if (value == null) {
            return;
        }
        UserRoleKey userRoleKey = new UserRoleKey(userId, role.getRoleId());
        _userRolePortalCache.put((Serializable)userRoleKey, (Object)value);
    }

    private static class BagKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _groupId;
        private final long _userId;

        public boolean equals(Object obj) {
            BagKey bagKey = (BagKey)obj;
            return bagKey._userId == this._userId && bagKey._groupId == this._groupId;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            return HashUtil.hash((int)hashCode, (long)this._groupId);
        }

        private BagKey(long userId, long groupId) {
            this._userId = userId;
            this._groupId = groupId;
        }
    }

    private static class BagKeyIndexEncoder
    implements IndexEncoder<Long, BagKey> {
        private BagKeyIndexEncoder() {
        }

        public Long encode(BagKey bagKey) {
            return bagKey._userId;
        }
    }

    private static class PermissionKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _actionId;
        private final long _groupId;
        private final String _name;
        private final String _primKey;
        private final boolean _signedIn;
        private final long _userId;

        public boolean equals(Object obj) {
            PermissionKey permissionKey = (PermissionKey)obj;
            return permissionKey._userId == this._userId && permissionKey._signedIn == this._signedIn && permissionKey._groupId == this._groupId && Validator.equals((Object)permissionKey._name, (Object)this._name) && Validator.equals((Object)permissionKey._primKey, (Object)this._primKey) && Validator.equals((Object)permissionKey._actionId, (Object)this._actionId);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (boolean)this._signedIn);
            hashCode = HashUtil.hash((int)hashCode, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._primKey);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._actionId);
            return hashCode;
        }

        private PermissionKey(long userId, boolean signedIn, long groupId, String name, String primKey, String actionId) {
            this._userId = userId;
            this._signedIn = signedIn;
            this._groupId = groupId;
            this._name = name;
            this._primKey = primKey;
            this._actionId = actionId;
        }
    }

    private static class PermissionKeyGroupIdIndexEncoder
    implements IndexEncoder<Long, PermissionKey> {
        private PermissionKeyGroupIdIndexEncoder() {
        }

        public Long encode(PermissionKey permissionKey) {
            return permissionKey._groupId;
        }
    }

    private static class PermissionKeyNamePrimKeyIndexEncoder
    implements IndexEncoder<String, PermissionKey> {
        private PermissionKeyNamePrimKeyIndexEncoder() {
        }

        public static String encode(String name, String primKey) {
            return name.concat("_").concat(primKey);
        }

        public String encode(PermissionKey permissionKey) {
            return PermissionKeyNamePrimKeyIndexEncoder.encode(permissionKey._name, permissionKey._primKey);
        }
    }

    private static class ResourceBlockIdsBagKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _companyId;
        private final long _groupId;
        private final String _name;
        private final long _userId;

        public boolean equals(Object obj) {
            ResourceBlockIdsBagKey resourceBlockIdsKey = (ResourceBlockIdsBagKey)obj;
            return resourceBlockIdsKey._companyId == this._companyId && resourceBlockIdsKey._groupId == this._groupId && resourceBlockIdsKey._userId == this._userId && Validator.equals((Object)resourceBlockIdsKey._name, (Object)this._name);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._companyId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (long)this._userId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._name);
            return hashCode;
        }

        private ResourceBlockIdsBagKey(long companyId, long groupId, long userId, String name) {
            this._companyId = companyId;
            this._groupId = groupId;
            this._userId = userId;
            this._name = name;
        }
    }

    private static class ResourceBlockIdsBagKeyIndexEncoder
    implements IndexEncoder<String, ResourceBlockIdsBagKey> {
        private ResourceBlockIdsBagKeyIndexEncoder() {
        }

        public static String encode(long companyId, long groupId, String name) {
            StringBundler sb = new StringBundler(5);
            sb.append(companyId);
            sb.append("_");
            sb.append(groupId);
            sb.append("_");
            sb.append(name);
            return sb.toString();
        }

        public String encode(ResourceBlockIdsBagKey resourceBlockIdsBagKey) {
            return ResourceBlockIdsBagKeyIndexEncoder.encode(resourceBlockIdsBagKey._companyId, resourceBlockIdsBagKey._groupId, resourceBlockIdsBagKey._name);
        }
    }

    private static class UserRoleKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long _roleId;
        private final long _userId;

        public boolean equals(Object obj) {
            UserRoleKey userRoleKey = (UserRoleKey)obj;
            return userRoleKey._userId == this._userId && userRoleKey._roleId == this._roleId;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._userId);
            return HashUtil.hash((int)hashCode, (long)this._roleId);
        }

        private UserRoleKey(long userId, long roleId) {
            this._userId = userId;
            this._roleId = roleId;
        }
    }

    private static class UserRoleKeyIndexEncoder
    implements IndexEncoder<Long, UserRoleKey> {
        private UserRoleKeyIndexEncoder() {
        }

        public Long encode(UserRoleKey userRoleKey) {
            return userRoleKey._userId;
        }
    }
}

