/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.impl;

import org.bson.types.ObjectId;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.impl.ServiceEngine;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    final Logger logger = LoggerFactory.getLogger(ServiceEngine.class);
    protected static final String BACKEND_STRING_SEPARATOR = "%";
    protected MyFile file;
    protected ServiceEngine engine;

    public Resource(MyFile file, ServiceEngine engine) {
        this.setMyFile(file);
        this.setEngine(engine);
    }

    protected ServiceEngine getEngine() {
        return this.engine;
    }

    protected void setEngine(ServiceEngine engine) {
        this.engine = engine;
    }

    protected MyFile getMyFile() {
        return this.file;
    }

    protected void setMyFile(MyFile f) {
        if (f != null) {
            this.file = f;
        } else {
            this.logger.warn("instantiated an empty file object");
        }
    }

    protected MyFile setGenericProperties(String context, String owner, String path, String type) {
        if (path != null && path.length() > 0) {
            if (ObjectId.isValid((String)path)) {
                String id;
                if (this.file == null) {
                    this.file = new MyFile(path, this.engine.getGcubeMemoryType());
                }
                if ((id = this.file.getId()) != null && !id.isEmpty()) {
                    this.file.setId2(path);
                } else {
                    this.file.setId(path);
                }
                this.file.setRootPath(context);
                this.file.setAbsoluteRemotePath(context);
            } else {
                String[] dirs = path.split("/");
                String name = dirs[dirs.length - 1];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("path(String) - name: " + name);
                }
                if (this.file == null) {
                    this.file = new MyFile(name, this.engine.getGcubeMemoryType());
                } else {
                    this.file.setName(name);
                }
                if (type.equalsIgnoreCase("remote") && context != null && context.length() > 0) {
                    this.file.setRootPath(context);
                    path = new BucketCoding().bucketFileCoding(path, context);
                    this.file.setAbsoluteRemotePath(path);
                }
                String dir = path.substring(0, path.length() - name.length());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("path(String) - path: " + dir);
                }
                if (type.equalsIgnoreCase("local")) {
                    if (this.file.getLocalDir() == null) {
                        this.file.setLocalDir(dir);
                    }
                } else if (this.file.getRemoteDir() == null) {
                    this.file.setRemoteDir(dir);
                }
            }
            this.file.setOwner(owner);
        } else {
            this.file.setOwner(owner);
            this.file.setRootPath(context);
            this.file.setAbsoluteRemotePath(context);
        }
        return this.file;
    }

    protected Object getRemoteObject(MyFile file, String[] backend, String[] vltBackend) throws RemoteBackendException {
        Object obj;
        block2: {
            obj = null;
            try {
                obj = this.retrieveRemoteObject(file, backend);
            }
            catch (RemoteBackendException e) {
                this.logger.warn("Object not found on persistent area. ");
                if (obj != null || vltBackend == null || vltBackend.length <= 0) break block2;
                this.logger.warn("trying on the volatile area");
                obj = this.retrieveRemoteObject(file, vltBackend);
                this.logger.info("object found in volatile area " + obj);
            }
        }
        return obj;
    }

    protected Object retrieveRemoteObject(MyFile file, String[] backend) throws RemoteBackendException {
        Object obj = null;
        if (file.getInputStream() != null || file.getOutputStream() != null || file.getLocalPath() != null || file.getRemotePath() != null) {
            obj = this.engine.service.startOperation(file, file.getRemotePath(), file.getOwner(), backend, false, file.getRootPath(), file.isReplace());
        } else {
            this.logger.error("parameters incompatible ");
        }
        return obj;
    }

    protected Object executeOperation(String path) {
        this.logger.info("file gCube parameter before: " + (Object)((Object)this.file.getGcubeAccessType()) + " " + this.file.getGcubeScope());
        this.file = this.setGenericProperties(this.engine.getContext(), this.engine.owner, path, "remote");
        this.file.setRemotePath(path);
        this.file.setOwner(this.engine.owner);
        this.setMyFile(this.file);
        this.engine.service.setResource(this.getMyFile());
        Object obj = this.getRemoteObject(this.getMyFile(), this.engine.primaryBackend, this.engine.volatileBackend);
        return obj;
    }
}

