/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.servlet.taglib.aui.ValidatorTag;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.ModelHintsUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.taglib.aui.FieldWrapperTag;
import com.liferay.taglib.aui.FormTag;
import com.liferay.taglib.aui.ValidatorTagImpl;
import com.liferay.taglib.aui.base.BaseInputTag;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class InputTag
extends BaseInputTag {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = true;
    private String _inputName;
    private Map<String, ValidatorTag> _validators;

    @Override
    public int doEndTag() throws JspException {
        this.updateFormValidators();
        return super.doEndTag();
    }

    @Override
    public int doStartTag() throws JspException {
        this.addModelValidatorTags();
        this.addRequiredValidatorTag();
        return super.doStartTag();
    }

    protected void addModelValidatorTags() {
        List modelValidators;
        Class model = this.getModel();
        if (model == null) {
            model = (Class)this.pageContext.getAttribute("aui:model-context:model");
        }
        if (model == null || Validator.isNotNull((String)this.getType())) {
            return;
        }
        String field = this.getField();
        if (Validator.isNull((String)field)) {
            field = this.getName();
        }
        if ((modelValidators = ModelHintsUtil.getValidators((String)model.getName(), (String)field)) == null) {
            return;
        }
        for (Tuple modelValidator : modelValidators) {
            String validatorName = (String)modelValidator.getObject(1);
            String validatorErrorMessage = (String)modelValidator.getObject(2);
            String validatorValue = (String)modelValidator.getObject(3);
            boolean customValidator = (Boolean)modelValidator.getObject(4);
            boolean customValidatorRequired = (Boolean)modelValidator.getObject(5);
            ValidatorTagImpl validatorTag = new ValidatorTagImpl(validatorName, validatorErrorMessage, validatorValue, customValidator, customValidatorRequired);
            this.addValidatorTag(validatorName, validatorTag);
        }
    }

    protected void addRequiredValidatorTag() {
        if (!this.getRequired()) {
            return;
        }
        ValidatorTagImpl validatorTag = new ValidatorTagImpl("required", null, null, false);
        this.addValidatorTag("required", validatorTag);
    }

    protected void addValidatorTag(String validatorName, ValidatorTag validatorTag) {
        if (this._validators == null) {
            this._validators = new HashMap<String, ValidatorTag>();
        }
        this._validators.put(validatorName, validatorTag);
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        this._validators = null;
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        String title;
        String label;
        FormTag formTag;
        String formName;
        String field;
        String name;
        int pos;
        String defaultLanguageId;
        Class model;
        super.setAttributes(request);
        Object bean = this.getBean();
        if (bean == null) {
            bean = this.pageContext.getAttribute("aui:model-context:bean");
        }
        if ((model = this.getModel()) == null) {
            model = (Class)this.pageContext.getAttribute("aui:model-context:model");
        }
        if (Validator.isNull((String)(defaultLanguageId = this.getDefaultLanguageId()))) {
            defaultLanguageId = (String)this.pageContext.getAttribute("aui:model-context:defaultLanguageId");
        }
        if (Validator.isNull((String)defaultLanguageId) && model != null && ModelHintsUtil.hasField((String)model.getName(), (String)"groupId")) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            defaultLanguageId = LocaleUtil.toLanguageId((Locale)themeDisplay.getSiteDefaultLocale());
        }
        if (Validator.isNull((String)defaultLanguageId)) {
            Locale defaultLocale = LocaleUtil.getDefault();
            defaultLanguageId = LocaleUtil.toLanguageId((Locale)defaultLocale);
        }
        if ((pos = (name = this.getName()).indexOf("--")) != -1) {
            name = name.substring(pos + 2, name.length() - 2);
        }
        if (Validator.isNull((String)(field = this.getField()))) {
            field = this.getName();
        }
        if ((formName = this.getFormName()) == null && (formTag = (FormTag)InputTag.findAncestorWithClass((Tag)this, FormTag.class)) != null) {
            formName = formTag.getName();
        }
        String id = this.getId();
        String type = this.getType();
        if (Validator.isNull((String)id)) {
            String fieldParam = this.getFieldParam();
            id = model != null && Validator.isNull((String)type) && Validator.isNotNull((String)fieldParam) ? fieldParam : (!Validator.equals((Object)type, (Object)"assetTags") && !Validator.equals((Object)type, (Object)"radio") ? name : StringUtil.randomId());
        }
        if ((label = this.getLabel()) == null) {
            label = TextFormatter.format((String)name, (int)15);
        }
        if ((title = this.getTitle()) == null && (Validator.isNull((String)label) || Validator.equals((Object)type, (Object)"image"))) {
            title = TextFormatter.format((String)name, (int)15);
        }
        String forLabel = id;
        if (Validator.equals((Object)type, (Object)"assetTags")) {
            forLabel = forLabel.concat("assetTagNames");
        } else if (Validator.equals((Object)type, (Object)"checkbox")) {
            forLabel = forLabel.concat("Checkbox");
        }
        this._inputName = this.getName();
        String languageId = this.getLanguageId();
        if (Validator.isNotNull((String)languageId)) {
            forLabel = String.valueOf(forLabel) + "_" + languageId;
        }
        String baseType = null;
        if (model != null && Validator.isNull((String)type)) {
            baseType = ModelHintsUtil.getType((String)model.getName(), (String)field);
            String fieldParam = this.getFieldParam();
            if (Validator.isNotNull((String)fieldParam)) {
                this._inputName = fieldParam;
            }
        } else if (Validator.isNotNull((String)type) && (Validator.equals((Object)type, (Object)"checkbox") || Validator.equals((Object)type, (Object)"radio") || Validator.equals((Object)type, (Object)"resource"))) {
            baseType = type;
        }
        if (Validator.isNull(baseType)) {
            baseType = "text";
        }
        boolean wrappedField = false;
        FieldWrapperTag fieldWrapper = (FieldWrapperTag)InputTag.findAncestorWithClass((Tag)this, FieldWrapperTag.class);
        if (fieldWrapper != null) {
            wrappedField = true;
        }
        this.setNamespacedAttribute(request, "baseType", baseType);
        this.setNamespacedAttribute(request, "bean", bean);
        this.setNamespacedAttribute(request, "defaultLanguageId", defaultLanguageId);
        this.setNamespacedAttribute(request, "field", field);
        this.setNamespacedAttribute(request, "forLabel", forLabel);
        this.setNamespacedAttribute(request, "formName", formName);
        this.setNamespacedAttribute(request, "id", id);
        this.setNamespacedAttribute(request, "label", label);
        this.setNamespacedAttribute(request, "model", model);
        this.setNamespacedAttribute(request, "title", String.valueOf(title));
        this.setNamespacedAttribute(request, "wrappedField", wrappedField);
        request.setAttribute(String.valueOf(this.getAttributeNamespace()) + "value", this.getValue());
        if (this._validators != null && this._validators.get("required") != null) {
            this.setNamespacedAttribute(request, "required", Boolean.TRUE.toString());
        }
    }

    protected void updateFormValidators() {
        if (this._validators == null) {
            return;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Map validatorTagsMap = (Map)request.getAttribute("aui:form:validatorTagsMap");
        if (validatorTagsMap != null) {
            String languageId;
            List validatorTags = ListUtil.fromMapValues(this._validators);
            String inputName = this._inputName;
            if (Validator.equals((Object)this.getType(), (Object)"checkbox")) {
                inputName = inputName.concat("Checkbox");
            }
            if (Validator.isNotNull((String)(languageId = this.getLanguageId()))) {
                inputName = String.valueOf(inputName) + "_" + languageId;
            }
            validatorTagsMap.put(inputName, validatorTags);
        }
    }
}

