/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextFactory;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.assetpublisher.util.AssetPublisherUtil;
import com.liferay.portlet.journal.DuplicateFolderNameException;
import com.liferay.portlet.journal.FolderNameException;
import com.liferay.portlet.journal.NoSuchFolderException;
import com.liferay.portlet.journal.action.ActionUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalFolder;
import com.liferay.portlet.journal.service.JournalFolderServiceUtil;
import com.liferay.portlet.trash.util.TrashUtil;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditFolderAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFolder(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFolders(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFolders(actionRequest, true);
            } else if (cmd.equals("restore")) {
                this.restoreFolderFromTrash(actionRequest);
            } else if (cmd.equals("move")) {
                this.moveFolder(actionRequest);
            }
            this.sendRedirect(actionRequest, actionResponse);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFolderException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.journal.error");
            }
            if (e2 instanceof DuplicateFolderNameException || e2 instanceof FolderNameException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getFolder((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchFolderException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.journal.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.journal.edit_folder"));
    }

    protected void deleteFolders(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        String deleteEntryTitle = null;
        long[] deleteFolderIds = null;
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        deleteFolderIds = folderId > 0L ? new long[]{folderId} : StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"folderIds"), (long)0L);
        int i2 = 0;
        while (i2 < deleteFolderIds.length) {
            long deleteFolderId = deleteFolderIds[i2];
            if (moveToTrash) {
                JournalFolder folder = JournalFolderServiceUtil.moveFolderToTrash((long)deleteFolderId);
                if (i2 == 0) {
                    deleteEntryTitle = TrashUtil.getOriginalTitle((String)folder.getName());
                }
            } else {
                JournalFolderServiceUtil.deleteFolder((long)deleteFolderId);
            }
            AssetPublisherUtil.removeRecentFolderId((PortletRequest)actionRequest, (String)JournalArticle.class.getName(), (long)deleteFolderId);
            ++i2;
        }
        if (moveToTrash && deleteFolderIds.length > 0) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            data.put("deleteEntryClassName", new String[]{JournalFolder.class.getName()});
            if (Validator.isNotNull((String)deleteEntryTitle)) {
                data.put("deleteEntryTitle", new String[]{deleteEntryTitle});
            }
            data.put("restoreFolderIds", ArrayUtil.toStringArray((long[])deleteFolderIds));
            SessionMessages.add((PortletRequest)actionRequest, (String)(String.valueOf(PortalUtil.getPortletId((PortletRequest)actionRequest)) + ".deleteSuccessData"), data);
            this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
        }
    }

    protected void moveFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFolder.class.getName(), (PortletRequest)actionRequest);
        JournalFolderServiceUtil.moveFolder((long)folderId, (long)parentFolderId, (ServiceContext)serviceContext);
    }

    protected void restoreFolderFromTrash(ActionRequest actionRequest) throws PortalException, SystemException {
        long[] restoreEntryIds;
        long[] lArray = restoreEntryIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"restoreFolderIds"), (long)0L);
        int n = restoreEntryIds.length;
        int n2 = 0;
        while (n2 < n) {
            long restoreEntryId = lArray[n2];
            JournalFolderServiceUtil.restoreFolderFromTrash((long)restoreEntryId);
            ++n2;
        }
    }

    protected void updateFolder(ActionRequest actionRequest) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long parentFolderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"parentFolderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        boolean mergeWithParentFolder = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)"mergeWithParentFolder");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)JournalFolder.class.getName(), (PortletRequest)actionRequest);
        if (folderId <= 0L) {
            JournalFolderServiceUtil.addFolder((long)serviceContext.getScopeGroupId(), (long)parentFolderId, (String)name, (String)description, (ServiceContext)serviceContext);
        } else {
            JournalFolderServiceUtil.updateFolder((long)folderId, (long)parentFolderId, (String)name, (String)description, (boolean)mergeWithParentFolder, (ServiceContext)serviceContext);
        }
    }
}

