/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.search;

import com.liferay.portal.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.dao.search.RowChecker;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.theme.PortletDisplay;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portlet.documentlibrary.NoSuchFileEntryException;
import com.liferay.portlet.documentlibrary.NoSuchFileShortcutException;
import com.liferay.portlet.documentlibrary.model.DLFileShortcut;
import com.liferay.portlet.documentlibrary.service.DLAppServiceUtil;
import com.liferay.portlet.documentlibrary.service.permission.DLFileEntryPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFileShortcutPermission;
import com.liferay.portlet.documentlibrary.service.permission.DLFolderPermission;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class EntriesChecker
extends RowChecker {
    private boolean _documentLibraryDisplayPortlet;
    private LiferayPortletResponse _liferayPortletResponse;
    private PermissionChecker _permissionChecker;

    public EntriesChecker(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        super((PortletResponse)liferayPortletResponse);
        this._liferayPortletResponse = liferayPortletResponse;
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = themeDisplay.getPermissionChecker();
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        String portletName = portletDisplay.getPortletName();
        if (portletName.equals("110")) {
            this._documentLibraryDisplayPortlet = true;
        }
    }

    public String getAllRowsCheckBox() {
        if (this._documentLibraryDisplayPortlet) {
            return this.getAllRowsCheckbox(null, this.getAllRowIds(), this.getEntryRowIds());
        }
        return null;
    }

    public String getAllRowsCheckBox(HttpServletRequest request) {
        if (this._documentLibraryDisplayPortlet) {
            return this.getAllRowsCheckbox(request, this.getAllRowIds(), this.getEntryRowIds());
        }
        return null;
    }

    public String getRowCheckBox(HttpServletRequest request, boolean checked, boolean disabled, String primaryKey) {
        Folder folder;
        FileEntry fileEntry;
        DLFileShortcut dlFileShortcut;
        block25: {
            dlFileShortcut = null;
            fileEntry = null;
            folder = null;
            long entryId = GetterUtil.getLong((String)primaryKey);
            try {
                fileEntry = DLAppServiceUtil.getFileEntry((long)entryId);
            }
            catch (Exception e1) {
                if (e1 instanceof NoSuchFileEntryException || e1 instanceof NoSuchRepositoryEntryException) {
                    try {
                        dlFileShortcut = DLAppServiceUtil.getFileShortcut((long)entryId);
                    }
                    catch (Exception e2) {
                        if (e2 instanceof NoSuchFileShortcutException) {
                            try {
                                folder = DLAppServiceUtil.getFolder((long)entryId);
                                break block25;
                            }
                            catch (Exception exception) {
                                return "";
                            }
                        }
                        return "";
                    }
                }
                return "";
            }
        }
        boolean showInput = false;
        String name = null;
        if (fileEntry != null) {
            name = FileEntry.class.getSimpleName();
            try {
                if (DLFileEntryPermission.contains(this._permissionChecker, fileEntry, "DELETE") || DLFileEntryPermission.contains(this._permissionChecker, fileEntry, "UPDATE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {}
        } else if (dlFileShortcut != null) {
            name = DLFileShortcut.class.getSimpleName();
            try {
                if (DLFileShortcutPermission.contains(this._permissionChecker, dlFileShortcut, "DELETE") || DLFileShortcutPermission.contains(this._permissionChecker, dlFileShortcut, "UPDATE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {}
        } else if (folder != null) {
            name = Folder.class.getSimpleName();
            try {
                if (DLFolderPermission.contains(this._permissionChecker, folder, "DELETE") || DLFolderPermission.contains(this._permissionChecker, folder, "UPDATE")) {
                    showInput = true;
                }
            }
            catch (Exception exception) {}
        }
        if (!showInput) {
            return "";
        }
        String checkBoxRowIds = this.getEntryRowIds();
        String checkBoxAllRowIds = "";
        String checkBoxPostOnClick = "";
        if (this._documentLibraryDisplayPortlet) {
            checkBoxAllRowIds = "'" + this.getAllRowIds() + "'";
        } else {
            checkBoxAllRowIds = "'#" + this.getAllRowIds() + "Checkbox'";
            checkBoxPostOnClick = String.valueOf(this._liferayPortletResponse.getNamespace()) + "toggleActionsButton();";
        }
        return this.getRowCheckBox(request, checked, disabled, String.valueOf(this._liferayPortletResponse.getNamespace()) + "rowIds" + name + "Checkbox", primaryKey, checkBoxRowIds, checkBoxAllRowIds, checkBoxPostOnClick);
    }

    protected String getEntryRowIds() {
        StringBundler sb = new StringBundler(13);
        sb.append("['");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(Folder.class.getSimpleName());
        sb.append("Checkbox', '");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(DLFileShortcut.class.getSimpleName());
        sb.append("Checkbox', '");
        sb.append(this._liferayPortletResponse.getNamespace());
        sb.append("rowIds");
        sb.append(FileEntry.class.getSimpleName());
        sb.append("Checkbox']");
        return sb.toString();
    }
}

