/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.watch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import jodd.io.FileUtil;
import jodd.io.watch.DirWatcherException;
import jodd.io.watch.DirWatcherListener;
import jodd.mutable.MutableLong;
import jodd.util.Wildcard;

public class DirWatcher {
    protected final File dir;
    protected HashMap<File, MutableLong> map = new HashMap();
    protected int filesCount;
    protected List<DirWatcherListener> listeners = new ArrayList<DirWatcherListener>();
    protected String[] patterns;
    protected boolean ignoreDotFiles = true;
    protected boolean startBlank = false;
    protected File watchFile;
    protected long watchFileLastAccessTime;
    protected Timer timer;

    public DirWatcher(String dir) {
        this(dir, null);
    }

    public DirWatcher(String dirName, String ... patterns) {
        this.dir = new File(dirName);
        if (!this.dir.exists() || !this.dir.isDirectory()) {
            throw new DirWatcherException("Invalid watch dir: " + dirName);
        }
        this.patterns = patterns;
    }

    protected void init() {
        File[] filesArray = this.dir.listFiles();
        this.filesCount = 0;
        if (filesArray != null) {
            this.filesCount = filesArray.length;
            for (File file : filesArray) {
                if (!this.acceptFile(file)) continue;
                this.map.put(file, new MutableLong(file.lastModified()));
            }
        }
    }

    public DirWatcher ignoreDotFiles(boolean ignoreDotFiles) {
        this.ignoreDotFiles = ignoreDotFiles;
        return this;
    }

    public DirWatcher startBlank(boolean startBlank) {
        this.startBlank = startBlank;
        return this;
    }

    public DirWatcher monitor(String ... patterns) {
        this.patterns = patterns;
        return this;
    }

    protected boolean acceptFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        String fileName = file.getName();
        if (this.ignoreDotFiles && fileName.startsWith(".")) {
            return false;
        }
        if (this.patterns == null) {
            return true;
        }
        return Wildcard.matchOne(fileName, this.patterns) != -1;
    }

    public DirWatcher useWatchFile() {
        return this.useWatchFile(".watch.ready");
    }

    public DirWatcher useWatchFile(String name) {
        this.watchFile = new File(this.dir, name);
        if (!this.watchFile.isFile() || !this.watchFile.exists()) {
            try {
                FileUtil.touch(this.watchFile);
            }
            catch (IOException ioex) {
                throw new DirWatcherException("Invalid watch file: " + name, ioex);
            }
        }
        this.watchFileLastAccessTime = this.watchFile.lastModified();
        return this;
    }

    public void start(long pollingInterval) {
        if (this.timer == null) {
            if (!this.startBlank) {
                this.init();
            }
            this.timer = new Timer(true);
            this.timer.schedule((TimerTask)new WatchTask(), 0L, pollingInterval);
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    protected void onChange(File file, Event event) {
        for (DirWatcherListener listener : this.listeners) {
            listener.onChange(file, event);
        }
    }

    public void register(DirWatcherListener dirWatcherListener) {
        if (!this.listeners.contains(dirWatcherListener)) {
            this.listeners.add(dirWatcherListener);
        }
    }

    public void remove(DirWatcherListener dirWatcherListener) {
        this.listeners.remove(dirWatcherListener);
    }

    public class WatchTask
    extends TimerTask {
        protected boolean running;

        public final void run() {
            File[] filesArray;
            if (this.running) {
                return;
            }
            this.running = true;
            if (DirWatcher.this.watchFile != null) {
                long last = DirWatcher.this.watchFile.lastModified();
                if (last <= DirWatcher.this.watchFileLastAccessTime) {
                    this.running = false;
                    return;
                }
                DirWatcher.this.watchFileLastAccessTime = last;
            }
            if ((filesArray = DirWatcher.this.dir.listFiles()) == null) {
                this.running = false;
                return;
            }
            HashSet<File> deletedFiles = null;
            if (filesArray.length < DirWatcher.this.filesCount) {
                deletedFiles = new HashSet<File>(DirWatcher.this.map.keySet());
            }
            DirWatcher.this.filesCount = filesArray.length;
            for (File file : filesArray) {
                if (!DirWatcher.this.acceptFile(file)) continue;
                MutableLong currentTime = DirWatcher.this.map.get(file);
                if (deletedFiles != null) {
                    deletedFiles.remove(file);
                }
                long lastModified = file.lastModified();
                if (currentTime == null) {
                    DirWatcher.this.map.put(file, new MutableLong(lastModified));
                    DirWatcher.this.onChange(file, Event.CREATED);
                    continue;
                }
                if (currentTime.longValue() == lastModified) continue;
                currentTime.setValue(lastModified);
                DirWatcher.this.onChange(file, Event.MODIFIED);
            }
            if (deletedFiles != null) {
                for (File deletedFile : deletedFiles) {
                    DirWatcher.this.map.remove(deletedFile);
                    DirWatcher.this.onChange(deletedFile, Event.DELETED);
                }
            }
            this.running = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Event {
        CREATED,
        DELETED,
        MODIFIED;

    }
}

