/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;

public class PropertyComparator
implements Comparator<Object> {
    private static Log _log = LogFactoryUtil.getLog(PropertyComparator.class);
    private boolean _ascending;
    private boolean _caseSensitive;
    private String[] _propertyNames;

    public PropertyComparator(String propertyName) {
        this(new String[]{propertyName}, true, false);
    }

    public PropertyComparator(String propertyName, boolean ascending, boolean caseSensitive) {
        this(new String[]{propertyName}, ascending, caseSensitive);
    }

    public PropertyComparator(String[] propertyNames) {
        this(propertyNames, true, false);
    }

    public PropertyComparator(String[] propertyNames, boolean ascending, boolean caseSensitive) {
        this._propertyNames = propertyNames;
        this._ascending = ascending;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public int compare(Object obj1, Object obj2) {
        try {
            String[] stringArray = this._propertyNames;
            int n = this._propertyNames.length;
            int n2 = 0;
            while (n2 < n) {
                int value;
                String propertyName = stringArray[n2];
                Object property1 = PropertyUtils.getProperty((Object)obj1, (String)propertyName);
                Object property2 = PropertyUtils.getProperty((Object)obj2, (String)propertyName);
                if (!this._ascending) {
                    Object temp = property1;
                    property1 = property2;
                    property2 = temp;
                }
                if (property1 instanceof String) {
                    int value2 = 0;
                    value2 = this._caseSensitive ? property1.toString().compareTo(property2.toString()) : property1.toString().compareToIgnoreCase(property2.toString());
                    if (value2 != 0) {
                        return value2;
                    }
                }
                if (property1 instanceof Comparable && (value = ((Comparable)property1).compareTo(property2)) != 0) {
                    return value;
                }
                ++n2;
            }
        }
        catch (IllegalAccessException iae) {
            _log.error((Object)iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            _log.error((Object)ite.getMessage());
        }
        catch (NoSuchMethodException nsme) {
            _log.error((Object)nsme.getMessage());
        }
        return -1;
    }
}

