/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib.Tool;

import JOscarLib.Core.OscarConnection;
import JOscarLib.Management.ContactList;
import JOscarLib.Packet.Sent.AddToContactList;
import JOscarLib.Packet.Sent.Icq.ClientMeta;
import JOscarLib.Packet.Sent.Icq.SendType2Message;
import JOscarLib.Packet.Sent.Icq.SetICQStatus;
import JOscarLib.Packet.Sent.SetIdleTime;
import JOscarLib.Setting.Enum.IdleTimeEnum;
import JOscarLib.Setting.Enum.StatusModeEnum;

public class OscarInterface {
    public static void sendMessage(OscarConnection connection, String userId, String message) {
        connection.sendFlap(new SendType2Message(userId, message));
    }

    public static void sendSMS(OscarConnection connection, String phoneNumber, String message) {
        connection.sendFlap(ClientMeta.sendSMS(connection, phoneNumber, message));
    }

    public static void changeStatus(OscarConnection connection, StatusModeEnum newStatus) {
        connection.sendFlap(new SetICQStatus(newStatus, connection.getTweaker().getInitialStatusFlags(), connection.getTweaker().getTcpConnectionFlag(), connection.getClient().getInetaddress(), connection.getTweaker().getP2PPortListening()));
    }

    public static void addUsers(OscarConnection connection, ContactList contactList) {
        connection.sendFlap(new AddToContactList(contactList.getContactIds()));
    }

    public static void addUser(OscarConnection connection, String contactId) {
        String[] array = new String[]{contactId};
        connection.sendFlap(new AddToContactList(array));
    }

    public static void setIdleTime(OscarConnection connection, IdleTimeEnum idleTimeMode) {
        connection.sendFlap(new SetIdleTime(idleTimeMode));
    }

    public static void requestOfflineMessages(OscarConnection connection) {
        connection.sendFlap(ClientMeta.requestOfflineMessages(connection));
    }
}

