/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.model;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.WikiMessage;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.WikiUser;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogItem {
    private static final WikiLogger logger = WikiLogger.getLogger(LogItem.class.getName());
    public static final int LOG_TYPE_ALL = -1;
    public static final int LOG_TYPE_DELETE = 1;
    public static final int LOG_TYPE_IMPORT = 2;
    public static final int LOG_TYPE_MOVE = 3;
    public static final int LOG_TYPE_PERMISSION = 4;
    public static final int LOG_TYPE_UPLOAD = 6;
    public static final int LOG_TYPE_USER_CREATION = 7;
    public static Map<Integer, String> LOG_TYPES = new LinkedHashMap<Integer, String>();
    private String logComment = null;
    private Timestamp logDate = null;
    private List<String> logParams = null;
    private int logType = -1;
    private Integer topicId = null;
    private Integer topicVersionId = null;
    private String userDisplayName = null;
    private Integer userId = null;
    private String virtualWiki = null;

    public static LogItem initLogItem(Topic topic, TopicVersion topicVersion, String authorName) {
        LogItem logItem = new LogItem();
        if (!topicVersion.isLoggable() || !topicVersion.isRecentChangeAllowed()) {
            return null;
        }
        logItem.setLogParams(topicVersion.getVersionParams());
        switch (topicVersion.getEditType()) {
            case 5: {
                logItem.setLogType(1);
                break;
            }
            case 7: {
                logItem.setLogType(1);
                logItem.addLogParam(Integer.toString(7));
                break;
            }
            case 4: {
                if (StringUtils.isBlank((String)topic.getRedirectTo())) {
                    return null;
                }
                logItem.setLogType(3);
                break;
            }
            case 6: {
                logItem.setLogType(4);
                break;
            }
            case 8: {
                if (topic.getCurrentVersionId().intValue() != topicVersion.getTopicVersionId()) {
                    return null;
                }
                logItem.setLogType(2);
                break;
            }
            case 9: {
                logItem.setLogType(6);
                break;
            }
            default: {
                return null;
            }
        }
        logItem.setLogComment(topicVersion.getEditComment());
        logItem.setLogDate(topicVersion.getEditDate());
        logItem.setTopicId(topic.getTopicId());
        logItem.setTopicVersionId(topicVersion.getTopicVersionId());
        logItem.setUserDisplayName(authorName);
        logItem.setUserId(topicVersion.getAuthorId());
        logItem.setVirtualWiki(topic.getVirtualWiki());
        return logItem;
    }

    public static LogItem initLogItem(WikiUser wikiUser, String virtualWiki) {
        LogItem logItem = new LogItem();
        logItem.setLogType(7);
        logItem.setLogDate(wikiUser.getCreateDate());
        logItem.setUserDisplayName(wikiUser.getUsername());
        logItem.setUserId(wikiUser.getUserId());
        logItem.setVirtualWiki(virtualWiki);
        return logItem;
    }

    public static WikiMessage retrieveLogWikiMessage(int logType, String logParamString) {
        String[] logParams = null;
        if (!StringUtils.isBlank((String)logParamString)) {
            logParams = logParamString.split("\\|");
        }
        WikiMessage logWikiMessage = null;
        if (logType == 1) {
            logWikiMessage = logParams != null && logParams.length >= 2 && StringUtils.equals((String)logParams[1], (String)Integer.toString(7)) ? new WikiMessage("log.message.undeletion", logParams) : new WikiMessage("log.message.deletion", logParams);
        } else if (logType == 2) {
            logWikiMessage = new WikiMessage("log.message.import", logParams);
        } else if (logType == 3) {
            logWikiMessage = new WikiMessage("log.message.move", logParams);
        } else if (logType == 4) {
            logWikiMessage = new WikiMessage("log.message.permission", logParams);
        } else if (logType == 6) {
            logWikiMessage = new WikiMessage("log.message.upload", logParams);
        } else if (logType == 7) {
            logWikiMessage = new WikiMessage("log.message.user");
        }
        return logWikiMessage;
    }

    public String getLogComment() {
        return this.logComment;
    }

    public void setLogComment(String logComment) {
        this.logComment = logComment;
    }

    public Timestamp getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Timestamp logDate) {
        this.logDate = logDate;
    }

    private void addLogParam(String param) {
        if (this.logParams == null) {
            this.logParams = new ArrayList<String>();
        }
        this.logParams.add(param);
    }

    public List<String> getLogParams() {
        return this.logParams;
    }

    public void setLogParams(List<String> logParams) {
        this.logParams = logParams;
    }

    public String getLogParamString() {
        return Utilities.listToDelimitedString(this.logParams, "|");
    }

    public void setLogParamString(String logParamsString) {
        this.setLogParams(Utilities.delimitedStringToList(logParamsString, "|"));
    }

    public int getLogType() {
        return this.logType;
    }

    public void setLogType(int logType) {
        this.logType = logType;
    }

    public String getLogWikiLinkCaption() {
        return LOG_TYPES.get(this.logType);
    }

    public WikiMessage getLogWikiMessage() {
        return LogItem.retrieveLogWikiMessage(this.getLogType(), this.getLogParamString());
    }

    public Integer getTopicId() {
        return this.topicId;
    }

    public void setTopicId(Integer topicId) {
        this.topicId = topicId;
    }

    public Integer getTopicVersionId() {
        return this.topicVersionId;
    }

    public void setTopicVersionId(Integer topicVersionId) {
        this.topicVersionId = topicVersionId;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getVirtualWiki() {
        return this.virtualWiki;
    }

    public void setVirtualWiki(String virtualWiki) {
        this.virtualWiki = virtualWiki;
    }

    public boolean isDelete() {
        return this.logType == 1;
    }

    public boolean isImportLog() {
        return this.logType == 2;
    }

    public boolean isMove() {
        return this.logType == 3;
    }

    public boolean isPermission() {
        return this.logType == 4;
    }

    public boolean isUpload() {
        return this.logType == 6;
    }

    public boolean isUser() {
        return this.logType == 7;
    }

    static {
        LOG_TYPES.put(-1, "log.caption.log.all");
        LOG_TYPES.put(1, "log.caption.log.deletion");
        LOG_TYPES.put(2, "log.caption.log.import");
        LOG_TYPES.put(3, "log.caption.log.move");
        LOG_TYPES.put(4, "log.caption.log.permission");
        LOG_TYPES.put(6, "log.caption.log.upload");
        LOG_TYPES.put(7, "log.caption.log.user");
    }
}

