/*
 * Decompiled with CFR 0.152.
 */
package JOscarLib;

import JOscarLib.DataField;
import JOscarLib.Exceptions.RawDataBadForcedLenghtException;

public class RawData
extends DataField {
    public static final int BYTE_LENGHT = 1;
    public static final int WORD_LENGHT = 2;
    public static final int DWORD_LENGHT = 4;
    private int value;
    private int forcedLenght = 0;
    private String stringValue = null;
    private boolean reversed = false;

    public RawData(int value, int forcedLenght) {
        this.value = value;
        this.forcedLenght = forcedLenght;
        long maxValue = 0L;
        for (int i = 0; i < forcedLenght; ++i) {
            maxValue = maxValue << 8 | 0xFFL;
        }
        if ((long)value > maxValue) {
            throw new RawDataBadForcedLenghtException(value + " cannot fit in " + forcedLenght + " Byte(s).");
        }
        this.insert(value, forcedLenght);
    }

    public RawData(int value) {
        this.value = value;
        long maxValue = 255L;
        int i = 1;
        while (maxValue < (long)value) {
            maxValue = maxValue << 8 | 0xFFL;
            ++i;
        }
        this.insert(value, i);
    }

    public RawData(String string) {
        this.stringValue = string;
        this.insertString(string);
    }

    public RawData(byte[] array) {
        this.byteArray = array;
        this.value = RawData.getByte(array);
        this.stringValue = new String(this.byteArray);
    }

    public RawData(byte[] value, int start, int len) {
        byte[] tmp = new byte[len];
        System.arraycopy(value, start, tmp, 0, len);
        this.byteArray = tmp;
        this.value = RawData.getByte(tmp);
        this.stringValue = new String(tmp);
    }

    private static int getByte(byte[] array) {
        int result = 0;
        for (int i = 0; i < array.length; ++i) {
            long shift = (array.length - (i + 1)) * 8;
            long mask = 255 << (int)shift;
            result = (int)((long)result | (long)(array[i] << (int)shift) & mask);
        }
        return result;
    }

    private void insert(int value, int len) {
        this.byteArray = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.byteArray[i] = (byte)(value >> (len - 1 - i) * 8 & 0xFF);
        }
    }

    private void insertString(String string) {
        this.byteArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            this.byteArray[i] = (byte)string.charAt(i);
        }
    }

    public void invertIndianness() {
        byte[] tmp = new byte[this.byteArray.length];
        for (int i = 0; i < this.byteArray.length; ++i) {
            tmp[i] = this.byteArray[this.byteArray.length - 1 - i];
        }
        this.byteArray = tmp;
        this.reversed = true;
    }

    public int getValue() {
        if (this.reversed) {
            this.value = 0;
            for (int i = 0; i < this.byteArray.length; ++i) {
                this.value = (int)((long)this.value | (long)(this.byteArray[i] << (this.byteArray.length - 1 - i) * 8) & 255L << (this.byteArray.length - 1 - i) * 8);
            }
            this.reversed = false;
        }
        return this.value;
    }

    public int getForcedLenght() {
        return this.forcedLenght;
    }

    public String getStringValue() {
        if (this.stringValue == null || this.reversed) {
            this.stringValue = new String(this.byteArray);
        }
        this.reversed = false;
        return this.stringValue;
    }

    public byte[] getByteArray() {
        return this.byteArray;
    }
}

