/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.lang;

import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.kernel.security.pacl.permission.PortalServicePermission;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.lang.DoPrivilegedBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DoPrivilegedHandler
implements DoPrivilegedBean,
InvocationHandler {
    private static final String _BEAN_NAME_SUFFIX_FINDER = "Finder";
    private static final String _BEAN_NAME_SUFFIX_PERSISTENCE = "Persistence";
    private Object _bean;
    private boolean _hasNotPrivilegedMethods = false;
    private List<MethodKey> _notPrivilegedMethods;

    public DoPrivilegedHandler(Object bean) {
        this._bean = bean;
        this._initNotPrivilegedMethods();
    }

    @Override
    public Object getActualBean() {
        return this._bean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        try {
            return this.doInvoke(proxy, method, arguments);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected Object doInvoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        Class<?> methodDeclaringClass = method.getDeclaringClass();
        String methodName = method.getName();
        if (methodDeclaringClass.equals(DoPrivilegedBean.class) && methodName.equals("getActualBean")) {
            return this._bean;
        }
        if (methodDeclaringClass.equals(Object.class) && methodName.equals("equals")) {
            Object object = arguments[0];
            if (object instanceof DoPrivilegedBean) {
                DoPrivilegedBean doPrivilegedBean = (DoPrivilegedBean)object;
                object = doPrivilegedBean.getActualBean();
            }
            return this._bean.equals(object);
        }
        if (this._isNotPrivileged(method)) {
            return method.invoke(this._bean, arguments);
        }
        String declaringClassName = methodDeclaringClass.getName();
        if (declaringClassName.endsWith(_BEAN_NAME_SUFFIX_FINDER) || declaringClassName.endsWith(_BEAN_NAME_SUFFIX_PERSISTENCE)) {
            PortalServicePermission.checkService((Object)this._bean, (Method)method, (Object[])arguments);
        }
        try {
            return AccessController.doPrivileged(new InvokePrivilegedExceptionAction(this._bean, method, arguments));
        }
        catch (PrivilegedActionException pae) {
            Exception e2 = pae.getException();
            throw e2.getCause();
        }
    }

    private void _initNotPrivilegedMethods() {
        Method[] methods;
        this._notPrivilegedMethods = new ArrayList<MethodKey>();
        Class<?> beanClass = this._bean.getClass();
        Method[] methodArray = methods = beanClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            NotPrivileged notPrivileged = method.getAnnotation(NotPrivileged.class);
            if (notPrivileged != null) {
                this._notPrivilegedMethods.add(new MethodKey(method));
            }
            ++n2;
        }
        this._notPrivilegedMethods = Collections.unmodifiableList(this._notPrivilegedMethods);
        if (!this._notPrivilegedMethods.isEmpty()) {
            this._hasNotPrivilegedMethods = true;
        }
    }

    private boolean _isNotPrivileged(Method method) {
        return this._hasNotPrivilegedMethods && this._notPrivilegedMethods.contains(new MethodKey(method));
    }

    private class InvokePrivilegedExceptionAction
    implements PrivilegedExceptionAction<Object> {
        private Object[] _arguments;
        private Object _bean;
        private Method _method;

        public InvokePrivilegedExceptionAction(Object bean, Method method, Object[] arguments) {
            this._bean = bean;
            this._method = method;
            this._arguments = arguments;
        }

        @Override
        public Object run() throws Exception {
            return this._method.invoke(this._bean, this._arguments);
        }
    }

    private class MethodKey {
        private Class<?> _declaringClass;
        private String _methodName;
        private Class<?>[] _parameterTypes;

        public MethodKey(Method method) {
            this._declaringClass = method.getDeclaringClass();
            this._methodName = method.getName();
            this._parameterTypes = method.getParameterTypes();
        }

        public boolean equals(Object obj) {
            MethodKey methodKey = (MethodKey)obj;
            return this._declaringClass.isAssignableFrom(methodKey._declaringClass) && Validator.equals((Object)this._methodName, (Object)methodKey._methodName) && Arrays.equals(this._parameterTypes, methodKey._parameterTypes);
        }
    }
}

