/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.util;

import java.io.Serializable;
import rath.msnm.util.Stringator;

public class StringList
implements Serializable,
Cloneable {
    private String[] strings = null;
    private int elementCount;

    public StringList() {
        this.strings = new String[4];
    }

    public StringList(int capacity) {
        this.strings = new String[capacity];
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.strings.length;
        if (minCapacity > oldCapacity) {
            String[] oldData = this.strings;
            int newCapacity = oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.strings = new String[newCapacity];
            System.arraycopy(oldData, 0, this.strings, 0, this.elementCount + 1 - 1);
        }
    }

    public int size() {
        return this.elementCount;
    }

    public String get(int index) {
        return this.strings[index];
    }

    public int getInteger(int index) {
        return Integer.parseInt(this.strings[index]);
    }

    public boolean getBoolean(int index) {
        return Boolean.valueOf(this.strings[index]);
    }

    public void remove(int index) {
        this.strings[index] = null;
    }

    public void setAt(int index, String str) {
        this.strings[index] = str;
    }

    public void add(String str) {
        this.ensureCapacity(this.elementCount + 1);
        this.strings[this.elementCount++] = str;
    }

    public void add(Object o) {
        this.add(String.valueOf(o));
    }

    public void removeAll() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.strings[i] = null;
        }
        this.elementCount = 0;
    }

    public String[] toArray() {
        String[] str = new String[this.elementCount];
        System.arraycopy(this.strings, 0, str, 0, this.elementCount);
        return str;
    }

    public Stringator iterator() {
        return new Stringator(){
            private int offset = 0;

            public boolean hasNext() {
                return this.offset < StringList.this.elementCount;
            }

            public String next() {
                return StringList.this.strings[this.offset++];
            }

            public void remove() {
                ((StringList)StringList.this).strings[this.offset] = null;
            }
        };
    }

    public synchronized Object clone() {
        try {
            StringList v = (StringList)super.clone();
            v.strings = new String[this.elementCount];
            System.arraycopy(this.strings, 0, v.strings, 0, this.elementCount);
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.elementCount; ++i) {
            sb.append(this.strings[i]);
            if (i + 1 == this.elementCount) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

