/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.portal.kernel.template.TemplateVariableCodeHandler;
import com.liferay.portal.kernel.template.TemplateVariableDefinition;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.UniqueList;
import java.util.Collection;

public class TemplateVariableGroup {
    private boolean _autocompleteEnabled = true;
    private String _label;
    private String[] _restrictedVariables;
    private Collection<TemplateVariableDefinition> _templateVariableDefinitions = new UniqueList<TemplateVariableDefinition>();

    public TemplateVariableGroup(String label) {
        this._label = label;
    }

    public TemplateVariableGroup(String label, String[] restrictedVariables) {
        this(label);
        this._restrictedVariables = restrictedVariables;
    }

    public TemplateVariableDefinition addCollectionVariable(String collectionLabel, Class<?> collectionClazz, String collectionName, String itemLabel, Class<?> itemClazz, String itemName, String itemAccessor) {
        if (this.isRestrictedVariable(collectionName)) {
            return null;
        }
        TemplateVariableDefinition itemTemplateVariableDefinition = new TemplateVariableDefinition(itemLabel, itemClazz, itemName, itemAccessor);
        TemplateVariableDefinition collectionTemplateVariableDefinition = new TemplateVariableDefinition(collectionLabel, collectionClazz, collectionName, itemTemplateVariableDefinition);
        this._templateVariableDefinitions.add(collectionTemplateVariableDefinition);
        return collectionTemplateVariableDefinition;
    }

    public TemplateVariableDefinition addFieldVariable(String label, Class<?> clazz, String variableName, String help, String dataType, boolean repeatable, TemplateVariableCodeHandler templateVariableCodeHandler) {
        if (this.isRestrictedVariable(variableName)) {
            return null;
        }
        TemplateVariableDefinition templateVariableDefinition = new TemplateVariableDefinition(label, clazz, dataType, variableName, null, help, repeatable, templateVariableCodeHandler);
        this._templateVariableDefinitions.add(templateVariableDefinition);
        return templateVariableDefinition;
    }

    public void addServiceLocatorVariables(Class<?> ... serviceClasses) {
        if (this.isRestrictedVariable("serviceLocator")) {
            return;
        }
        Class<?>[] classArray = serviceClasses;
        int n = serviceClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> serviceClass = classArray[n2];
            String label = TextFormatter.format(serviceClass.getSimpleName(), 8);
            label = TextFormatter.format(label, 10);
            TemplateVariableDefinition templateVariableDefinition = new TemplateVariableDefinition(label, serviceClass, "service-locator", serviceClass.getCanonicalName(), null, String.valueOf(label) + "-help", false, null);
            this._templateVariableDefinitions.add(templateVariableDefinition);
            ++n2;
        }
    }

    public TemplateVariableDefinition addVariable(String label, Class<?> clazz, String name) {
        return this.addVariable(label, clazz, name, null);
    }

    public TemplateVariableDefinition addVariable(String label, Class<?> clazz, String name, String accessor) {
        if (this.isRestrictedVariable(name)) {
            return null;
        }
        TemplateVariableDefinition templateVariableDefinition = new TemplateVariableDefinition(label, clazz, name, accessor);
        this._templateVariableDefinitions.add(templateVariableDefinition);
        return templateVariableDefinition;
    }

    public void empty() {
        this._templateVariableDefinitions.clear();
    }

    public String getLabel() {
        return this._label;
    }

    public Collection<TemplateVariableDefinition> getTemplateVariableDefinitions() {
        return this._templateVariableDefinitions;
    }

    public boolean isAutocompleteEnabled() {
        return this._autocompleteEnabled;
    }

    public boolean isEmpty() {
        return this._templateVariableDefinitions.isEmpty();
    }

    public void setAutocompleteEnabled(boolean autocompleteEnabled) {
        this._autocompleteEnabled = autocompleteEnabled;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    protected boolean isRestrictedVariable(String variableName) {
        return ArrayUtil.contains(this._restrictedVariables, variableName);
    }
}

