/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.values;

import com.google.ical.values.AbstractIcalObject;
import com.google.ical.values.DateValue;
import com.google.ical.values.Frequency;
import com.google.ical.values.RRuleSchema;
import com.google.ical.values.TimeValue;
import com.google.ical.values.VcalRewriter;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RRule
extends AbstractIcalObject {
    private Frequency freq;
    private Weekday wkst;
    private DateValue until;
    private int count;
    private int interval;
    private List<WeekdayNum> byDay = new ArrayList<WeekdayNum>();
    private int[] byMonth = NO_INTS;
    private int[] byMonthDay = NO_INTS;
    private int[] byWeekNo = NO_INTS;
    private int[] byYearDay = NO_INTS;
    private int[] byHour = NO_INTS;
    private int[] byMinute = NO_INTS;
    private int[] bySecond = NO_INTS;
    private int[] bySetPos = NO_INTS;
    private static final int[] NO_INTS = new int[0];

    public RRule() {
        this.freq = Frequency.DAILY;
        this.setName("RRULE");
    }

    public RRule(String icalString) throws ParseException {
        this.parse(VcalRewriter.rewriteRule(icalString), RRuleSchema.instance());
    }

    @Override
    public String toIcal() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        if (this.hasExtParams()) {
            for (Map.Entry param : this.getExtParams().entrySet()) {
                String k = (String)param.getKey();
                String v = (String)param.getValue();
                if (ICAL_SPECIALS.matcher(v).find()) {
                    v = "\"" + v + "\"";
                }
                buf.append(';').append(k).append('=').append(v);
            }
        }
        buf.append(":FREQ=").append((Object)this.freq);
        if (this.wkst != null) {
            buf.append(";WKST=").append(this.wkst.toString());
        }
        if (this.until != null) {
            buf.append(";UNTIL=").append(this.until);
            if (this.until instanceof TimeValue) {
                buf.append('Z');
            }
        }
        if (this.count != 0) {
            buf.append(";COUNT=").append(this.count);
        }
        if (this.interval != 0) {
            buf.append(";INTERVAL=").append(this.interval);
        }
        if (this.byYearDay.length != 0) {
            buf.append(";BYYEARDAY=");
            RRule.writeIntList(this.byYearDay, buf);
        }
        if (this.byMonth.length != 0) {
            buf.append(";BYMONTH=");
            RRule.writeIntList(this.byMonth, buf);
        }
        if (this.byMonthDay.length != 0) {
            buf.append(";BYMONTHDAY=");
            RRule.writeIntList(this.byMonthDay, buf);
        }
        if (this.byWeekNo.length != 0) {
            buf.append(";BYWEEKNO=");
            RRule.writeIntList(this.byWeekNo, buf);
        }
        if (!this.byDay.isEmpty()) {
            buf.append(";BYDAY=");
            boolean first = true;
            for (WeekdayNum day : this.byDay) {
                if (!first) {
                    buf.append(',');
                } else {
                    first = false;
                }
                buf.append(day);
            }
        }
        if (this.byHour.length != 0) {
            buf.append(";BYHOUR=");
            RRule.writeIntList(this.byHour, buf);
        }
        if (this.byMinute.length != 0) {
            buf.append(";BYMINUTE=");
            RRule.writeIntList(this.byMinute, buf);
        }
        if (this.bySecond.length != 0) {
            buf.append(";BYSECOND=");
            RRule.writeIntList(this.bySecond, buf);
        }
        if (this.bySetPos.length != 0) {
            buf.append(";BYSETPOS=");
            RRule.writeIntList(this.bySetPos, buf);
        }
        return buf.toString();
    }

    private static void writeIntList(int[] nums, StringBuilder out) {
        int i = 0;
        while (i < nums.length) {
            if (i != 0) {
                out.append(',');
            }
            out.append(nums[i]);
            ++i;
        }
    }

    public int approximateIntervalInDays() {
        int freqLengthDays;
        int nPerPeriod = 0;
        switch (this.freq) {
            case DAILY: {
                freqLengthDays = 1;
                break;
            }
            case WEEKLY: {
                freqLengthDays = 7;
                if (this.byDay.isEmpty()) break;
                nPerPeriod = this.byDay.size();
                break;
            }
            case MONTHLY: {
                freqLengthDays = 30;
                if (!this.byDay.isEmpty()) {
                    for (WeekdayNum day : this.byDay) {
                        nPerPeriod += day.num != 0 ? 1 : 4;
                    }
                    break;
                }
                nPerPeriod = this.byMonthDay.length;
                break;
            }
            case YEARLY: {
                freqLengthDays = 365;
                int monthCount = 12;
                if (this.byMonth.length != 0) {
                    monthCount = this.byMonth.length;
                }
                if (!this.byDay.isEmpty()) {
                    for (WeekdayNum day : this.byDay) {
                        nPerPeriod += (day.num != 0 ? 1 : 4) * monthCount;
                    }
                    break;
                }
                if (this.byMonthDay.length != 0) {
                    nPerPeriod += monthCount * this.byMonthDay.length;
                    break;
                }
                nPerPeriod += this.byYearDay.length;
                break;
            }
            default: {
                freqLengthDays = 0;
            }
        }
        if (nPerPeriod == 0) {
            nPerPeriod = 1;
        }
        return freqLengthDays / nPerPeriod * this.interval;
    }

    public Frequency getFreq() {
        return this.freq;
    }

    public void setFreq(Frequency freq) {
        this.freq = freq;
    }

    public Weekday getWkSt() {
        return this.wkst;
    }

    public void setWkSt(Weekday wkst) {
        this.wkst = wkst;
    }

    public DateValue getUntil() {
        return this.until;
    }

    public void setUntil(DateValue until) {
        this.until = until;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public List<WeekdayNum> getByDay() {
        return this.byDay;
    }

    public void setByDay(List<WeekdayNum> byDay) {
        this.byDay = new ArrayList<WeekdayNum>(byDay);
    }

    public int[] getByMonth() {
        return this.byMonth;
    }

    public void setByMonth(int[] byMonth) {
        this.byMonth = (int[])byMonth.clone();
    }

    public int[] getByMonthDay() {
        return this.byMonthDay;
    }

    public void setByMonthDay(int[] byMonthDay) {
        this.byMonthDay = (int[])byMonthDay.clone();
    }

    public int[] getByWeekNo() {
        return this.byWeekNo;
    }

    public void setByWeekNo(int[] byWeekNo) {
        this.byWeekNo = (int[])byWeekNo.clone();
    }

    public int[] getByYearDay() {
        return this.byYearDay;
    }

    public void setByYearDay(int[] byYearDay) {
        this.byYearDay = (int[])byYearDay.clone();
    }

    public int[] getBySetPos() {
        return this.bySetPos;
    }

    public void setBySetPos(int[] bySetPos) {
        this.bySetPos = (int[])bySetPos.clone();
    }

    public int[] getByHour() {
        return this.byHour;
    }

    public void setByHour(int[] byHour) {
        this.byHour = (int[])byHour.clone();
    }

    public int[] getByMinute() {
        return this.byMinute;
    }

    public void setByMinute(int[] byMinute) {
        this.byMinute = (int[])byMinute.clone();
    }

    public int[] getBySecond() {
        return this.bySecond;
    }

    public void setBySecond(int[] bySecond) {
        this.bySecond = (int[])bySecond.clone();
    }
}

