/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.model.Interwiki;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.parser.ParserException;
import org.jamwiki.utils.ImageUtil;
import org.jamwiki.utils.PseudoTopicHandler;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLink;
import org.jamwiki.utils.WikiLogger;

public class LinkUtil {
    private static final WikiLogger logger = WikiLogger.getLogger(LinkUtil.class.getName());

    private LinkUtil() {
    }

    public static String appendQueryParam(String query, String param, String value) {
        String url = "";
        if (!StringUtils.isBlank((String)query)) {
            if (query.charAt(0) != '?') {
                query = "?" + query;
            }
            url = query + "&amp;";
        } else {
            url = "?";
        }
        if (StringUtils.isBlank((String)param)) {
            return query;
        }
        url = url + Utilities.encodeAndEscapeTopicName(param) + "=";
        if (!StringUtils.isBlank((String)value)) {
            url = url + Utilities.encodeAndEscapeTopicName(value);
        }
        return url;
    }

    public static String buildAnchorText(String text) {
        String anchorText = Utilities.encodeAndEscapeTopicName(text);
        if (!(anchorText = anchorText.replace('%', '.')).matches("[A-Za-z].*")) {
            anchorText = "a_" + anchorText;
        }
        return anchorText;
    }

    public static String buildEditLinkUrl(String context, String virtualWiki, String topic, String query, int section) throws DataAccessException {
        if (Environment.getBooleanValue("allow-capitalization")) {
            topic = StringUtils.capitalize((String)topic);
        }
        query = LinkUtil.appendQueryParam(query, "topic", topic);
        if (section > 0) {
            query = query + "&amp;section=" + section;
        }
        WikiLink wikiLink = new WikiLink();
        wikiLink.setDestination("Special:Edit");
        wikiLink.setQuery(query);
        return LinkUtil.buildTopicUrl(context, virtualWiki, wikiLink);
    }

    public static String buildHtmlLinkOpenTag(String link, String cssClass) throws ParserException {
        String target;
        String linkLower = link.toLowerCase();
        if (linkLower.startsWith("mailto://")) {
            link = "mailto:" + link.substring("mailto://".length());
        }
        String protocol = "";
        if (linkLower.startsWith("http://")) {
            protocol = "http://";
        } else if (linkLower.startsWith("https://")) {
            protocol = "https://";
        } else if (linkLower.startsWith("ftp://")) {
            protocol = "ftp://";
        } else if (linkLower.startsWith("mailto:")) {
            protocol = "mailto:";
        } else if (linkLower.startsWith("news://")) {
            protocol = "news://";
        } else if (linkLower.startsWith("telnet://")) {
            protocol = "telnet://";
        } else if (linkLower.startsWith("file://")) {
            protocol = "file://";
        } else {
            throw new ParserException("Invalid protocol in link " + link);
        }
        link = link.substring(protocol.length());
        link = StringUtils.replace((String)link, (String)"<", (String)"%3C");
        link = StringUtils.replace((String)link, (String)">", (String)"%3E");
        link = StringUtils.replace((String)link, (String)"\"", (String)"%22");
        link = StringUtils.replace((String)link, (String)"'", (String)"%27");
        String string = target = Environment.getBooleanValue("external-link-new-window") ? " target=\"_blank\"" : "";
        if (cssClass == null) {
            cssClass = "externallink";
        }
        String html = "<a class=\"" + cssClass + "\" rel=\"nofollow\"";
        html = html + " href=\"" + protocol + link + "\"" + target + ">";
        return html;
    }

    public static String buildInternalLinkHtml(String context, String virtualWiki, WikiLink wikiLink, String text, String style, String target, boolean escapeHtml) throws DataAccessException {
        String url = LinkUtil.buildTopicUrl(context, virtualWiki, wikiLink);
        String topic = wikiLink.getDestination();
        if (StringUtils.isBlank((String)text)) {
            text = topic;
        }
        if (!wikiLink.getNamespace().getId().equals(-2) && !StringUtils.isBlank((String)topic) && StringUtils.isBlank((String)style)) {
            if (WikiBase.getDataHandler().lookupInterwiki(virtualWiki) != null) {
                style = "interwiki";
            } else if (LinkUtil.isExistingArticle(virtualWiki, topic) == null) {
                style = "edit";
            }
        }
        style = !StringUtils.isBlank((String)style) ? " class=\"" + style + "\"" : "";
        target = !StringUtils.isBlank((String)target) ? " target=\"" + target + "\"" : "";
        if (StringUtils.isBlank((String)topic) && !StringUtils.isBlank((String)wikiLink.getSection())) {
            topic = wikiLink.getSection();
        }
        StringBuilder html = new StringBuilder();
        html.append("<a href=\"").append(url).append('\"').append(style);
        html.append(" title=\"").append(StringEscapeUtils.escapeHtml((String)topic)).append('\"').append(target).append('>');
        if (escapeHtml) {
            html.append(StringEscapeUtils.escapeHtml((String)text));
        } else {
            html.append(text);
        }
        html.append("</a>");
        return html.toString();
    }

    public static String buildTopicUrl(String context, String virtualWiki, String topic, boolean validateTopic) throws DataAccessException {
        if (StringUtils.isBlank((String)topic)) {
            return null;
        }
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, topic);
        if (validateTopic) {
            return LinkUtil.buildTopicUrl(context, virtualWiki, wikiLink);
        }
        return LinkUtil.buildTopicUrlNoEdit(context, virtualWiki, wikiLink.getDestination(), wikiLink.getSection(), wikiLink.getQuery());
    }

    public static String buildTopicUrl(String context, String virtualWiki, WikiLink wikiLink) throws DataAccessException {
        String url = null;
        if (wikiLink.getNamespace().getId().equals(-2)) {
            String filename = Namespace.namespace(6).getLabel(virtualWiki) + ":" + wikiLink.getArticle();
            url = ImageUtil.buildImageFileUrl(virtualWiki, filename);
            if (url == null) {
                url = LinkUtil.buildTopicUrlNoEdit(context, virtualWiki, "Special:Upload", null, "?topic=" + Utilities.encodeAndEscapeTopicName(filename));
            }
        } else {
            String topic = wikiLink.getDestination();
            String section = wikiLink.getSection();
            String query = wikiLink.getQuery();
            url = LinkUtil.buildTopicUrlNoEdit(context, virtualWiki, topic, section, query);
            if (StringUtils.isBlank((String)topic) && !StringUtils.isBlank((String)section)) {
                return url;
            }
            String targetTopic = LinkUtil.isExistingArticle(virtualWiki, topic);
            if (targetTopic == null) {
                url = LinkUtil.buildEditLinkUrl(context, virtualWiki, topic, query, -1);
            } else if (!StringUtils.equals((String)topic, (String)targetTopic)) {
                url = LinkUtil.buildTopicUrlNoEdit(context, virtualWiki, targetTopic, section, query);
            }
        }
        return url;
    }

    private static String buildTopicUrlNoEdit(String context, String virtualWiki, String topicName, String section, String queryString) {
        if (StringUtils.isBlank((String)topicName) && !StringUtils.isBlank((String)section)) {
            return "#" + LinkUtil.buildAnchorText(section);
        }
        StringBuilder url = new StringBuilder();
        if (context != null) {
            url.append(context);
        }
        url.append('/');
        url.append(Utilities.encodeAndEscapeTopicName(virtualWiki));
        url.append('/');
        url.append(Utilities.encodeAndEscapeTopicName(topicName));
        if (!StringUtils.isBlank((String)queryString)) {
            if (queryString.charAt(0) != '?') {
                url.append('?');
            }
            url.append(queryString);
        }
        if (!StringUtils.isBlank((String)section)) {
            if (section.charAt(0) != '#') {
                url.append('#');
            }
            url.append(LinkUtil.buildAnchorText(section));
        }
        return url.toString();
    }

    public static String interwiki(WikiLink wikiLink) {
        if (wikiLink.getInterwiki() == null) {
            return null;
        }
        String url = wikiLink.getInterwiki().format(wikiLink.getDestination());
        String text = wikiLink.getText();
        if (StringUtils.isBlank((String)text)) {
            text = wikiLink.getDestination();
        }
        return "<a class=\"interwiki\" title=\"" + text + "\" href=\"" + url + "\">" + text + "</a>";
    }

    public static String isExistingArticle(String virtualWiki, String articleName) throws DataAccessException {
        if (StringUtils.isBlank((String)virtualWiki) || StringUtils.isBlank((String)articleName)) {
            return null;
        }
        WikiLink wikiLink = LinkUtil.parseWikiLink(virtualWiki, articleName);
        if (PseudoTopicHandler.isPseudoTopic(wikiLink.getDestination())) {
            return articleName;
        }
        if (wikiLink.getInterwiki() != null) {
            return articleName;
        }
        if (StringUtils.isBlank((String)Environment.getValue("homeDir")) || !Environment.getBooleanValue("props-initialized")) {
            return null;
        }
        String topicName = WikiBase.getDataHandler().lookupTopicName(virtualWiki, articleName);
        if (topicName == null && Environment.getBooleanValue("allow-capitalization")) {
            String alternativeArticleName;
            String string = alternativeArticleName = StringUtils.equals((String)wikiLink.getArticle(), (String)StringUtils.capitalize((String)wikiLink.getArticle())) ? StringUtils.lowerCase((String)wikiLink.getArticle()) : StringUtils.capitalize((String)wikiLink.getArticle());
            if (!wikiLink.getNamespace().getId().equals(0)) {
                alternativeArticleName = wikiLink.getNamespace().getLabel(virtualWiki) + ":" + alternativeArticleName;
            }
            topicName = WikiBase.getDataHandler().lookupTopicName(virtualWiki, alternativeArticleName);
        }
        return topicName;
    }

    private static int prefixPosition(String topicName) {
        int prefixPosition = topicName.indexOf(":", 1);
        return prefixPosition != -1 && prefixPosition + 1 < topicName.length() ? prefixPosition : -1;
    }

    public static String normalize(String url) {
        if (StringUtils.isBlank((String)url)) {
            return url;
        }
        int pos = url.indexOf("://");
        if (pos == -1 || pos == url.length() - 1) {
            return url;
        }
        String protocol = url.substring(0, pos + "://".length());
        String remainder = url.substring(protocol.length());
        return protocol + StringUtils.replace((String)remainder, (String)"//", (String)"/");
    }

    public static WikiLink parseWikiLink(String virtualWiki, String raw) {
        int queryPos;
        String processed = raw.trim();
        WikiLink wikiLink = new WikiLink();
        if (wikiLink.getNamespace() == null) {
            throw new IllegalStateException("Unable to determine namespace for topic.  This error generally indicates a configuration or database issue.  Check the logs for additional information.");
        }
        if (StringUtils.isBlank((String)processed)) {
            return new WikiLink();
        }
        int sectionPos = processed.indexOf(35);
        if (sectionPos != -1 && sectionPos < processed.length()) {
            String sectionString = processed.substring(sectionPos + 1);
            wikiLink.setSection(sectionString);
            if (sectionPos == 0) {
                return wikiLink;
            }
            processed = processed.substring(0, sectionPos);
        }
        if ((queryPos = processed.indexOf(63, 1)) != -1 && queryPos < processed.length()) {
            String queryString = processed.substring(queryPos + 1);
            wikiLink.setQuery(queryString);
            processed = processed.substring(0, queryPos);
        }
        String topic = LinkUtil.processVirtualWiki(processed, wikiLink);
        if (wikiLink.getVirtualWiki() != null) {
            processed = topic;
            virtualWiki = wikiLink.getVirtualWiki().getName();
        }
        wikiLink.setText(processed);
        topic = LinkUtil.processNamespace(virtualWiki, topic, wikiLink);
        if (!wikiLink.getNamespace().getId().equals(0)) {
            wikiLink.setText(processed);
            processed = wikiLink.getNamespace().getLabel(virtualWiki) + ":" + topic;
        }
        if (wikiLink.getNamespace().getId().equals(0) && wikiLink.getVirtualWiki() == null) {
            topic = LinkUtil.processInterWiki(processed, wikiLink);
            if (wikiLink.getInterwiki() != null) {
                processed = topic;
                wikiLink.setText(processed);
            }
        }
        if (wikiLink.getNamespace().getId().equals(6)) {
            wikiLink.setText(null);
        } else if (!StringUtils.isBlank((String)wikiLink.getSection())) {
            wikiLink.setText(wikiLink.getText() + "#" + wikiLink.getSection());
        }
        wikiLink.setArticle(Utilities.decodeTopicName(topic, true));
        wikiLink.setDestination(Utilities.decodeTopicName(processed, true));
        return wikiLink;
    }

    private static String processInterWiki(String processed, WikiLink wikiLink) {
        int prefixPosition = processed.indexOf(":", 1);
        if (prefixPosition == -1) {
            return processed;
        }
        String linkPrefix = processed.substring(0, prefixPosition).trim();
        try {
            Interwiki interwiki = WikiBase.getDataHandler().lookupInterwiki(linkPrefix);
            if (interwiki != null) {
                wikiLink.setInterwiki(interwiki);
            }
        }
        catch (DataAccessException e) {
            logger.warn("Failure while trying to lookup interwiki: " + linkPrefix, e);
        }
        return wikiLink.getInterwiki() != null ? processed.substring(prefixPosition + ":".length()).trim() : processed;
    }

    private static String processVirtualWiki(String processed, WikiLink wikiLink) {
        int prefixPosition = processed.indexOf(":", 1);
        if (prefixPosition == -1) {
            return processed;
        }
        String linkPrefix = processed.substring(0, prefixPosition).trim();
        try {
            VirtualWiki virtualWiki = WikiBase.getDataHandler().lookupVirtualWiki(linkPrefix);
            if (virtualWiki != null) {
                wikiLink.setVirtualWiki(virtualWiki);
            }
        }
        catch (DataAccessException e) {
            logger.warn("Failure while trying to lookup virtual wiki: " + linkPrefix, e);
        }
        return wikiLink.getVirtualWiki() != null ? processed.substring(prefixPosition + ":".length()).trim() : processed;
    }

    private static String processNamespace(String virtualWiki, String processed, WikiLink wikiLink) {
        wikiLink.setNamespace(LinkUtil.retrieveTopicNamespace(virtualWiki, processed));
        if (wikiLink.getNamespace().getId().equals(0)) {
            return processed;
        }
        int prefixPosition = LinkUtil.prefixPosition(processed);
        return processed.substring(prefixPosition + ":".length()).trim();
    }

    public static Namespace retrieveTopicNamespace(String virtualWiki, String topicName) {
        int prefixPosition = LinkUtil.prefixPosition(topicName);
        if (prefixPosition == -1) {
            return Namespace.namespace(0);
        }
        String linkPrefix = topicName.substring(0, prefixPosition).trim();
        try {
            Namespace namespace = WikiBase.getDataHandler().lookupNamespace(virtualWiki, linkPrefix);
            return namespace == null ? Namespace.namespace(0) : namespace;
        }
        catch (DataAccessException e) {
            throw new IllegalStateException("Failure while trying to lookup namespace: " + linkPrefix, e);
        }
    }

    public static String retrieveTopicPageName(Namespace namespace, String virtualWiki, String topicName) {
        if (namespace.getId() == 0) {
            return topicName;
        }
        if (StringUtils.startsWithIgnoreCase((String)topicName, (String)namespace.getLabel(virtualWiki))) {
            return topicName.substring(namespace.getLabel(virtualWiki).length() + ":".length());
        }
        if (StringUtils.startsWithIgnoreCase((String)topicName, (String)namespace.getDefaultLabel())) {
            return topicName.substring(namespace.getDefaultLabel().length() + ":".length());
        }
        throw new IllegalArgumentException("Invalid topic name & namespace combination: " + namespace.getId() + " / " + topicName);
    }
}

