/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.ResourceI;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.common.Util;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;

public class ResourceImpl
implements Resource,
ResourceI {
    protected String nameSpace = null;
    protected String localName = null;
    protected String uri = null;
    protected Model model = null;
    protected AnonId id = null;

    public ResourceImpl() {
        this.assignId();
    }

    public ResourceImpl(String string) {
        this.uri = string;
        if (this.uri == null) {
            this.assignId();
        } else {
            this.splitNameSpace();
        }
    }

    public ResourceImpl(String string, String string2) {
        this.nameSpace = string;
        this.localName = string2;
        this.uri = string + string2;
    }

    public ResourceImpl(Model model) {
        this.model = model;
        this.assignId();
    }

    public ResourceImpl(AnonId anonId) {
        this.id = anonId;
    }

    public ResourceImpl(AnonId anonId, Model model) {
        this.model = model;
        this.id = anonId;
    }

    public ResourceImpl(String string, Model model) {
        this.uri = string;
        this.model = model;
        if (this.uri == null) {
            this.assignId();
        } else {
            this.splitNameSpace();
        }
    }

    public ResourceImpl(Resource resource, Model model) {
        this.uri = resource.getURI();
        try {
            this.id = resource.getId();
        }
        catch (RDFException rDFException) {
            // empty catch block
        }
        this.nameSpace = resource.getNameSpace();
        this.localName = resource.getLocalName();
        this.model = model;
    }

    public ResourceImpl(String string, String string2, Model model) {
        this.nameSpace = string;
        this.localName = string2;
        this.uri = string + string2;
        this.model = model;
    }

    protected void assignId() {
        this.id = new AnonId();
    }

    protected void splitNameSpace() {
        int n = Util.splitNamespace(this.uri);
        if (n == 0) {
            this.nameSpace = this.uri;
            this.localName = "";
        } else {
            this.nameSpace = this.uri.substring(0, n);
            this.localName = this.uri.substring(n);
        }
    }

    public AnonId getId() {
        return this.id;
    }

    public String getURI() {
        return this.uri;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String toString() {
        if (this.uri == null) {
            return "anon:" + this.id;
        }
        return this.getURI();
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            if (this.uri == null) {
                Resource resource = ((ResourceI)object).getEmbeddedResource();
                if (resource instanceof ResourceImpl) {
                    return this.id.equals(((ResourceImpl)resource).id);
                }
                return false;
            }
            return this.uri.equals(((Resource)object).getURI());
        }
        return false;
    }

    public int hashCode() {
        if (this.isAnon()) {
            return this.id.hashCode();
        }
        return this.uri.hashCode();
    }

    public boolean isAnon() {
        return this.uri == null;
    }

    public Statement getProperty(Property property) throws RDFException {
        if (this.model != null) {
            return this.model.getProperty(this, property);
        }
        throw new RDFException(1);
    }

    public StmtIterator listProperties(Property property) throws RDFException {
        if (this.model != null) {
            return this.model.listStatements(new SelectorImpl((Resource)this, property, (RDFNode)null));
        }
        throw new RDFException(1);
    }

    public StmtIterator listProperties() throws RDFException {
        if (this.model != null) {
            return this.model.listStatements(new SelectorImpl((Resource)this, null, (RDFNode)null));
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, boolean bl) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, bl);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, long l) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, l);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, char c) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, c);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, float f) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, f);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, double d) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, d);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, String string) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, string);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, String string, String string2) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, string, string2);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, Object object) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, object);
            return this;
        }
        throw new RDFException(1);
    }

    public Resource addProperty(Property property, RDFNode rDFNode) throws RDFException {
        if (this.model != null) {
            this.model.add((Resource)this, property, rDFNode);
            return this;
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property) throws RDFException {
        if (this.model != null) {
            return this.model.contains(this, property);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, boolean bl) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, bl);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, long l) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, l);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, char c) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, c);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, float f) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, f);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, double d) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, d);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, String string) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, string);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, String string, String string2) throws RDFException {
        if (this.model != null) {
            return this.model.contains(this, property, string, string2);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, Object object) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, object);
        }
        throw new RDFException(1);
    }

    public boolean hasProperty(Property property, RDFNode rDFNode) throws RDFException {
        if (this.model != null) {
            return this.model.contains((Resource)this, property, rDFNode);
        }
        throw new RDFException(1);
    }

    public Resource removeProperties() throws RDFException {
        if (this.model != null) {
            StmtIterator stmtIterator = null;
            stmtIterator = this.model.listStatements(new SelectorImpl((Resource)this, null, (RDFNode)null));
            while (stmtIterator.hasNext()) {
                stmtIterator.next();
                stmtIterator.remove();
            }
            return this;
        }
        throw new RDFException(1);
    }

    public Resource begin() throws RDFException {
        if (this.model != null) {
            this.model.begin();
            return this;
        }
        throw new RDFException(1);
    }

    public Resource abort() throws RDFException {
        if (this.model != null) {
            this.model.abort();
            return this;
        }
        throw new RDFException(1);
    }

    public Resource commit() throws RDFException {
        if (this.model != null) {
            this.model.commit();
            return this;
        }
        throw new RDFException(1);
    }

    public Resource port(Model model) throws RDFException {
        if (this.model == model) {
            return this;
        }
        return new ResourceImpl(this, model);
    }

    public Model getModel() {
        return this.model;
    }

    public Resource getEmbeddedResource() {
        return this;
    }
}

