/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.lang.reflect.Array;
import java.util.List;
import jodd.JoddBean;
import jodd.bean.BeanException;
import jodd.bean.BeanProperty;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.TypeConverterManagerBean;
import jodd.util.ReflectUtil;

class BeanUtilUtil {
    protected TypeConverterManagerBean typeConverterManager = TypeConverterManager.getDefaultTypeConverterManager();

    BeanUtilUtil() {
    }

    public void setTypeConverterManager(TypeConverterManagerBean typeConverterManager) {
        this.typeConverterManager = typeConverterManager;
    }

    protected Object convertType(Object value, Class type) {
        return this.typeConverterManager.convertType(value, type);
    }

    protected void invokeSetter(Object bean, MethodDescriptor md, Object value) {
        try {
            Class[] paramTypes = md.getRawParameterTypes();
            value = this.convertType(value, paramTypes[0]);
            md.getMethod().invoke(bean, value);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to invoke setter: " + bean.getClass().getSimpleName() + '#' + md.getMethod().getName() + "()", ex);
        }
    }

    protected Object invokeGetter(Object bean, MethodDescriptor md) {
        try {
            return md.getMethod().invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to invoke getter: " + bean.getClass().getSimpleName() + '#' + md.getMethod().getName() + "()", ex);
        }
    }

    protected void setFieldValue(Object bean, FieldDescriptor fd, Object value) {
        try {
            Class type = fd.getRawType();
            value = this.convertType(value, type);
            fd.getField().set(bean, value);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to set field: " + bean.getClass().getSimpleName() + '#' + fd.getField().getName(), ex);
        }
    }

    protected Object getFieldValue(Object bean, FieldDescriptor fd) {
        try {
            return fd.getField().get(bean);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to get field " + bean.getClass().getSimpleName() + '#' + fd.getField().getName(), ex);
        }
    }

    protected Object arrayForcedGet(BeanProperty bp, Object array, int index) {
        Object value;
        Class<?> componentType = array.getClass().getComponentType();
        if (!bp.last) {
            array = this.ensureArraySize(bp, array, componentType, index);
        }
        if ((value = Array.get(array, index)) == null) {
            try {
                value = ReflectUtil.newInstance(componentType);
            }
            catch (Exception ex) {
                throw new BeanException("Unable to create array element: " + bp.name + '[' + index + ']', bp, ex);
            }
            Array.set(array, index, value);
        }
        return value;
    }

    protected void arrayForcedSet(BeanProperty bp, Object array, int index, Object value) {
        Class<?> componentType = array.getClass().getComponentType();
        array = this.ensureArraySize(bp, array, componentType, index);
        value = this.convertType(value, componentType);
        Array.set(array, index, value);
    }

    protected Object ensureArraySize(BeanProperty bp, Object array, Class componentType, int index) {
        int len = Array.getLength(array);
        if (index >= len) {
            Object newArray = Array.newInstance(componentType, index + 1);
            System.arraycopy(array, 0, newArray, 0, len);
            MethodDescriptor setter = bp.cd.getBeanSetterMethodDescriptor(bp.name, true);
            if (setter != null) {
                this.invokeSetter(bp.bean, setter, newArray);
            } else {
                FieldDescriptor field = this.getField(bp, true);
                if (field == null) {
                    throw new BeanException("Unable to find setter or field named as: " + bp.name, bp);
                }
                this.setFieldValue(bp.bean, field, newArray);
            }
            array = newArray;
        }
        return array;
    }

    protected void ensureListSize(List list, int size) {
        for (int len = list.size(); size >= len; ++len) {
            list.add(null);
        }
    }

    protected int indexOfDot(String name) {
        int len = name.length();
        boolean insideBracket = false;
        for (int ndx = 0; ndx < len; ++ndx) {
            char c = name.charAt(ndx);
            if (insideBracket) {
                if (c != ']') continue;
                insideBracket = false;
                continue;
            }
            if (c == '.') {
                return ndx;
            }
            if (c != '[') continue;
            insideBracket = true;
        }
        return -1;
    }

    protected String extractIndex(BeanProperty bp) {
        int leftBracketNdx;
        bp.index = null;
        String name = bp.name;
        int lastNdx = name.length() - 1;
        if (lastNdx < 0) {
            return null;
        }
        if (name.charAt(lastNdx) == ']' && (leftBracketNdx = name.lastIndexOf(91)) != -1) {
            bp.name = name.substring(0, leftBracketNdx);
            bp.index = name.substring(leftBracketNdx + 1, lastNdx);
            return bp.index;
        }
        return null;
    }

    protected int parseInt(String indexString, BeanProperty bp) {
        try {
            return Integer.parseInt(indexString);
        }
        catch (NumberFormatException nfex) {
            throw new BeanException("Invalid index: " + indexString, bp, nfex);
        }
    }

    protected Object createBeanProperty(BeanProperty bp) {
        Object newInstance;
        Class type;
        MethodDescriptor setter = bp.cd.getBeanSetterMethodDescriptor(bp.name, true);
        FieldDescriptor field = null;
        if (setter != null) {
            type = setter.getRawParameterTypes()[0];
        } else {
            field = this.getField(bp, true);
            if (field == null) {
                return null;
            }
            type = field.getRawType();
        }
        try {
            newInstance = ReflectUtil.newInstance(type);
        }
        catch (Exception ex) {
            throw new BeanException("Unable to create property: " + bp.name, bp, ex);
        }
        if (setter != null) {
            this.invokeSetter(bp.bean, setter, newInstance);
        } else {
            this.setFieldValue(bp.bean, field, newInstance);
        }
        return newInstance;
    }

    protected Class extractGenericComponentType(BeanProperty bp) {
        Class<Object> componentType = null;
        if (bp.field != null) {
            componentType = bp.field.getRawComponentType();
        } else if (bp.method != null) {
            componentType = bp.method.getRawReturnComponentType();
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        return componentType;
    }

    protected Object convertIndexToMapKey(Object index, BeanProperty bp) {
        Class<Object> indexType = null;
        if (bp.field != null) {
            indexType = bp.field.getRawKeyComponentType();
        } else if (bp.method != null) {
            indexType = bp.method.getRawReturnKeyComponentType();
        }
        if (indexType == null) {
            indexType = Object.class;
        }
        if (indexType == Object.class) {
            return index;
        }
        try {
            return this.convertType(index, indexType);
        }
        catch (Exception ignore) {
            return index;
        }
    }

    protected Class extractType(BeanProperty bp) {
        if (bp.field != null) {
            if (bp.index != null) {
                Class type = bp.field.getRawComponentType();
                return type == null ? Object.class : type;
            }
            return bp.field.getRawType();
        }
        if (bp.method != null) {
            if (bp.index != null) {
                Class type = bp.method.getRawReturnComponentType();
                return type == null ? Object.class : type;
            }
            return bp.method.getRawReturnType();
        }
        return null;
    }

    protected FieldDescriptor getField(BeanProperty bp, boolean declared) {
        String fieldName = bp.name;
        if (JoddBean.fieldPrefix != null) {
            fieldName = JoddBean.fieldPrefix + fieldName;
        }
        return bp.cd.getFieldDescriptor(fieldName, declared);
    }
}

