/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import java.io.Serializable;

public class ShortArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final short[] EMPTY_ARRAY = new short[0];
    public static final Hash.Strategy<short[]> HASH_STRATEGY = new ArrayHashStrategy();

    private ShortArrays() {
    }

    public static short[] ensureCapacity(short[] array, int length) {
        if (length > array.length) {
            short[] t = new short[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static short[] ensureCapacity(short[] array, int length, int preserve) {
        if (length > array.length) {
            short[] t = new short[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static short[] grow(short[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            short[] t = new short[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static short[] grow(short[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            short[] t = new short[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static short[] trim(short[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        short[] t = length == 0 ? EMPTY_ARRAY : new short[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static short[] setLength(short[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ShortArrays.trim(array, length);
        }
        return ShortArrays.ensureCapacity(array, length);
    }

    public static short[] copy(short[] array, int offset, int length) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        short[] a = length == 0 ? EMPTY_ARRAY : new short[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static short[] copy(short[] array) {
        return (short[])array.clone();
    }

    public static void fill(short[] array, short value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(short[] array, int from, int to, short value) {
        ShortArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(short[] a1, short[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(short[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(short[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<short[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(short[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(short[] a, short[] b) {
            return ShortArrays.equals(a, b);
        }
    }
}

