/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.blobstorage.service.operation;

import java.io.OutputStream;
import org.gcube.contentmanagement.blobstorage.resource.MyFile;
import org.gcube.contentmanagement.blobstorage.service.directoryOperation.BucketCoding;
import org.gcube.contentmanagement.blobstorage.service.operation.Download;
import org.gcube.contentmanagement.blobstorage.service.operation.Monitor;
import org.gcube.contentmanagement.blobstorage.service.operation.Operation;
import org.gcube.contentmanagement.blobstorage.transport.TransportManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.MongoIOManager;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanagement.blobstorage.transport.backend.operation.DownloadOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Lock
extends Operation {
    final Logger logger = LoggerFactory.getLogger(Download.class);
    protected String localPath;
    protected String remotePath;
    protected OutputStream os;
    protected MyFile resource;
    protected Download download;

    public Lock(String[] server, String user, String pwd, String bucket, Monitor monitor, boolean isChunk, String backendType, String[] dbs) {
        super(server, user, pwd, bucket, monitor, isChunk, backendType, dbs);
    }

    @Override
    public String doIt(MyFile myFile) throws RemoteBackendException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" DOWNLOAD " + myFile.getRemotePath() + " in bucket: " + this.getBucket());
        }
        String unlockKey = null;
        try {
            DownloadOperator download = new DownloadOperator(this.getServer(), this.getUser(), this.getPassword(), this.getBucket(), this.getMonitor(), this.isChunk(), this.getBackendType(), this.getDbNames());
            unlockKey = this.get(download, myFile, true);
        }
        catch (Exception e) {
            TransportManager tm = this.getTransport(myFile);
            tm.close();
            throw new RemoteBackendException(" Error in lock operation ", e.getCause());
        }
        return unlockKey;
    }

    @Override
    public String initOperation(MyFile file, String remotePath, String author, String[] server, String rootArea, boolean replaceOption) {
        String bucketName = null;
        this.setResource(file);
        if (remotePath.length() < 23 || remotePath.contains("/")) {
            this.localPath = file.getLocalPath();
            this.remotePath = remotePath;
            bucketName = new BucketCoding().bucketFileCoding(remotePath, rootArea);
        } else {
            bucketName = remotePath;
        }
        this.setBucket(bucketName);
        return bucketName;
    }

    @Override
    public String initOperation(MyFile resource, String RemotePath, String author, String[] server, String rootArea) {
        return null;
    }

    public abstract String execute(MongoIOManager var1, MongoIOManager var2, MyFile var3, String var4) throws Exception;

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public void setRemotePath(String remotePath) {
        this.remotePath = remotePath;
    }

    public OutputStream getOs() {
        return this.os;
    }

    public void setOs(OutputStream os) {
        this.os = os;
    }

    public MyFile getResource() {
        return this.resource;
    }

    public void setResource(MyFile resource) {
        this.resource = resource;
    }

    public Download getDownload() {
        return this.download;
    }

    public void setDownload(Download download) {
        this.download = download;
    }
}

