/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.MediaListenerAdapter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.event.IVideoPictureEvent;
import com.xuggle.xuggler.Global;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class DecodeAndCaptureFrames
extends MediaListenerAdapter {
    public static final double SECONDS_BETWEEN_FRAMES = 5.0;
    public static final long MICRO_SECONDS_BETWEEN_FRAMES = (long)((double)Global.DEFAULT_PTS_PER_SECOND * 5.0);
    private static long mLastPtsWrite = Global.NO_PTS;
    private int mVideoStreamIndex = -1;

    public static void main(String[] args) {
        if (args.length <= 0) {
            throw new IllegalArgumentException("must pass in a filename as the first argument");
        }
        new DecodeAndCaptureFrames(args[0]);
    }

    public DecodeAndCaptureFrames(String filename) {
        IMediaReader reader = ToolFactory.makeReader(filename);
        reader.setBufferedImageTypeToGenerate(5);
        reader.addListener(this);
        while (reader.readPacket() == null) {
        }
    }

    @Override
    public void onVideoPicture(IVideoPictureEvent event) {
        try {
            if (event.getStreamIndex() != this.mVideoStreamIndex) {
                if (-1 == this.mVideoStreamIndex) {
                    this.mVideoStreamIndex = event.getStreamIndex();
                } else {
                    return;
                }
            }
            if (mLastPtsWrite == Global.NO_PTS) {
                mLastPtsWrite = event.getTimeStamp() - MICRO_SECONDS_BETWEEN_FRAMES;
            }
            if (event.getTimeStamp() - mLastPtsWrite >= MICRO_SECONDS_BETWEEN_FRAMES) {
                File file = File.createTempFile("frame", ".png");
                ImageIO.write((RenderedImage)event.getImage(), "png", file);
                double seconds = (double)event.getTimeStamp().longValue() / (double)Global.DEFAULT_PTS_PER_SECOND;
                System.out.printf("at elapsed time of %6.3f seconds wrote: %s\n", seconds, file);
                mLastPtsWrite += MICRO_SECONDS_BETWEEN_FRAMES;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

