/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.util.PortalUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

public class DefaultFriendlyURLMapper
extends BaseFriendlyURLMapper {
    protected Set<String> defaultIgnoredParameters = new LinkedHashSet<String>();
    protected Map<String, String> defaultReservedParameters;
    private static Log _log = LogFactoryUtil.getLog(DefaultFriendlyURLMapper.class);

    public DefaultFriendlyURLMapper() {
        this.defaultIgnoredParameters.add("p_p_id");
        this.defaultIgnoredParameters.add("p_p_col_id");
        this.defaultIgnoredParameters.add("p_p_col_pos");
        this.defaultIgnoredParameters.add("p_p_col_count");
        this.defaultReservedParameters = new LinkedHashMap<String, String>();
        this.defaultReservedParameters.put("p_p_lifecycle", "0");
        this.defaultReservedParameters.put("p_p_state", WindowState.NORMAL.toString());
        this.defaultReservedParameters.put("p_p_mode", PortletMode.VIEW.toString());
    }

    public void addDefaultIgnoredParameter(String name) {
        this.defaultIgnoredParameters.add(name);
    }

    public void addDefaultReservedParameter(String name, String value) {
        this.defaultReservedParameters.put(name, value);
    }

    @Override
    public String buildPath(LiferayPortletURL liferayPortletURL) {
        HashMap<String, String> routeParameters = new HashMap<String, String>();
        this.buildRouteParameters(liferayPortletURL, routeParameters);
        String friendlyURLPath = this.router.parametersToUrl(routeParameters);
        if (Validator.isNull(friendlyURLPath)) {
            return null;
        }
        this.addParametersIncludedInPath(liferayPortletURL, routeParameters);
        friendlyURLPath = "/".concat(this.getMapping()).concat(friendlyURLPath);
        return friendlyURLPath;
    }

    public Set<String> getDefaultIgnoredParameters() {
        return this.defaultIgnoredParameters;
    }

    public Map<String, String> getDefaultReservedParameters() {
        return this.defaultReservedParameters;
    }

    @Override
    public void populateParams(String friendlyURLPath, Map<String, String[]> parameterMap, Map<String, Object> requestContext) {
        HashMap<String, String> routeParameters;
        if ((friendlyURLPath = friendlyURLPath.substring(this.getMapping().length() + 1)).endsWith("/")) {
            friendlyURLPath = friendlyURLPath.substring(0, friendlyURLPath.length() - 1);
        }
        if (!this.router.urlToParameters(friendlyURLPath, routeParameters = new HashMap<String, String>())) {
            if (_log.isWarnEnabled()) {
                _log.warn("No route could be found to match URL " + friendlyURLPath);
            }
            return;
        }
        String portletId = this.getPortletId(routeParameters);
        if (Validator.isNull(portletId)) {
            return;
        }
        String namespace = PortalUtil.getPortletNamespace(portletId);
        this.addParameter(namespace, parameterMap, "p_p_id", portletId);
        this.populateParams(parameterMap, namespace, routeParameters);
    }

    protected void addParametersIncludedInPath(LiferayPortletURL liferayPortletURL, Map<String, String> routeParameters) {
        for (String name : this.defaultIgnoredParameters) {
            liferayPortletURL.addParameterIncludedInPath(name);
        }
        Map portletURLParameters = liferayPortletURL.getParameterMap();
        for (String name : portletURLParameters.keySet()) {
            if (routeParameters.containsKey(name)) continue;
            liferayPortletURL.addParameterIncludedInPath(name);
        }
        Map<String, String> reservedParameters = liferayPortletURL.getReservedParameterMap();
        for (Map.Entry<String, String> entry : reservedParameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (routeParameters.containsKey(key) && !value.equals(this.defaultReservedParameters.get(key))) continue;
            liferayPortletURL.addParameterIncludedInPath(key);
        }
    }

    protected void buildRouteParameters(LiferayPortletURL liferayPortletURL, Map<String, String> routeParameters) {
        Map portletURLParameters = liferayPortletURL.getParameterMap();
        for (Map.Entry entry : portletURLParameters.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values.length <= 0) continue;
            routeParameters.put((String)entry.getKey(), values[0]);
        }
        if (this.isPortletInstanceable()) {
            String portletId = liferayPortletURL.getPortletId();
            routeParameters.put("p_p_id", portletId);
            if (Validator.isNotNull(portletId) && PortletConstants.hasInstanceId(portletId)) {
                routeParameters.put("instanceId", PortletConstants.getInstanceId(portletId));
            }
        }
        routeParameters.putAll(liferayPortletURL.getReservedParameterMap());
    }

    protected String getPortletId(Map<String, String> routeParameters) {
        if (!this.isPortletInstanceable()) {
            return this.getPortletId();
        }
        String portletId = routeParameters.remove("p_p_id");
        if (Validator.isNotNull(portletId)) {
            return portletId;
        }
        String instanceId = routeParameters.remove("instanceId");
        if (Validator.isNull(instanceId)) {
            if (_log.isErrorEnabled()) {
                _log.error("Either p_p_id or instanceId must be provided for an instanceable portlet");
            }
            return null;
        }
        return PortletConstants.assemblePortletId(this.getPortletId(), instanceId);
    }

    protected void populateParams(Map<String, String[]> parameterMap, String namespace, Map<String, String> routeParameters) {
        for (Map.Entry<String, String> entry : routeParameters.entrySet()) {
            this.addParameter(namespace, parameterMap, entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.defaultReservedParameters.entrySet()) {
            String key = entry.getKey();
            if (parameterMap.containsKey(key)) continue;
            this.addParameter(namespace, parameterMap, key, entry.getValue());
        }
    }
}

